/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.components.treeprocessor.sitemap;

import java.util.Map;
import org.apache.avalon.framework.activity.Initializable;
import org.apache.avalon.framework.component.ComponentException;
import org.apache.avalon.framework.component.ComponentManager;
import org.apache.avalon.framework.component.Composable;
import org.apache.cocoon.components.treeprocessor.AbstractProcessingNode;
import org.apache.cocoon.components.treeprocessor.CategoryNode;
import org.apache.cocoon.components.treeprocessor.InvokeContext;
import org.apache.cocoon.components.treeprocessor.ParameterizableProcessingNode;
import org.apache.cocoon.components.treeprocessor.ProcessingNode;
import org.apache.cocoon.components.treeprocessor.variables.VariableResolver;
import org.apache.cocoon.components.treeprocessor.variables.VariableResolverFactory;
import org.apache.cocoon.environment.Environment;

public class CallNode
extends AbstractProcessingNode
implements Initializable,
ParameterizableProcessingNode,
Composable {
    private ComponentManager manager;
    private Map parameters;
    private String resourceName;
    private VariableResolver resourceResolver;
    private CategoryNode resources;
    private ProcessingNode resourceNode;

    public void compose(ComponentManager manager) throws ComponentException {
        this.manager = manager;
    }

    public void setParameters(Map parameterMap) {
        this.parameters = parameterMap;
    }

    public void setResource(CategoryNode resources, String resourceName) throws Exception {
        this.resourceName = resourceName;
        this.resources = resources;
    }

    public void initialize() throws Exception {
        if (VariableResolverFactory.needsResolve(this.resourceName)) {
            this.resourceResolver = VariableResolverFactory.getResolver(this.resourceName, this.manager);
        } else {
            this.resourceNode = this.resources.getNodeByName(VariableResolverFactory.unescape(this.resourceName));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean invoke(Environment env, InvokeContext context) throws Exception {
        Map objectModel = env.getObjectModel();
        Map params = VariableResolver.buildMap(this.parameters, context, objectModel);
        if (this.resourceNode != null) {
            context.pushMap(null, params);
            try {
                boolean bl = this.resourceNode.invoke(env, context);
                Object var7_7 = null;
                context.popMap();
                return bl;
            }
            catch (Throwable throwable) {
                Object var7_8 = null;
                context.popMap();
                throw throwable;
            }
        }
        String name = this.resourceResolver.resolve(context, objectModel);
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("Calling resource " + name);
        }
        context.pushMap(null, params);
        try {
            boolean bl = this.resources.invokeByName(name, env, context);
            Object var9_11 = null;
            context.popMap();
            return bl;
        }
        catch (Throwable throwable) {
            Object var9_12 = null;
            context.popMap();
            throw throwable;
        }
    }
}

