/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.ant;

import java.io.File;
import java.io.IOException;
import java.util.Map;
import java.util.Stack;
import org.apache.avalon.framework.activity.Initializable;
import org.apache.avalon.framework.context.Context;
import org.apache.avalon.framework.context.ContextException;
import org.apache.avalon.framework.context.Contextualizable;
import org.apache.avalon.framework.logger.AbstractLogEnabled;
import org.apache.avalon.framework.parameters.ParameterException;
import org.apache.avalon.framework.parameters.Parameterizable;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.avalon.framework.thread.ThreadSafe;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.environment.ObjectModelHelper;
import org.apache.cocoon.environment.SourceResolver;
import org.apache.cocoon.environment.http.HttpContext;
import org.apache.cocoon.generation.Generator;
import org.apache.cocoon.xml.XMLConsumer;
import org.apache.tools.ant.BuildEvent;
import org.apache.tools.ant.BuildListener;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.ProjectHelper;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class AntBuildGenerator
extends AbstractLogEnabled
implements Generator,
BuildListener,
Parameterizable,
Initializable,
Contextualizable,
ThreadSafe {
    private static final String LOG_PARAM_NAME = "log-level";
    private static final String DEFAULT_LOG_PARAM_NAME = "default-log-level";
    private static final String BUILD_FILE_PARAM_NAME = "build-file";
    private static final String DEFAULT_BUILD_FILE = "WEB-INF/build.xml";
    private static final String BUILD = "build";
    private static final String TARGET = "target";
    private static final String TASK = "task";
    private static final String MESSAGE = "message";
    private static final String NAME = "name";
    private static final String PRIORITY = "priority";
    private static final String ERROR = "error";
    private static final String WARN = "warn";
    private static final String INFO = "info";
    private static final String VERBOSE = "verbose";
    private static final String DEBUG = "debug";
    private static final String CDATA = "CDATA";
    private static final AttributesImpl EMPTY_ATTRS = new AttributesImpl();
    private static final AttributesImpl MSSG_ATTRS = new AttributesImpl();
    private static final AttributesImpl NAME_ATTRS = new AttributesImpl();
    private File myBuildFile;
    private String myBuildFileName;
    private HttpContext myContext;
    private int myDefaultPriorityLevel;
    private SAXException mySAXException;
    private XMLConsumer myConsumer;
    private int myPriorityLevel;
    private Stack myStack = new Stack();
    private String target;
    private ThreadLocal myThreadPriorityLevel;
    private ThreadLocal myThreadTarget;

    public void contextualize(Context aContext) throws ContextException {
        this.myContext = (HttpContext)aContext.get((Object)"environment-context");
    }

    public void parameterize(Parameters aParams) throws ParameterException {
        this.myDefaultPriorityLevel = aParams.getParameterAsInteger(DEFAULT_LOG_PARAM_NAME, 2);
        this.myBuildFileName = aParams.getParameter(BUILD_FILE_PARAM_NAME, DEFAULT_BUILD_FILE);
    }

    public void initialize() throws Exception {
        this.myThreadTarget = new ThreadLocal();
        this.myThreadPriorityLevel = new ThreadLocal();
        this.myBuildFile = new File(this.myContext.getRealPath(this.myBuildFileName));
    }

    public void setup(SourceResolver aResolver, Map aMap, String aString, Parameters aParams) throws ProcessingException, SAXException, IOException {
        String target;
        String requestPriority = ObjectModelHelper.getRequest((Map)aMap).getParameter(LOG_PARAM_NAME);
        int priorityLevel = this.myDefaultPriorityLevel;
        if (requestPriority != null) {
            if (requestPriority.equals(ERROR)) {
                priorityLevel = 0;
            } else if (requestPriority.equals(WARN)) {
                priorityLevel = 1;
            } else if (requestPriority.equals(INFO)) {
                priorityLevel = 2;
            } else if (requestPriority.equals(VERBOSE)) {
                priorityLevel = 3;
            } else if (requestPriority.equals(DEBUG)) {
                priorityLevel = 4;
            }
        }
        if ((target = ObjectModelHelper.getRequest((Map)aMap).getParameter(TARGET)) == null) {
            target = "";
        }
        this.myThreadTarget.set(target);
        this.myThreadPriorityLevel.set(new Integer(priorityLevel));
    }

    public void setConsumer(XMLConsumer aConsumer) {
        this.myConsumer = aConsumer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized void generate() throws IOException, SAXException, ProcessingException {
        this.myPriorityLevel = (Integer)this.myThreadPriorityLevel.get();
        this.target = (String)this.myThreadTarget.get();
        try {
            block8: {
                try {
                    this.myConsumer.startDocument();
                    Project theProject = new Project();
                    theProject.addBuildListener((BuildListener)this);
                    theProject.fireBuildStarted();
                    theProject.init();
                    ProjectHelper helper = ProjectHelper.getProjectHelper();
                    helper.parse(theProject, (Object)this.myBuildFile);
                    if (this.target.equals("")) {
                        this.target = theProject.getDefaultTarget();
                    }
                    if (this.getLogger().isDebugEnabled()) {
                        this.getLogger().debug("executing target " + this.target + " with log priority level " + this.myPriorityLevel);
                    }
                    theProject.executeTarget(this.target);
                    theProject.fireBuildFinished((Throwable)this.mySAXException);
                    break block8;
                }
                catch (Exception e) {
                    this.getLogger().error(e.getMessage(), (Throwable)e);
                }
                while (true) {
                    if (this.myStack.isEmpty()) break;
                    String tag = (String)this.myStack.pop();
                    this.myConsumer.endElement("", tag, tag);
                }
                Object var4_6 = null;
                this.myConsumer.endDocument();
                this.mySAXException = null;
                return;
            }
            Object var4_5 = null;
        }
        catch (Throwable throwable) {
            Object var4_7 = null;
            this.myConsumer.endDocument();
            this.mySAXException = null;
            throw throwable;
        }
        this.myConsumer.endDocument();
        this.mySAXException = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void buildStarted(BuildEvent anEvent) {
        try {
            try {
                this.myConsumer.startElement("", BUILD, BUILD, (Attributes)EMPTY_ATTRS);
            }
            catch (SAXException e) {
                this.getLogger().error(e.getMessage(), (Throwable)e);
                if (this.mySAXException == null) {
                    this.mySAXException = e;
                }
                Object var4_3 = null;
                this.myStack.push(BUILD);
                return;
            }
            Object var4_2 = null;
            this.myStack.push(BUILD);
            return;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.myStack.push(BUILD);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void buildFinished(BuildEvent anEvent) {
        try {
            try {
                this.myConsumer.endElement("", BUILD, BUILD);
            }
            catch (SAXException e) {
                this.getLogger().error(e.getMessage(), (Throwable)e);
                if (this.mySAXException == null) {
                    this.mySAXException = e;
                }
                Object var4_3 = null;
                this.myStack.pop();
                return;
            }
            Object var4_2 = null;
            this.myStack.pop();
            return;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.myStack.pop();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void targetStarted(BuildEvent anEvent) {
        if (anEvent.getPriority() > this.myPriorityLevel) {
            return;
        }
        try {
            try {
                NAME_ATTRS.setValue(0, anEvent.getTarget().getName());
                this.myConsumer.startElement("", TARGET, TARGET, (Attributes)NAME_ATTRS);
            }
            catch (SAXException e) {
                this.getLogger().error(e.getMessage(), (Throwable)e);
                if (this.mySAXException == null) {
                    this.mySAXException = e;
                }
                Object var4_3 = null;
                this.myStack.push(TARGET);
                return;
            }
            Object var4_2 = null;
            this.myStack.push(TARGET);
            return;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.myStack.push(TARGET);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void targetFinished(BuildEvent anEvent) {
        if (anEvent.getPriority() > this.myPriorityLevel) {
            return;
        }
        try {
            try {
                this.myConsumer.endElement("", TARGET, TARGET);
            }
            catch (SAXException e) {
                this.getLogger().error(e.getMessage(), (Throwable)e);
                if (this.mySAXException == null) {
                    this.mySAXException = e;
                }
                Object var4_3 = null;
                this.myStack.pop();
                return;
            }
            Object var4_2 = null;
            this.myStack.pop();
            return;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.myStack.pop();
            throw throwable;
        }
    }

    public void taskStarted(BuildEvent anEvent) {
        block3: {
            if (anEvent.getPriority() > this.myPriorityLevel) {
                return;
            }
            try {
                NAME_ATTRS.setValue(0, anEvent.getTask().getTaskName());
                this.myConsumer.startElement("", TASK, TASK, (Attributes)NAME_ATTRS);
            }
            catch (SAXException e) {
                this.getLogger().error(e.getMessage(), (Throwable)e);
                if (this.mySAXException != null) break block3;
                this.mySAXException = e;
            }
        }
        this.myStack.push(TASK);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void taskFinished(BuildEvent anEvent) {
        if (anEvent.getPriority() > this.myPriorityLevel) {
            return;
        }
        try {
            try {
                this.myConsumer.endElement("", TASK, TASK);
            }
            catch (SAXException e) {
                this.getLogger().error(e.getMessage(), (Throwable)e);
                if (this.mySAXException == null) {
                    this.mySAXException = e;
                }
                Object var4_3 = null;
                this.myStack.pop();
                return;
            }
            Object var4_2 = null;
            this.myStack.pop();
            return;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.myStack.pop();
            throw throwable;
        }
    }

    public void messageLogged(BuildEvent anEvent) {
        block9: {
            if (anEvent.getPriority() > this.myPriorityLevel) {
                return;
            }
            String value = DEBUG;
            switch (anEvent.getPriority()) {
                case 0: {
                    value = ERROR;
                    break;
                }
                case 1: {
                    value = WARN;
                    break;
                }
                case 2: {
                    value = INFO;
                    break;
                }
                case 3: {
                    value = VERBOSE;
                }
            }
            MSSG_ATTRS.setValue(0, value);
            String message = anEvent.getMessage();
            try {
                this.myConsumer.startElement("", MESSAGE, MESSAGE, (Attributes)MSSG_ATTRS);
                this.myConsumer.startCDATA();
                this.myConsumer.characters(message.toCharArray(), 0, message.length());
                this.myConsumer.endCDATA();
                this.myConsumer.endElement("", MESSAGE, MESSAGE);
            }
            catch (SAXException e) {
                this.getLogger().error(e.getMessage(), (Throwable)e);
                if (this.mySAXException != null) break block9;
                this.mySAXException = e;
            }
        }
    }

    static {
        MSSG_ATTRS.addAttribute("", PRIORITY, PRIORITY, CDATA, null);
        NAME_ATTRS.addAttribute("", NAME, NAME, CDATA, null);
    }
}

