/*
 * Decompiled with CFR 0.152.
 */
package org.apache.excalibur.xml.sax;

import java.io.IOException;
import java.util.Properties;
import org.apache.avalon.framework.activity.Initializable;
import org.apache.avalon.framework.component.Component;
import org.apache.avalon.framework.configuration.Configurable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.logger.AbstractLogEnabled;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;
import org.apache.avalon.framework.thread.ThreadSafe;
import org.apache.excalibur.xml.dom.DOMSerializer;
import org.apache.excalibur.xml.sax.SAXParser;
import org.w3c.dom.Document;
import org.w3c.tidy.Tidy;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.ext.LexicalHandler;

public final class JTidyHTMLParser
extends AbstractLogEnabled
implements SAXParser,
Serviceable,
Configurable,
Initializable,
ThreadSafe,
Component {
    private DOMSerializer m_serializer;
    private Tidy m_tidy;
    private Properties m_properties;

    public void service(ServiceManager serviceManager) throws ServiceException {
        this.m_serializer = (DOMSerializer)serviceManager.lookup(DOMSerializer.ROLE);
    }

    public void configure(Configuration configuration) throws ConfigurationException {
        Parameters parameters = Parameters.fromConfiguration((Configuration)configuration);
        this.m_properties = Parameters.toProperties((Parameters)parameters);
    }

    public void initialize() throws Exception {
        this.m_tidy = new Tidy();
        this.m_tidy.setXmlOut(true);
        this.m_tidy.setXHTML(true);
        this.m_tidy.setShowWarnings(false);
        this.m_tidy.setConfigurationFromProps(this.m_properties);
    }

    public void parse(InputSource in, ContentHandler contentHandler, LexicalHandler lexicalHandler) throws SAXException, IOException {
        Document document = this.m_tidy.parseDOM(in.getByteStream(), null);
        this.m_serializer.serialize(document, contentHandler, lexicalHandler);
    }

    public void parse(InputSource in, ContentHandler consumer) throws SAXException, IOException {
        this.parse(in, consumer, consumer instanceof LexicalHandler ? (LexicalHandler)((Object)consumer) : null);
    }
}

