/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jxpath.ri.axes;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.jxpath.JXPathException;
import org.apache.commons.jxpath.ri.EvalContext;
import org.apache.commons.jxpath.ri.InfoSetUtil;
import org.apache.commons.jxpath.ri.QName;
import org.apache.commons.jxpath.ri.compiler.Expression;
import org.apache.commons.jxpath.ri.compiler.NameAttributeTest;
import org.apache.commons.jxpath.ri.compiler.NodeNameTest;
import org.apache.commons.jxpath.ri.compiler.Step;
import org.apache.commons.jxpath.ri.model.NodeIterator;
import org.apache.commons.jxpath.ri.model.NodePointer;
import org.apache.commons.jxpath.ri.model.beans.LangAttributePointer;
import org.apache.commons.jxpath.ri.model.beans.NullElementPointer;
import org.apache.commons.jxpath.ri.model.beans.NullPropertyPointer;
import org.apache.commons.jxpath.ri.model.beans.PropertyOwnerPointer;
import org.apache.commons.jxpath.ri.model.beans.PropertyPointer;

public class SimplePathInterpreter {
    private static final QName QNAME_NAME = new QName(null, "name");
    private static final int PERFECT_MATCH = 1000;

    public static NodePointer interpretSimpleLocationPath(EvalContext context, NodePointer root, Step[] steps) {
        NodePointer pointer = SimplePathInterpreter.doStep(context, root, steps, 0);
        return pointer;
    }

    public static NodePointer interpretSimpleExpressionPath(EvalContext context, NodePointer root, Expression[] predicates, Step[] steps) {
        NodePointer pointer = SimplePathInterpreter.doPredicate(context, root, steps, -1, predicates, 0);
        return pointer;
    }

    private static NodePointer doStep(EvalContext context, NodePointer parent, Step[] steps, int currentStep) {
        if (parent == null) {
            return null;
        }
        if (currentStep == steps.length) {
            return parent;
        }
        parent = SimplePathInterpreter.valuePointer(parent);
        Step step = steps[currentStep];
        Expression[] predicates = step.getPredicates();
        if (parent instanceof PropertyOwnerPointer) {
            if (predicates == null || predicates.length == 0) {
                return SimplePathInterpreter.doStepNoPredicatesPropertyOwner(context, (PropertyOwnerPointer)parent, steps, currentStep);
            }
            return SimplePathInterpreter.doStepPredicatesPropertyOwner(context, (PropertyOwnerPointer)parent, steps, currentStep);
        }
        if (predicates == null || predicates.length == 0) {
            return SimplePathInterpreter.doStepNoPredicatesStandard(context, parent, steps, currentStep);
        }
        return SimplePathInterpreter.doStepPredicatesStandard(context, parent, steps, currentStep);
    }

    private static NodePointer doStepNoPredicatesPropertyOwner(EvalContext context, PropertyOwnerPointer parentPointer, Step[] steps, int currentStep) {
        Step step = steps[currentStep];
        NodePointer childPointer = SimplePathInterpreter.createChildPointerForStep(parentPointer, step);
        if (!childPointer.isActual()) {
            return SimplePathInterpreter.createNullPointer(context, parentPointer, steps, currentStep);
        }
        if (currentStep == steps.length - 1) {
            return childPointer;
        }
        if (childPointer.isCollection()) {
            int bestQuality = 0;
            childPointer = (NodePointer)childPointer.clone();
            NodePointer bestMatch = null;
            int count = childPointer.getLength();
            int i = 0;
            while (i < count) {
                childPointer.setIndex(i);
                NodePointer pointer = SimplePathInterpreter.doStep(context, childPointer, steps, currentStep + 1);
                int quality = SimplePathInterpreter.computeQuality(pointer);
                if (quality == 1000) {
                    return pointer;
                }
                if (quality > bestQuality) {
                    bestQuality = quality;
                    bestMatch = (NodePointer)pointer.clone();
                }
                ++i;
            }
            if (bestMatch != null) {
                return bestMatch;
            }
            return SimplePathInterpreter.createNullPointer(context, childPointer, steps, currentStep);
        }
        return SimplePathInterpreter.doStep(context, childPointer, steps, currentStep + 1);
    }

    private static NodePointer doStepNoPredicatesStandard(EvalContext context, NodePointer parentPointer, Step[] steps, int currentStep) {
        Step step = steps[currentStep];
        if (step.getAxis() == 1) {
            return SimplePathInterpreter.doStep(context, parentPointer, steps, currentStep + 1);
        }
        int bestQuality = 0;
        NodePointer bestMatch = null;
        NodeIterator it = SimplePathInterpreter.getNodeIterator(parentPointer, step);
        if (it != null) {
            int i = 1;
            while (it.setPosition(i)) {
                NodePointer childPointer = it.getNodePointer();
                if (steps.length == currentStep + 1) {
                    return childPointer;
                }
                NodePointer pointer = SimplePathInterpreter.doStep(context, childPointer, steps, currentStep + 1);
                int quality = SimplePathInterpreter.computeQuality(pointer);
                if (quality == 1000) {
                    return pointer;
                }
                if (quality > bestQuality) {
                    bestQuality = quality;
                    bestMatch = (NodePointer)pointer.clone();
                }
                ++i;
            }
        }
        if (bestMatch != null) {
            return bestMatch;
        }
        return SimplePathInterpreter.createNullPointer(context, parentPointer, steps, currentStep);
    }

    private static NodePointer doStepPredicatesPropertyOwner(EvalContext context, PropertyOwnerPointer parentPointer, Step[] steps, int currentStep) {
        Step step = steps[currentStep];
        Expression[] predicates = step.getPredicates();
        NodePointer childPointer = SimplePathInterpreter.createChildPointerForStep(parentPointer, step);
        if (!childPointer.isActual()) {
            return SimplePathInterpreter.createNullPointer(context, parentPointer, steps, currentStep);
        }
        return SimplePathInterpreter.doPredicate(context, childPointer, steps, currentStep, predicates, 0);
    }

    private static NodePointer createChildPointerForStep(PropertyOwnerPointer parentPointer, Step step) {
        int axis = step.getAxis();
        if (axis == 2 || axis == 5) {
            NodePointer childPointer;
            QName name = ((NodeNameTest)step.getNodeTest()).getNodeName();
            if (axis == 5 && SimplePathInterpreter.isLangAttribute(name)) {
                childPointer = new LangAttributePointer(parentPointer);
            } else {
                childPointer = parentPointer.getPropertyPointer();
                ((PropertyPointer)childPointer).setPropertyName(name.toString());
                childPointer.setAttribute(axis == 5);
            }
            return childPointer;
        }
        return parentPointer;
    }

    private static NodePointer doStepPredicatesStandard(EvalContext context, NodePointer parent, Step[] steps, int currentStep) {
        Step step = steps[currentStep];
        Expression[] predicates = step.getPredicates();
        int axis = step.getAxis();
        if (axis == 1) {
            return SimplePathInterpreter.doPredicate(context, parent, steps, currentStep, predicates, 0);
        }
        Expression predicate = predicates[0];
        if (predicates.length == 1) {
            NodeIterator it = SimplePathInterpreter.getNodeIterator(parent, step);
            NodePointer pointer = null;
            if (it != null) {
                if (predicate instanceof NameAttributeTest) {
                    String key = SimplePathInterpreter.keyFromPredicate(context, predicate);
                    int i = 1;
                    while (it.setPosition(i)) {
                        NodePointer ptr = it.getNodePointer();
                        if (SimplePathInterpreter.isNameAttributeEqual(ptr, key)) {
                            pointer = ptr;
                            break;
                        }
                        ++i;
                    }
                } else {
                    int index = SimplePathInterpreter.indexFromPredicate(context, predicate);
                    if (it.setPosition(index + 1)) {
                        pointer = it.getNodePointer();
                    }
                }
            }
            if (pointer != null) {
                return SimplePathInterpreter.doStep(context, pointer, steps, currentStep + 1);
            }
        } else {
            NodeIterator it = SimplePathInterpreter.getNodeIterator(parent, step);
            if (it != null) {
                ArrayList<NodePointer> list = new ArrayList<NodePointer>();
                int i = 1;
                while (it.setPosition(i)) {
                    list.add(it.getNodePointer());
                    ++i;
                }
                NodePointer pointer = SimplePathInterpreter.doPredicatesStandard(context, list, steps, currentStep, predicates, 0);
                if (pointer != null) {
                    return pointer;
                }
            }
        }
        return SimplePathInterpreter.createNullPointer(context, parent, steps, currentStep);
    }

    private static NodePointer doPredicate(EvalContext context, NodePointer parent, Step[] steps, int currentStep, Expression[] predicates, int currentPredicate) {
        if (currentPredicate == predicates.length) {
            return SimplePathInterpreter.doStep(context, parent, steps, currentStep + 1);
        }
        Expression predicate = predicates[currentPredicate];
        if (predicate instanceof NameAttributeTest) {
            return SimplePathInterpreter.doPredicateName(context, parent, steps, currentStep, predicates, currentPredicate);
        }
        return SimplePathInterpreter.doPredicateIndex(context, parent, steps, currentStep, predicates, currentPredicate);
    }

    private static NodePointer doPredicateName(EvalContext context, NodePointer parent, Step[] steps, int currentStep, Expression[] predicates, int currentPredicate) {
        Expression predicate = predicates[currentPredicate];
        String key = SimplePathInterpreter.keyFromPredicate(context, predicate);
        NodePointer child = SimplePathInterpreter.valuePointer(parent);
        if (child instanceof PropertyOwnerPointer) {
            PropertyPointer pointer = ((PropertyOwnerPointer)child).getPropertyPointer();
            pointer.setPropertyName(key);
            if (pointer.isActual()) {
                return SimplePathInterpreter.doPredicate(context, pointer, steps, currentStep, predicates, currentPredicate + 1);
            }
        } else if (child.isCollection()) {
            NodePointer bestMatch = null;
            int bestQuality = 0;
            child = (NodePointer)child.clone();
            int count = child.getLength();
            int i = 0;
            while (i < count) {
                child.setIndex(i);
                NodePointer valuePointer = SimplePathInterpreter.valuePointer(child);
                NodePointer pointer = valuePointer instanceof PropertyOwnerPointer || valuePointer.isCollection() ? SimplePathInterpreter.doPredicateName(context, valuePointer, steps, currentStep, predicates, currentPredicate) : (SimplePathInterpreter.isNameAttributeEqual(valuePointer, key) ? SimplePathInterpreter.doPredicate(context, valuePointer, steps, currentStep, predicates, currentPredicate + 1) : null);
                if (pointer != null) {
                    int quality = SimplePathInterpreter.computeQuality(pointer);
                    if (quality == 1000) {
                        return pointer;
                    }
                    if (quality > bestQuality) {
                        bestMatch = (NodePointer)pointer.clone();
                        bestQuality = quality;
                    }
                }
                ++i;
            }
            if (bestMatch != null) {
                return bestMatch;
            }
        } else {
            NodePointer found = SimplePathInterpreter.doPredicatesStandard(context, Collections.singletonList(child), steps, currentStep, predicates, currentPredicate);
            if (found != null) {
                return found;
            }
        }
        return SimplePathInterpreter.createNullPointerForPredicates(context, child, steps, currentStep, predicates, currentPredicate);
    }

    private static NodePointer doPredicatesStandard(EvalContext context, List parents, Step[] steps, int currentStep, Expression[] predicates, int currentPredicate) {
        if (parents.size() == 0) {
            return null;
        }
        if (currentPredicate == predicates.length) {
            NodePointer pointer = (NodePointer)parents.get(0);
            return SimplePathInterpreter.doStep(context, pointer, steps, currentStep + 1);
        }
        Expression predicate = predicates[currentPredicate];
        if (predicate instanceof NameAttributeTest) {
            String key = SimplePathInterpreter.keyFromPredicate(context, predicate);
            ArrayList<NodePointer> newList = new ArrayList<NodePointer>();
            int i = 0;
            while (i < parents.size()) {
                NodePointer pointer = (NodePointer)parents.get(i);
                if (SimplePathInterpreter.isNameAttributeEqual(pointer, key)) {
                    newList.add(pointer);
                }
                ++i;
            }
            if (newList.size() == 0) {
                return null;
            }
            return SimplePathInterpreter.doPredicatesStandard(context, newList, steps, currentStep, predicates, currentPredicate + 1);
        }
        int index = SimplePathInterpreter.indexFromPredicate(context, predicate);
        if (index < 0 || index >= parents.size()) {
            return null;
        }
        NodePointer ptr = (NodePointer)parents.get(index);
        return SimplePathInterpreter.doPredicate(context, ptr, steps, currentStep, predicates, currentPredicate + 1);
    }

    private static NodePointer doPredicateIndex(EvalContext context, NodePointer parent, Step[] steps, int currentStep, Expression[] predicates, int currentPredicate) {
        NodePointer pointer = parent;
        Expression predicate = predicates[currentPredicate];
        int index = SimplePathInterpreter.indexFromPredicate(context, predicate);
        if (SimplePathInterpreter.isCollectionElement(pointer, index)) {
            pointer = (NodePointer)pointer.clone();
            pointer.setIndex(index);
            return SimplePathInterpreter.doPredicate(context, pointer, steps, currentStep, predicates, currentPredicate + 1);
        }
        return SimplePathInterpreter.createNullPointerForPredicates(context, parent, steps, currentStep, predicates, currentPredicate);
    }

    private static int indexFromPredicate(EvalContext context, Expression predicate) {
        Object value = predicate.computeValue(context);
        if (value instanceof EvalContext) {
            value = ((EvalContext)value).getSingleNodePointer();
        }
        if (value instanceof NodePointer) {
            value = ((NodePointer)value).getValue();
        }
        if (value == null) {
            throw new JXPathException("Predicate value is null");
        }
        if (value instanceof Number) {
            return (int)(InfoSetUtil.doubleValue(value) + 0.5) - 1;
        }
        if (InfoSetUtil.booleanValue(value)) {
            return 0;
        }
        return -1;
    }

    private static String keyFromPredicate(EvalContext context, Expression predicate) {
        Expression expr = ((NameAttributeTest)predicate).getNameTestExpression();
        return InfoSetUtil.stringValue(expr.computeValue(context));
    }

    private static int computeQuality(NodePointer pointer) {
        int quality = 1000;
        while (pointer != null && !pointer.isActual()) {
            --quality;
            pointer = pointer.getParent();
        }
        return quality;
    }

    private static boolean isNameAttributeEqual(NodePointer pointer, String name) {
        NodeIterator it = pointer.attributeIterator(QNAME_NAME);
        return it != null && it.setPosition(1) && name.equals(it.getNodePointer().getValue());
    }

    private static boolean isCollectionElement(NodePointer pointer, int index) {
        return pointer.isActual() && (index == 0 || pointer.isCollection() && index >= 0 && index < pointer.getLength());
    }

    private static NodePointer valuePointer(NodePointer pointer) {
        return pointer == null ? null : pointer.getValuePointer();
    }

    private static NodePointer createNullPointer(EvalContext context, NodePointer parent, Step[] steps, int currentStep) {
        if (currentStep == steps.length) {
            return parent;
        }
        parent = SimplePathInterpreter.valuePointer(parent);
        Step step = steps[currentStep];
        int axis = step.getAxis();
        if (axis == 2 || axis == 5) {
            NullPropertyPointer pointer = new NullPropertyPointer(parent);
            QName name = ((NodeNameTest)step.getNodeTest()).getNodeName();
            pointer.setPropertyName(name.toString());
            pointer.setAttribute(axis == 5);
            parent = pointer;
        }
        Expression[] predicates = step.getPredicates();
        return SimplePathInterpreter.createNullPointerForPredicates(context, parent, steps, currentStep, predicates, 0);
    }

    private static NodePointer createNullPointerForPredicates(EvalContext context, NodePointer parent, Step[] steps, int currentStep, Expression[] predicates, int currentPredicate) {
        int i = currentPredicate;
        while (i < predicates.length) {
            Expression predicate = predicates[i];
            if (predicate instanceof NameAttributeTest) {
                String key = SimplePathInterpreter.keyFromPredicate(context, predicate);
                parent = SimplePathInterpreter.valuePointer(parent);
                NullPropertyPointer pointer = new NullPropertyPointer(parent);
                pointer.setNameAttributeValue(key);
                parent = pointer;
            } else {
                int index = SimplePathInterpreter.indexFromPredicate(context, predicate);
                if (parent instanceof NullPropertyPointer) {
                    parent.setIndex(index);
                } else {
                    parent = new NullElementPointer(parent, index);
                }
            }
            ++i;
        }
        return SimplePathInterpreter.createNullPointer(context, parent, steps, currentStep + 1);
    }

    private static NodeIterator getNodeIterator(NodePointer pointer, Step step) {
        if (step.getAxis() == 2) {
            return pointer.childIterator(step.getNodeTest(), false, null);
        }
        if (!(step.getNodeTest() instanceof NodeNameTest)) {
            throw new UnsupportedOperationException("Not supported node test for attributes: " + step.getNodeTest());
        }
        return pointer.attributeIterator(((NodeNameTest)step.getNodeTest()).getNodeName());
    }

    private static boolean isLangAttribute(QName name) {
        return name.getPrefix() != null && name.getPrefix().equals("xml") && name.getName().equals("lang");
    }
}

