/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.caching.impl;

import java.io.Serializable;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;
import org.apache.avalon.framework.activity.Disposable;
import org.apache.avalon.framework.activity.Initializable;
import org.apache.avalon.framework.logger.AbstractLogEnabled;
import org.apache.avalon.framework.thread.ThreadSafe;
import org.apache.cocoon.caching.EventRegistry;
import org.apache.cocoon.caching.impl.EventRegistryDataWrapper;
import org.apache.cocoon.caching.validity.Event;
import org.apache.commons.collections.MultiHashMap;

public abstract class AbstractDoubleMapEventRegistry
extends AbstractLogEnabled
implements Initializable,
EventRegistry,
Disposable,
ThreadSafe {
    private boolean m_init_success = false;
    private MultiHashMap m_keyMMap;
    private MultiHashMap m_eventMMap;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void register(Event e, Serializable key) {
        AbstractDoubleMapEventRegistry abstractDoubleMapEventRegistry = this;
        synchronized (abstractDoubleMapEventRegistry) {
            this.m_keyMMap.put((Object)key, (Object)e);
            this.m_eventMMap.put((Object)e, (Object)key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        AbstractDoubleMapEventRegistry abstractDoubleMapEventRegistry = this;
        synchronized (abstractDoubleMapEventRegistry) {
            this.m_keyMMap.clear();
            this.m_eventMMap.clear();
        }
    }

    public Serializable[] keysForEvent(Event e) {
        Collection coll = (Collection)this.m_eventMMap.get((Object)e);
        if (coll == null || coll.isEmpty()) {
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("The event map returned empty");
            }
            return null;
        }
        return coll.toArray(new Serializable[coll.size()]);
    }

    public Serializable[] allKeys() {
        Set keys = this.m_keyMMap.keySet();
        return keys.toArray(new Serializable[keys.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeKey(Serializable key) {
        Collection coll = (Collection)this.m_keyMMap.get((Object)key);
        if (coll == null || coll.isEmpty()) {
            return;
        }
        AbstractDoubleMapEventRegistry abstractDoubleMapEventRegistry = this;
        synchronized (abstractDoubleMapEventRegistry) {
            Iterator it = coll.iterator();
            while (it.hasNext()) {
                Object o = it.next();
                if (o == null) continue;
                if (this.getLogger().isDebugEnabled()) {
                    this.getLogger().debug("Removing from event mapping: " + o.toString());
                }
                this.m_eventMMap.remove(o, (Object)key);
            }
            this.m_keyMMap.remove((Object)key);
        }
    }

    public void initialize() throws Exception {
        if (this.recover()) {
            this.m_init_success = true;
        }
    }

    public void dispose() {
        EventRegistryDataWrapper ecdw = this.wrapRegistry();
        this.persist(ecdw);
        this.m_keyMMap.clear();
        this.m_keyMMap = null;
        this.m_eventMMap.clear();
        this.m_eventMMap = null;
    }

    public boolean wasRecoverySuccessful() {
        return this.m_init_success;
    }

    protected EventRegistryDataWrapper wrapRegistry() {
        EventRegistryDataWrapper ecdw = new EventRegistryDataWrapper();
        ecdw.setupMaps(this.m_keyMMap, this.m_eventMMap);
        return ecdw;
    }

    protected void unwrapRegistry(EventRegistryDataWrapper ecdw) {
        this.m_eventMMap = ecdw.get_eventMap();
        this.m_keyMMap = ecdw.get_keyMap();
    }

    protected final void createBlankCache() {
        this.m_eventMMap = new MultiHashMap(100);
        this.m_keyMMap = new MultiHashMap(100);
    }

    protected abstract boolean recover();

    protected abstract void persist(EventRegistryDataWrapper var1);
}

