/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.webapps.portal.context;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.avalon.framework.activity.Disposable;
import org.apache.avalon.framework.component.Component;
import org.apache.avalon.framework.context.Context;
import org.apache.avalon.framework.context.ContextException;
import org.apache.avalon.framework.context.Contextualizable;
import org.apache.avalon.framework.logger.AbstractLogEnabled;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;
import org.apache.avalon.framework.thread.ThreadSafe;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.components.ContextHelper;
import org.apache.cocoon.environment.ObjectModelHelper;
import org.apache.cocoon.environment.Request;
import org.apache.cocoon.environment.Session;
import org.apache.cocoon.webapps.portal.components.PortalManager;
import org.apache.cocoon.webapps.portal.context.SessionContextImpl;
import org.apache.cocoon.webapps.session.context.SessionContext;
import org.apache.cocoon.webapps.session.context.SessionContextProvider;
import org.apache.excalibur.source.SourceParameters;
import org.apache.excalibur.xml.xpath.XPathProcessor;
import org.xml.sax.SAXException;

public final class SessionContextProviderImpl
extends AbstractLogEnabled
implements SessionContextProvider,
ThreadSafe,
Component,
Serviceable,
Contextualizable,
Disposable {
    private ServiceManager manager;
    private Context context;
    protected XPathProcessor xpathProcessor;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public SessionContext getSessionContext(String name) throws ProcessingException {
        Map objectModel = ContextHelper.getObjectModel((Context)this.context);
        SessionContext context = this.getContext(objectModel, name);
        if (!name.equals("portal")) return context;
        if (context != null) return context;
        Request req = ObjectModelHelper.getRequest((Map)objectModel);
        Session session = req.getSession(false);
        if (session == null) return context;
        PortalManager portal = null;
        try {
            try {
                block11: {
                    block10: {
                        int sepTwo;
                        portal = (PortalManager)this.manager.lookup(PortalManager.ROLE);
                        String value = req.getParameter("portalcontext");
                        if (value == null) break block10;
                        int sepOne = value.indexOf(95);
                        if (sepOne != -1 && (sepTwo = value.indexOf(95, sepOne + 1)) != -1) {
                            String copletIdentifier = value.substring(0, sepOne);
                            String copletID = value.substring(sepOne + 1, sepTwo);
                            String copletNumber = value.substring(sepTwo + 1);
                            if (copletIdentifier.equals("coplet")) {
                                HashMap<String, Object> info = new HashMap<String, Object>(3);
                                SessionContextImpl.copletInfo.set(info);
                                SourceParameters pars = new SourceParameters();
                                info.put("COPLETINFO_PARAMETERS", pars);
                                pars.setSingleParameterValue("id", copletID);
                                pars.setSingleParameterValue("number", copletNumber);
                                pars.setSingleParameterValue("media", portal.getMediaType());
                                info.put("COPLETINFO_STATUSPROFILE", portal.getStatusProfile());
                                info.put("COPLETINFO_PORTALURI", req.getRequestURI());
                            }
                        }
                        break block11;
                    }
                    if (SessionContextImpl.copletInfo.get() == null) {
                        throw new ProcessingException("Portal context not available outside a coplet.");
                    }
                }
                context = new SessionContextImpl(name, objectModel, portal, this.xpathProcessor);
                objectModel.put(((Object)((Object)this)).getClass().getName() + name, context);
            }
            catch (SAXException se) {
                throw new ProcessingException("SAXException", (Throwable)se);
            }
            catch (IOException ioe) {
                throw new ProcessingException("IOException", (Throwable)ioe);
            }
            catch (ServiceException se) {
                throw new ProcessingException("Unable to lookup portal.", (Throwable)se);
            }
            Object var16_18 = null;
        }
        catch (Throwable throwable) {
            Object var16_19 = null;
            this.manager.release((Object)portal);
            throw throwable;
        }
        this.manager.release((Object)portal);
        return context;
    }

    public boolean existsSessionContext(String name) throws ProcessingException {
        Map objectModel = ContextHelper.getObjectModel((Context)this.context);
        return this.getContext(objectModel, name) != null;
    }

    private SessionContext getContext(Map objectModel, String name) {
        SessionContextImpl r;
        SessionContext context = (SessionContext)objectModel.get(((Object)((Object)this)).getClass().getName() + name);
        if (context != null && (r = (SessionContextImpl)context).getRequest() != ObjectModelHelper.getRequest((Map)objectModel)) {
            context = null;
            objectModel.remove(((Object)((Object)this)).getClass().getName() + name);
        }
        return context;
    }

    public void service(ServiceManager manager) throws ServiceException {
        this.manager = manager;
        this.xpathProcessor = (XPathProcessor)this.manager.lookup(XPathProcessor.ROLE);
    }

    public void contextualize(Context context) throws ContextException {
        this.context = context;
    }

    public void dispose() {
        if (this.manager != null) {
            this.manager.release((Object)this.xpathProcessor);
            this.xpathProcessor = null;
            this.manager = null;
        }
    }
}

