/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.mail.transformation;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Enumeration;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.activation.URLDataSource;
import javax.mail.Address;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.Multipart;
import javax.mail.SendFailedException;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import org.apache.avalon.excalibur.pool.Recyclable;
import org.apache.avalon.framework.parameters.ParameterException;
import org.apache.avalon.framework.parameters.Parameterizable;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.environment.SourceResolver;
import org.apache.cocoon.transformation.AbstractSAXTransformer;
import org.apache.excalibur.source.Source;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class SendMailTransformer
extends AbstractSAXTransformer
implements Parameterizable,
Recyclable {
    public static final String NAMESPACE = "http://apache.org/cocoon/transformation/sendmail";
    public static final String ELEMENT_SENDMAIL = "sendmail";
    public static final String ELEMENT_SMTPHOST = "smtphost";
    public static final String ELEMENT_MAILFROM = "from";
    public static final String ELEMENT_MAILTO = "to";
    public static final String ELEMENT_MAILSUBJECT = "subject";
    public static final String ELEMENT_MAILBODY = "body";
    public static final String ELEMENT_ATTACHMENT = "attachment";
    public static final String ELEMENT_ATTACHMENT_CONTENT = "content";
    public static final String ELEMENT_EMAIL_PREFIX = "email";
    public static final String ELEMENT_ERROR = "error";
    public static final String ELEMENT_SUCCESS = "success";
    public static final String ELEMENT_FAILURE = "failure";
    public static final String ELEMENT_RESULT = "result";
    protected static final int MODE_NONE = 0;
    protected static final int MODE_SMTPHOST = 1;
    protected static final int MODE_FROM = 2;
    protected static final int MODE_TO = 3;
    protected static final int MODE_SUBJECT = 4;
    protected static final int MODE_BODY = 5;
    protected static final int MODE_ATTACHMENT = 6;
    protected static final int MODE_ATTACHMENT_CONTENT = 7;
    public static final String PARAM_SMTPHOST = "smtphost";
    public static final String PARAM_FROM = "from";
    public static final String PARAM_TO = "to";
    public static final String PARAM_SUBJECT = "subject";
    public static final String PARAM_BODY = "body";
    public static final String PARAM_SENDPARTIAL = "sendpartial";
    protected int mode;
    protected Vector toAddresses;
    protected Vector attachments;
    protected StringBuffer subject;
    protected StringBuffer body;
    protected String bodyURI;
    protected String mailHost;
    protected String fromAddress;
    protected AttachmentDescriptor attachmentDescriptor;
    protected int port;
    protected String contextPath;
    protected boolean sendPartial;
    protected Message smtpMessage = null;

    public SendMailTransformer() {
        this.defaultNamespaceURI = NAMESPACE;
    }

    public void setup(SourceResolver resolver, Map objectModel, String src, Parameters par) throws ProcessingException, SAXException, IOException {
        super.setup(resolver, objectModel, src, par);
        this.mailHost = par.getParameter("smtphost", "");
        this.fromAddress = par.getParameter("from", "");
        this.port = this.request.getServerPort();
        this.contextPath = this.request.getContextPath();
        this.sendPartial = par.getParameterAsBoolean(PARAM_SENDPARTIAL, true);
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("overwritten by Transformer-Parameters in Pipeline");
            this.getLogger().debug("overwritten Parameters=" + this.mailHost + ":" + this.fromAddress);
        }
        String s = par.getParameter("to", "");
        this.toAddresses = new Vector();
        this.attachments = new Vector();
        this.appendToAddress(s, ";");
        try {
            this.subject = new StringBuffer(par.getParameter("subject"));
        }
        catch (ParameterException pe) {
            this.getLogger().debug("Parameter <subject> not set.");
        }
        try {
            this.body = new StringBuffer(par.getParameter("body"));
        }
        catch (ParameterException pe) {
            this.getLogger().debug("Parameter <body> not set.");
        }
        this.defaultNamespaceURI = NAMESPACE;
    }

    public void parameterize(Parameters parameters) throws ParameterException {
    }

    public void startTransformingElement(String uri, String name, String raw, Attributes attr) throws SAXException {
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("BEGIN startElement uri=" + uri + ", name=" + name + ", raw=" + raw + ", attr=" + attr);
        }
        if (name.equals(ELEMENT_SENDMAIL)) {
            this.toAddresses.clear();
            this.attachments.clear();
        } else if (name.equals("smtphost")) {
            this.startTextRecording();
            this.mode = 1;
        } else if (name.equals("from")) {
            this.startTextRecording();
            this.mode = 2;
        } else if (name.equals("to")) {
            this.startTextRecording();
            this.mode = 3;
        } else if (name.equals("subject")) {
            this.startTextRecording();
            this.mode = 4;
        } else if (name.equals("body")) {
            String strBody = attr.getValue("src");
            if (strBody != null) {
                this.bodyURI = new String(strBody);
            }
            this.startTextRecording();
            this.mode = 5;
        } else if (name.equals(ELEMENT_ATTACHMENT)) {
            this.attachmentDescriptor = new AttachmentDescriptor(attr.getValue("name"), attr.getValue("mime-type"), attr.getValue("src"), attr.getValue("url"));
            this.mode = 6;
        } else if (name.equals(ELEMENT_ATTACHMENT_CONTENT)) {
            this.startSerializedXMLRecording(new Properties());
            this.mode = 7;
        } else {
            throw new SAXException("Unknown element " + name);
        }
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("END startElement");
        }
    }

    public void endTransformingElement(String uri, String name, String raw) throws SAXException, ProcessingException {
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("BEGIN endTransformingElement uri=" + uri + ", name=" + name + ", raw=" + raw);
        }
        if (name.equals(ELEMENT_SENDMAIL)) {
            if (this.getLogger().isInfoEnabled()) {
                this.getLogger().info("Mail contents- Subject: " + this.subject + "\n" + "Body: " + this.body);
            }
            this.sendMail();
        } else if (name.equals("smtphost")) {
            this.mailHost = this.endTextRecording();
            this.mode = 0;
        } else if (name.equals("from")) {
            this.fromAddress = this.endTextRecording();
            this.mode = 0;
        } else if (name.equals("to")) {
            this.toAddresses.add(this.endTextRecording());
            this.mode = 0;
        } else if (name.equals("subject")) {
            String strSubject = this.endTextRecording();
            if (strSubject != null) {
                this.subject = new StringBuffer(strSubject);
            } else {
                this.getLogger().debug("Mail-Subject not available");
            }
            this.mode = 0;
        } else if (name.equals(ELEMENT_ATTACHMENT)) {
            this.attachments.add(this.attachmentDescriptor.copy());
            this.attachmentDescriptor = null;
            this.mode = 0;
        } else if (name.equals(ELEMENT_ATTACHMENT_CONTENT)) {
            this.attachmentDescriptor.setContent(new StringBuffer(this.endSerializedXMLRecording()));
            this.mode = 0;
        } else if (name.equals("body")) {
            String strB;
            block24: {
                strB = null;
                try {
                    strB = new String(this.endTextRecording());
                }
                catch (Exception e) {
                    if (!this.getLogger().isDebugEnabled()) break block24;
                    this.getLogger().debug("No Body as String in config-file available");
                }
            }
            if (strB != null) {
                this.body = new StringBuffer(strB);
            }
            this.mode = 0;
        } else {
            throw new SAXException("Unknown element " + name);
        }
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("END endElement");
        }
    }

    private void appendToAddress(String s, String delim) {
        StringTokenizer t = null;
        t = new StringTokenizer(s.trim(), delim);
        while (t.hasMoreElements()) {
            this.toAddresses.add(t.nextToken());
        }
    }

    private void sendMail() throws SAXException {
        try {
            Properties props = new Properties();
            props.put("mail.smtp.host", this.mailHost);
            if (this.subject == null) {
                ++this.ignoreHooksCount;
                super.sendStartElementEventNS(ELEMENT_ERROR);
                super.sendTextEvent("Subject not available - sending mail aborted");
                super.sendEndElementEventNS(ELEMENT_ERROR);
                --this.ignoreHooksCount;
                return;
            }
            if (this.body == null && this.bodyURI == null) {
                ++this.ignoreHooksCount;
                super.sendStartElementEventNS(ELEMENT_ERROR);
                super.sendTextEvent("Mailbody not available - sending mail aborted");
                super.sendEndElementEventNS(ELEMENT_ERROR);
                --this.ignoreHooksCount;
                return;
            }
            Session session = Session.getDefaultInstance((Properties)props, null);
            Transport trans = null;
            trans = session.getTransport("smtp");
            trans.connect();
            this.smtpMessage = this.setUpMessage(session);
            ++this.ignoreHooksCount;
            super.sendStartElementEventNS(ELEMENT_RESULT);
            if (this.sendPartial) {
                int i = 0;
                while (i < this.toAddresses.size()) {
                    Vector v = new Vector(1);
                    v.add(this.toAddresses.elementAt(i));
                    this.sendMail(v, trans);
                    ++i;
                }
            } else {
                this.sendMail(this.toAddresses, trans);
            }
            trans.close();
            super.sendEndElementEventNS(ELEMENT_RESULT);
            --this.ignoreHooksCount;
        }
        catch (Exception sE) {
            this.getLogger().error("sendMail-Error", (Throwable)sE);
            this.sendExceptionElement(sE);
        }
    }

    /*
     * Unable to fully structure code
     */
    private void sendMail(Vector newAddresses, Transport trans) throws Exception {
        block10: {
            iA = new AddressHandler[newAddresses.size()];
            i = 0;
            while (i < newAddresses.size()) {
                inA = new InternetAddress((String)newAddresses.elementAt(i));
                iA[i] = new AddressHandler(inA);
                ++i;
            }
            try {
                iaArr = SendMailTransformer.getAddresses(iA);
                this.smtpMessage.setRecipients(Message.RecipientType.TO, (Address[])iaArr);
                trans.sendMessage(this.smtpMessage, (Address[])iaArr);
            }
            catch (SendFailedException sfEx) {
                this.getLogger().error("Exception during sending of mail", (Throwable)sfEx);
                adr = sfEx.getInvalidAddresses();
                isfEx = 0;
                ** while (isfEx < iA.length)
            }
lbl-1000:
            // 1 sources

            {
                tmpAddress = iA[isfEx].getAddress().getAddress();
                sei = 0;
                while (sei < adr.length) {
                    if (((InternetAddress)adr[sei]).getAddress().equalsIgnoreCase(tmpAddress)) {
                        iA[isfEx].setSendMailResult("Invalid address");
                    }
                    ++sei;
                }
                ++isfEx;
                continue;
            }
lbl27:
            // 1 sources

            ad = sfEx.getValidUnsentAddresses();
            isfEx = 0;
            while (isfEx < iA.length) {
                tmpAddress = iA[isfEx].getAddress().getAddress();
                sei = 0;
                while (sei < ad.length) {
                    if (((InternetAddress)ad[sei]).getAddress().equalsIgnoreCase(tmpAddress)) {
                        iA[isfEx].setSendMailResult("Recipient not found");
                    }
                    ++sei;
                }
                ++isfEx;
            }
            break block10;
            catch (Exception e) {
                this.getLogger().error("Exception during sending of mail", (Throwable)e);
                this.sendExceptionElement(e);
                return;
            }
        }
        this.generateSAXReportStatements(iA);
    }

    private Message setUpMessage(Session session) throws Exception {
        MimeMessage sm = new MimeMessage(session);
        sm.setFrom((Address)new InternetAddress(this.fromAddress));
        sm.setSubject(this.subject.toString());
        MimeBodyPart messageBodyPart = new MimeBodyPart();
        if (this.bodyURI != null) {
            Source inSrc = this.resolver.resolveURI(this.bodyURI);
            InputStream inStr = inSrc.getInputStream();
            byte[] byteArr = new byte[inStr.available()];
            inStr.read(byteArr);
            String mailBody = new String(byteArr);
            messageBodyPart.setContent((Object)mailBody, "text/html");
        } else {
            messageBodyPart.setContent((Object)this.body.toString(), "text/html");
        }
        MimeMultipart multipart = new MimeMultipart();
        multipart.addBodyPart((BodyPart)messageBodyPart);
        Enumeration enumAtt = this.attachments.elements();
        while (enumAtt.hasMoreElements()) {
            AttachmentDescriptor aD = (AttachmentDescriptor)enumAtt.nextElement();
            messageBodyPart = new MimeBodyPart();
            if (!aD.isTextContent()) {
                Source inputSource = null;
                URLDataSource dataSource = null;
                if (aD.isURLSource()) {
                    inputSource = this.resolver.resolveURI(aD.strAttrSrc);
                    String iSS = new String(inputSource.getURI());
                    if (iSS.startsWith("cocoon:")) {
                        iSS = iSS.substring(7, iSS.length());
                        iSS = this.contextPath != null ? "http://localhost:" + this.port + this.contextPath + iSS : "http://localhost:" + this.port + iSS;
                        if (this.getLogger().isDebugEnabled()) {
                            this.getLogger().debug("cocoon-URI changed to " + iSS);
                        }
                        dataSource = new URLDataSource(new URL(iSS));
                    } else {
                        dataSource = new URLDataSource(new URL(inputSource.getURI()));
                    }
                    messageBodyPart.setDataHandler(new DataHandler((DataSource)dataSource));
                } else if (aD.isFileSource()) {
                    inputSource = this.resolver.resolveURI(aD.strAttrFile);
                    dataSource = new URLDataSource(new URL(inputSource.getURI()));
                    messageBodyPart.setDataHandler(new DataHandler((DataSource)dataSource));
                }
            } else {
                messageBodyPart.setContent((Object)aD.strBufContent.toString(), aD.strAttrMimeType);
            }
            messageBodyPart.setFileName(aD.strAttrName);
            multipart.addBodyPart((BodyPart)messageBodyPart);
        }
        sm.setContent((Multipart)multipart);
        sm.saveChanges();
        return sm;
    }

    private void generateSAXReportStatements(AddressHandler[] addressArr) throws SAXException {
        AttributesImpl impl = new AttributesImpl();
        int i = 0;
        while (i < addressArr.length) {
            String tmpAddress = addressArr[i].getAddress().getAddress();
            if (addressArr[i].getSendMailResult() == null) {
                impl.addAttribute("", "to", "to", "CDATA", tmpAddress);
                super.sendStartElementEventNS(ELEMENT_SUCCESS, (Attributes)impl);
                super.sendTextEvent("Mail sent");
                super.sendEndElementEventNS(ELEMENT_SUCCESS);
            } else {
                impl.addAttribute("", "to", "to", "CDATA", tmpAddress);
                super.sendStartElementEventNS(ELEMENT_FAILURE, (Attributes)impl);
                super.sendTextEvent(addressArr[i].getSendMailResult());
                super.sendEndElementEventNS(ELEMENT_FAILURE);
            }
            ++i;
        }
    }

    private void sendExceptionElement(Exception ex) {
        try {
            ++this.ignoreHooksCount;
            super.sendStartElementEventNS("exception");
            super.sendStartElementEventNS("message");
            super.sendTextEvent(ex.getMessage());
            super.sendEndElementEventNS("message");
            super.sendEndElementEventNS("exception");
            --this.ignoreHooksCount;
        }
        catch (SAXException e) {
            this.getLogger().error("Error while sending a SAX-Event", (Throwable)e);
        }
    }

    public static InternetAddress[] getAddresses(AddressHandler[] handlerArr) {
        InternetAddress[] iaArr = new InternetAddress[handlerArr.length];
        int i = 0;
        while (i < handlerArr.length) {
            iaArr[i] = handlerArr[i].getAddress();
            ++i;
        }
        return iaArr;
    }

    public void recycle() {
        this.toAddresses = null;
        this.attachments = null;
        this.subject = null;
        this.body = null;
        this.bodyURI = null;
        this.mailHost = null;
        this.fromAddress = null;
        this.attachmentDescriptor = null;
        this.port = 0;
        this.contextPath = null;
        this.sendPartial = true;
        this.smtpMessage = null;
        super.recycle();
    }

    class AddressHandler {
        private InternetAddress address = null;
        private String sendMailResult = null;

        protected AddressHandler(InternetAddress newAddress) {
            this.address = newAddress;
        }

        protected void setSendMailResult(String newSendMailResult) {
            this.sendMailResult = newSendMailResult;
        }

        public InternetAddress getAddress() {
            return this.address;
        }

        public String getSendMailResult() {
            return this.sendMailResult;
        }
    }

    class AttachmentDescriptor {
        String strAttrName = null;
        String strAttrMimeType = null;
        String strAttrSrc = null;
        String strAttrFile = null;
        StringBuffer strBufContent = null;

        protected AttachmentDescriptor(String newAttrName, String newAttrMimeType, String newAttrSrc, String newAttrFile) {
            this.strAttrName = newAttrName;
            this.strAttrMimeType = newAttrMimeType;
            this.strAttrSrc = newAttrSrc;
            this.strAttrFile = newAttrFile;
        }

        protected void setContent(StringBuffer newContent) {
            this.strBufContent = newContent;
        }

        protected AttachmentDescriptor copy() {
            AttachmentDescriptor aD = new AttachmentDescriptor(this.strAttrName, this.strAttrMimeType, this.strAttrSrc, this.strAttrFile);
            aD.setContent(this.strBufContent);
            return aD;
        }

        protected boolean isURLSource() {
            return this.strAttrSrc != null;
        }

        protected boolean isFileSource() {
            return this.strAttrFile != null;
        }

        protected boolean isTextContent() {
            return this.strBufContent != null;
        }
    }
}

