/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.mail;

import java.text.SimpleDateFormat;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.mail.Folder;
import javax.mail.Message;
import javax.mail.Provider;
import javax.mail.Session;
import javax.mail.Store;
import javax.mail.URLName;
import org.apache.avalon.framework.context.ContextException;
import org.apache.avalon.framework.logger.Logger;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.avalon.framework.thread.ThreadSafe;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.acting.ServiceableAction;
import org.apache.cocoon.environment.ObjectModelHelper;
import org.apache.cocoon.environment.Redirector;
import org.apache.cocoon.environment.Request;
import org.apache.cocoon.environment.SourceResolver;
import org.apache.cocoon.mail.MailCommandBuilder;
import org.apache.cocoon.mail.MailCommandManager;
import org.apache.cocoon.mail.MailContentHandlerDelegate;
import org.apache.cocoon.mail.MailContext;
import org.apache.cocoon.mail.MailContextHttpSession;
import org.apache.cocoon.mail.command.AbstractMailCommand;

public class MailAction
extends ServiceableAction
implements ThreadSafe {
    public static final String REQUEST_ATTRIBUTE_FOLDER = "folder";
    public static final String REQUEST_ATTRIBUTE_FOLDERS = "folders";
    public static final String REQUEST_ATTRIBUTE_MESSAGE = "message";
    public static final String REQUEST_ATTRIBUTE_MESSAGES = "messages";

    /*
     * Unable to fully structure code
     */
    public Map act(Redirector redirector, SourceResolver resolver, Map objectModel, String source, Parameters par) throws Exception {
        block16: {
            actionMap = new HashMap<String, String>();
            request = ObjectModelHelper.getRequest((Map)objectModel);
            command = request.getParameter("cmd");
            folderName = request.getParameter("folder");
            userid = request.getParameter("mail-userid");
            password = request.getParameter("mail-password");
            session = request.getSession(true);
            mailContext = (MailContext)session.getAttribute("mail-context");
            if (mailContext == null) {
                mailContext = new MailContextHttpSession(null);
                mailContext.enableLogging(this.getLogger());
                session.setAttribute("mail-context", (Object)mailContext);
            }
            mailSession = null;
            mailStore = null;
            try {
                try {
                    mailSession = (Session)mailContext.get("mail-session");
                    break block16;
                }
                catch (ContextException ce) {
                    sessionProperties = new Properties();
                    allParameterNames = par.getNames();
                    i = 0;
                    ** while (i < allParameterNames.length)
                }
lbl-1000:
                // 1 sources

                {
                    parameterName = allParameterNames[i];
                    PARAMETER_NAME_PREFIX = "javax.mail.Session.props:";
                    if (parameterName.startsWith("javax.mail.Session.props:")) {
                        sessionPropName = parameterName.substring("javax.mail.Session.props:".length());
                        sessionPropValue = par.getParameter(parameterName, null);
                        if (sessionPropValue != null) {
                            this.getLogger().debug("Add session property " + String.valueOf(sessionPropName) + ": " + String.valueOf(sessionPropValue));
                            sessionProperties.put(sessionPropName, sessionPropValue);
                        }
                    }
                    ++i;
                    continue;
                }
lbl35:
                // 1 sources

                mailSession = Session.getDefaultInstance((Properties)sessionProperties, null);
                this.checkProviders(mailSession);
                mailContext.put("mail-session", mailSession);
            }
            catch (Exception e) {
                message = "Cannot create mail session";
                this.getLogger().error(message, (Throwable)e);
                throw new ProcessingException(message, (Throwable)e);
            }
        }
        storeURLNameExpanded = null;
        storeURLNameTemplate = par.getParameter("store-urlname", null);
        try {
            try {
                mailStore = (Store)mailContext.get("mail-store");
            }
            catch (ContextException ce) {
                storeURLNameExpanded = this.getURLNameExpanded(storeURLNameTemplate, userid, password);
                urlNameExpanded = new URLName(storeURLNameExpanded);
                this.getLogger().info("get store using URLName " + String.valueOf(urlNameExpanded));
                mailStore = mailSession.getStore(urlNameExpanded);
                mailStore.connect();
                mailContext.put("mail-store", mailStore);
            }
        }
        catch (Exception e) {
            message = "Cannot get store, and connect " + String.valueOf(storeURLNameExpanded);
            this.getLogger().error(message, (Throwable)e);
            throw new ProcessingException(message, (Throwable)e);
        }
        if (folderName != null) {
            mailContext.put("mail-current-working-folder", folderName);
        } else {
            folderName = (String)mailContext.get("mail-current-working-folder");
        }
        actionMap.put("mail-current-working-folder", folderName);
        if (command != null) {
            mailContext.put("mail-current-working-command", command);
        } else {
            command = (String)mailContext.get("mail-current-working-command");
        }
        actionMap.put("mail-current-working-command", command);
        mailContext.setRequest(request);
        this.populateRequestAttribute(request, mailContext);
        mailContext.setRequest(null);
        return actionMap;
    }

    protected String getURLNameExpanded(String storeURLNameTemplate, String userid, String password) {
        String tokenStart = "''";
        String tokenEnd = "''";
        Properties filters = new Properties();
        filters.put("mail-userid", userid);
        filters.put("mail-passwd", password);
        String filteredURLName = this.filter(tokenStart, tokenEnd, storeURLNameTemplate, filters);
        return filteredURLName;
    }

    protected String filter(String tokenStart, String tokenEnd, String s, Properties tokens) {
        int index = s.indexOf(tokenStart);
        if (index > -1) {
            try {
                int endIndex;
                StringBuffer b = new StringBuffer();
                int i = 0;
                String token = null;
                String value = null;
                while ((endIndex = s.indexOf(tokenEnd, index + tokenStart.length() + 1)) != -1) {
                    token = s.substring(index + tokenStart.length(), endIndex);
                    b.append(s.substring(i, index));
                    if (tokens.containsKey(token)) {
                        value = (String)tokens.get(token);
                        b.append(value);
                        i = index + tokenStart.length() + token.length() + tokenEnd.length();
                    } else {
                        b.append(tokenStart);
                        i = index + tokenStart.length();
                    }
                    if ((index = s.indexOf(tokenStart, i)) > -1) continue;
                }
                b.append(s.substring(i));
                return b.toString();
            }
            catch (StringIndexOutOfBoundsException e) {
                return s;
            }
        }
        return s;
    }

    protected void checkProviders(Session session) {
        Provider[] providers = session.getProviders();
        int i = 0;
        while (i < providers.length) {
            this.getLogger().info("mail provider " + providers[i]);
            ++i;
        }
    }

    protected void populateRequestAttribute(Request request, MailContext mailContext) throws Exception {
        String folderName = (String)mailContext.get("mail-current-working-folder");
        request.setAttribute("mail-current-working-folder", (Object)folderName);
        String command = (String)mailContext.get("mail-current-working-command");
        request.setAttribute("mail-current-working-command", (Object)command);
        List javaMailResult = this.retrieveJavaMailObjects(mailContext);
        Iterator javaMailResultIterator = javaMailResult.iterator();
        this.putXMLizerToRequestAttribute(request, javaMailResultIterator);
    }

    protected void putXMLizerToRequestAttribute(Request request, Iterator resultIterator) {
        if (resultIterator != null) {
            Logger logger = this.getLogger();
            String datePattern = "dd.MM.yyyy HH:mm";
            SimpleDateFormat sdf = new SimpleDateFormat(datePattern);
            while (resultIterator.hasNext()) {
                Object objRef = resultIterator.next();
                this.getLogger().debug("Creating XMLizer for " + String.valueOf(objRef));
                if (objRef instanceof Folder) {
                    MailContentHandlerDelegate.FolderXMLizer fx = new MailContentHandlerDelegate.FolderXMLizer((Folder)objRef);
                    fx.enableLogging(logger);
                    request.setAttribute(REQUEST_ATTRIBUTE_FOLDER, (Object)fx);
                    continue;
                }
                if (objRef instanceof Folder[]) {
                    Folder[] folders = (Folder[])objRef;
                    MailContentHandlerDelegate.FolderXMLizer[] fxs = new MailContentHandlerDelegate.FolderXMLizer[folders.length];
                    int i = 0;
                    while (i < folders.length) {
                        fxs[i] = new MailContentHandlerDelegate.FolderXMLizer(folders[i]);
                        fxs[i].enableLogging(logger);
                        ++i;
                    }
                    request.setAttribute(REQUEST_ATTRIBUTE_FOLDERS, (Object)fxs);
                    continue;
                }
                if (objRef instanceof Message) {
                    MailContentHandlerDelegate.MessageXMLizer mx = new MailContentHandlerDelegate.MessageXMLizer((Message)objRef);
                    mx.enableLogging(logger);
                    mx.setSimpleDateFormat(sdf);
                    request.setAttribute(REQUEST_ATTRIBUTE_MESSAGE, (Object)mx);
                    continue;
                }
                if (!(objRef instanceof Message[])) continue;
                MailContentHandlerDelegate.MessageEnvelopeXMLizer mex = new MailContentHandlerDelegate.MessageEnvelopeXMLizer((Message[])objRef);
                mex.enableLogging(logger);
                mex.setSimpleDateFormat(sdf);
                request.setAttribute(REQUEST_ATTRIBUTE_MESSAGES, (Object)mex);
            }
        }
    }

    protected List retrieveJavaMailObjects(MailContext mailContext) throws ProcessingException {
        List result = null;
        try {
            MailCommandManager mam = new MailCommandManager();
            mam.enableLogging(this.getLogger());
            MailCommandBuilder mab = new MailCommandBuilder();
            mab.enableLogging(this.getLogger());
            AbstractMailCommand ama = mab.buildAbstractMailCommand(mailContext);
            this.getLogger().debug("Executing " + String.valueOf(ama));
            result = mam.execute(ama);
            return result;
        }
        catch (Exception e) {
            String message = "Cannot retrieve javamail objects";
            this.getLogger().error(message, (Throwable)e);
            throw new ProcessingException(message, (Throwable)e);
        }
    }
}

