/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.forms.formmodel;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.cocoon.forms.formmodel.FormDefinition;
import org.apache.cocoon.forms.formmodel.Widget;
import org.apache.cocoon.forms.formmodel.WidgetDefinition;
import org.apache.cocoon.forms.validation.WidgetValidator;
import org.apache.cocoon.xml.XMLUtils;
import org.apache.excalibur.xml.sax.XMLizable;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public abstract class AbstractWidgetDefinition
implements WidgetDefinition {
    private FormDefinition formDefinition;
    protected WidgetDefinition parent;
    private String location = null;
    private String id;
    private Map displayData;
    private List validators;

    public FormDefinition getFormDefinition() {
        if (this.formDefinition == null) {
            this.formDefinition = this instanceof FormDefinition ? (FormDefinition)this : this.parent.getFormDefinition();
        }
        return this.formDefinition;
    }

    public void setParent(WidgetDefinition definition) {
        this.parent = definition;
    }

    public WidgetDefinition getParent() {
        return this.parent;
    }

    protected void setLocation(String location) {
        this.location = location;
    }

    public String getLocation() {
        return this.location;
    }

    public String getId() {
        return this.id;
    }

    protected void setId(String id) {
        this.id = id;
    }

    public void generateLabel(ContentHandler contentHandler) throws SAXException {
        this.generateDisplayData("label", contentHandler);
    }

    public void setDisplayData(Map displayData) {
        this.displayData = displayData;
    }

    public void addValidator(WidgetValidator validator) {
        if (this.validators == null) {
            this.validators = new ArrayList();
        }
        this.validators.add(validator);
    }

    public void generateDisplayData(String name, ContentHandler contentHandler) throws SAXException {
        Object data = this.displayData.get(name);
        if (data != null) {
            ((XMLizable)data).toSAX(contentHandler);
        } else if (!this.displayData.containsKey(name)) {
            throw new IllegalArgumentException("Unknown display data name '" + name + "'");
        }
    }

    public void generateDisplayData(ContentHandler contentHandler) throws SAXException {
        Iterator iter = this.displayData.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry entry = iter.next();
            if (entry.getValue() == null) continue;
            String name = (String)entry.getKey();
            contentHandler.startElement("http://apache.org/cocoon/forms/1.0#instance", name, "fi:" + name, (Attributes)XMLUtils.EMPTY_ATTRIBUTES);
            ((XMLizable)entry.getValue()).toSAX(contentHandler);
            contentHandler.endElement("http://apache.org/cocoon/forms/1.0#instance", name, "fi:" + name);
        }
    }

    public boolean validate(Widget widget) {
        if (this.validators == null) {
            return true;
        }
        Iterator iter = this.validators.iterator();
        while (iter.hasNext()) {
            WidgetValidator validator = (WidgetValidator)iter.next();
            if (validator.validate(widget)) continue;
            return false;
        }
        return true;
    }
}

