<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:xsp="http://apache.org/xsp" xmlns:sdx="http://www.culture.gouv.fr/ns/sdx/sdx" exclude-result-prefixes="xsl">
	<!--                                                                      -->
	<!-- ============================ OUTPUTS =============================== -->
	<!--                                                                      -->
	<!-- 
		<sdx:terms> : includes the list of terms of an index 
	-->
	<xsl:template match="sdx:terms">
		<xsp:logic xml:title="TERMS">
			<xsl:call-template name="comment"/>
			sdx_terms=null;
			sdx_page=-1; 
			<xsl:call-template name="sdx:build-locations"/>
			<xsl:call-template name="sdx:fields"/>
			<xsl:call-template name="sdx:values"/>
			<xsl:call-template name="sdx:hpp"/>
			<xsl:call-template name="sdx:parameter">
				<xsl:with-param name="name" select="'qid'"/>
			</xsl:call-template>
			sdx_object=getSessionObject(session, sdx_parameter);
			if (sdx_object != null &amp;&amp; sdx_object instanceof Terms)
			{
				sdx_terms=(Terms)sdx_object;
				<!-- dynamic changes of hitsPerPage
				try to give best page from requested
				not useful for base query -->
				if (sdx_hpp != sdx_terms.getHitsPerPage()) { 
					/* if new hpp */
					<xsl:call-template name="sdx:parameter">
						<xsl:with-param name="name" select="'page'"/>
						<xsl:with-param name="abbr" select="'p'"/>
					</xsl:call-template>
					sdx_page=(int)java.lang.Math.floor((((sdx_i-1)*sdx_terms.getHitsPerPage())+1)/sdx_hpp )+1;
					sdx_terms.setHitsPerPage(sdx_hpp);
					<xsl:if test="ancestor::sdx:debug">
						<sdx:debug title="HPP dynamic">
							<xsp:attribute name="hppOld">
								<xsp:expr>sdx_j</xsp:expr>
							</xsp:attribute>
							<xsp:attribute name="hppNew">
								<xsp:expr>sdx_hpp</xsp:expr>
							</xsp:attribute>
							<xsp:attribute name="pageOld">
								<xsp:expr>sdx_i</xsp:expr>
							</xsp:attribute>
							<xsp:attribute name="pageNew">
								<xsp:expr>sdx_page</xsp:expr>
							</xsp:attribute>
						</sdx:debug>
					</xsl:if>
				}
			}
			else if (sdx_fields != null &amp;&amp; sdx_fields.length != 0)
			{
				sdx_terms=new Terms();
				sdx_terms.enableLogging(sdx_log);
                sdx_terms.setEncoding(sdx_encoding);
				// more than one field, multi-key sort
				if (sdx_fields.length &gt; 1)
				{
                        <!--we try to get a qid, if none is provided we build terms as normal using a locations object-->
                        <xsl:call-template name="sdx:parameter">
                            <xsl:with-param name="name" select="'qid'"/>
                        </xsl:call-template>
                    if (sdx_check(sdx_parameter)) /* if we hava query id, we try to get cached results */
                        {
                            sdx_object=getSessionObject(session, sdx_parameter);
                            if (sdx_object != null &amp;&amp; sdx_object instanceof Results)
                            {
                                sdx_results=(Results)sdx_object;
                                if (sdx_results != null) sdx_terms.setUp(sdx_results, sdx_fields, sdx_values);
                            }
                        }
                    else if (sdx_locations != null) sdx_terms.setUp(sdx_locations, sdx_fields, sdx_values);


				}
				// 1 field, 1 value
				else if (sdx_values != null &amp;&amp; sdx_values.length != 0)
				{
                      <xsl:call-template name="sdx:parameter">
                            <xsl:with-param name="name" select="'qid'"/>
                        </xsl:call-template>
                    if (sdx_check(sdx_parameter)) /* if we hava query id, we try to get cached results */
                        {
                            sdx_object=getSessionObject(session, sdx_parameter);
                            if (sdx_object != null &amp;&amp; sdx_object instanceof Results)
                            {
                                sdx_results=(Results)sdx_object;
                                if (sdx_results != null) sdx_terms.setUp(sdx_results, sdx_fields[0], sdx_values[0]);
                            }
                        }
                     else if (sdx_locations != null) sdx_terms.setUp(sdx_locations, sdx_fields[0], sdx_values[0]);

				}
				// default case, one field
				else
				{
                     <xsl:call-template name="sdx:parameter">
                            <xsl:with-param name="name" select="'qid'"/>
                        </xsl:call-template>
                    if (sdx_check(sdx_parameter)) /* if we hava query id, we try to get cached results */
                        {
                            sdx_object=getSessionObject(session, sdx_parameter);
                            if (sdx_object != null &amp;&amp; sdx_object instanceof Results)
                            {
                                sdx_results=(Results)sdx_object;
                                if (sdx_results != null) sdx_terms.setUp(sdx_results, sdx_fields[0], null);
                            }
                        }
                    else if (sdx_locations != null) sdx_terms.setUp(sdx_locations, sdx_fields[0]);


				}
				sdx_terms.setHitsPerPage(sdx_hpp);

				/* caching */
				sdx_string = setShowSessionObject(session, null, sdx_terms, sdx_qmax);//allowing called method to calculate key
				/* to inform the toSAX() method */
				sdx_terms.setId(sdx_string);
                sdx_qid=sdx_string;

			}
			if (sdx_page &lt; 1) {
				<xsl:call-template name="sdx:parameter">
					<xsl:with-param name="name" select="'page'"/>
					<xsl:with-param name="abbr" select="'p'"/>
				</xsl:call-template>
				sdx_page=sdx_i;
			}
			if (sdx_terms != null) sdx_terms.toSAX(contentHandler, sdx_page);
		</xsp:logic>
	</xsl:template>
	<!--
		<sdx:includeDocument> : includes a document from the current document application
	-->
	<xsl:template match="sdx:includeDocument">
		<xsl:call-template name="sdx:base"/>
		<xsl:call-template name="sdx:id"/>
		<xsp:logic>
			//TODO : can also use a qid/no combination
			if (sdx_check(sdx_id)) 
			{
				sdx_consumer=(XMLConsumer)contentHandler;
				<xsl:call-template name="sdx:hilite"/>
				if (sdx_pipeline != null) sdx_consumer=(XMLConsumer)sdx_pipeline;
				sdx_document=new XMLDocument(sdx_id);
				/* don't know type */
				sdx_bool=false; 
				/* if a type param given */
				if (Document.DOCTYPE_HTML.equals(sdx_type)) 
				{
					sdx_document=new HTMLDocument(sdx_id);
					sdx_bool=false;
				}
				else if (Document.DOCTYPE_XML.equals(sdx_type)) 
				{
					sdx_bool=false;
				}
				/* send document to stream */
				sdx_base.getDocument(
					(ParsableDocument)sdx_document,
					new IncludeXMLConsumer(sdx_consumer),
					sdx_bool);
				<xsl:call-template name="sdx:navigation"/>
			}
		</xsp:logic>
	</xsl:template>
	<xsl:template match="sdx:navigation" name="sdx:navigation">
		<xsp:logic xml:title="NAVIGATION - {name()}">
			<xsl:call-template name="sdx:parameter">
				<xsl:with-param name="name" select="'qid'"/>
			</xsl:call-template>
            sdx_object=getSessionObject(session, sdx_parameter);
			if (sdx_object != null &amp;&amp; sdx_object instanceof Results)
			{				
				//If an id is provided, it take precedence over the document's position
				if (sdx_check(sdx_id)) 
					((Results)sdx_object).getNavigationAsSAX(contentHandler, sdx_id);
				else {
					<xsl:call-template name="sdx:parameter">
						<xsl:with-param name="name" select="'no'"/>
						<xsl:with-param name="abbr" select="'n'"/>
					</xsl:call-template>				
					((Results)sdx_object).getNavigationAsSAX(contentHandler, sdx_i);				
				}
			}
		</xsp:logic>
	</xsl:template>
	<!--                                                                      -->
	<!-- ============================ INPUTS ================================ -->
	<!--                                                                      -->
	<!--     Administration of documents bases (insert, delete)               -->
	<!--                                                                      -->
	<!--
		build a IndexParameters sdx_index with parameters
	-->
	<xsl:template match="sdx:index" name="sdx:index">
		<xsp:logic xml:title="INDEX - indexation parameters {name()}">

			sdx_index = new IndexParameters();			
			
			<xsl:call-template name="sdx:parameter">                         
				<xsl:with-param name="name" select="'sameId'"/>   
			</xsl:call-template>   
			if (sdx_check(sdx_parameter))   
			{   
				//the default behavior is IndexParameters.SAME_ID_REPLACE   
				if (sdx_parameter.equalsIgnoreCase("replace")) sdx_index.setSameId(IndexParameters.SAME_ID_REPLACE);   
				if (sdx_parameter.equalsIgnoreCase("error")) sdx_index.setSameId(IndexParameters.SAME_ID_ERROR);   
				if (sdx_parameter.equalsIgnoreCase("ignore")) sdx_index.setSameId(IndexParameters.SAME_ID_IGNORE);   
			}   
			<xsl:call-template name="sdx:parameter">
				<xsl:with-param name="name" select="'attachedDocumentSameId'"/>
			</xsl:call-template>
			if (sdx_check(sdx_parameter))
			{
				//the default behavior is IndexParameters.SAME_ID_SHARED_DOCUMENT_REFRESH
				if (sdx_parameter.equalsIgnoreCase("refresh")) sdx_index.setAttachedDocumentSameId(IndexParameters.SAME_ID_REFRESH_SHARED_DOCUMENT);
				if (sdx_parameter.equalsIgnoreCase("replace")) sdx_index.setAttachedDocumentSameId(IndexParameters.SAME_ID_REPLACE);
				if (sdx_parameter.equalsIgnoreCase("error")) sdx_index.setAttachedDocumentSameId(IndexParameters.SAME_ID_ERROR);
				if (sdx_parameter.equalsIgnoreCase("ignore")) sdx_index.setAttachedDocumentSameId(IndexParameters.SAME_ID_IGNORE);
			}
            <!--setting the parameter for shared secondary documents (attached and sub documents) having ids as existing documents-->
            <xsl:call-template name="sdx:parameter">
				<xsl:with-param name="name" select="'subDocumentSameId'"/>
			</xsl:call-template>
			if (sdx_check(sdx_parameter))
			{
				//the default behavior is IndexParameters.REFRESH_SHARED_DOCUMENT
				if (sdx_parameter.equalsIgnoreCase("refresh")) sdx_index.setSubDocumentSameId(IndexParameters.SAME_ID_REFRESH_SHARED_DOCUMENT);
				if (sdx_parameter.equalsIgnoreCase("replace")) sdx_index.setSubDocumentSameId(IndexParameters.SAME_ID_REPLACE);
				if (sdx_parameter.equalsIgnoreCase("error")) sdx_index.setSubDocumentSameId(IndexParameters.SAME_ID_ERROR);
				if (sdx_parameter.equalsIgnoreCase("ignore")) sdx_index.setSubDocumentSameId(IndexParameters.SAME_ID_IGNORE);
			}
            <!--TODO what other index parameters for same id are possible? one parameter specifically for subdocument?-->


			<!-- the sdx_show logic is
	
			one string is common to all document, define in
	        sdx_show by <sdx:page show="..." showParam="show" .../>
	        a local show could be defined by <sdx:* show="..." showParam="?" .../>
	
	        sdx_show2 store general or local show if one
	        then, define params
			-->

			<xsl:call-template name="sdx:parameter">
				<xsl:with-param name="name" select="'show'"/>
				<xsl:with-param name="http" select="''"/>
			</xsl:call-template>
			sdx_show2=sdx_show;
			if (sdx_check(sdx_parameter)) sdx_show2=sdx_parameter;
			if (sdx_show2 != null)
			{
				if (sdx_show2.indexOf("summary") != -1) sdx_index.setSendIndexationEvents(IndexParameters.SEND_STATS_EVENTS);
				if (sdx_show2.indexOf("failures") != -1) sdx_index.setSendIndexationEvents(IndexParameters.SEND_ERRORS_EVENTS);
				if (sdx_show2.indexOf("additions") != -1) sdx_index.setSendIndexationEvents(IndexParameters.SEND_ALL_EVENTS);
			}
			<xsl:call-template name="sdx:parameter">
				<xsl:with-param name="name" select="'batch'"/>
			</xsl:call-template>
			if (sdx_i &gt; 0) sdx_index.setBatchMax(sdx_i);
			<xsl:choose>
				<!-- if user pipeline given, parse it, if not, get default -->
				<xsl:when test="sdx:pipeline/sdx:transformation">
					<xsl:apply-templates select="sdx:pipeline"/>
					if (sdx_pipeline != null) sdx_index.setPipeline(sdx_pipeline);
					sdx_pipeline=null;
				</xsl:when>
				<xsl:when test="sdx:pipeline/sdx:parameter">
					if (sdx_base != null) sdx_pipeline=sdx_base.getIndexationPipeline();
				</xsl:when>
			</xsl:choose>
			<xsl:if test="sdx:pipeline/sdx:parameter">
				if (sdx_pipeline != null)
				//TODO?:fred why are you nullifying the pipe above?-rbp
					sdx_params=sdx_pipeline.getParameters();
				if (sdx_index != null &amp;&amp; sdx_index.getPipeline() != null)
					sdx_params=sdx_index.getPipeline().getParameters();
				if (sdx_params == null)
					sdx_params=new Parameters();
				<!-- add indexation parameters on each tag sdx:parameter -->
				<xsl:for-each select="sdx:pipeline/sdx:parameter">
					<xsl:apply-templates select="."/>
					if (sdx_params != null &amp;&amp; sdx_name != null &amp;&amp; sdx_parameter != null) 
						sdx_params.setParameter(sdx_name, sdx_parameter);
				</xsl:for-each>
				sdx_index.setPipelineParams(sdx_params);
			</xsl:if>
			<xsl:if test="ancestor::sdx:debug">
				<sdx:debug title="INDEXATION PARAMETERS">
					<xsp:attribute name="element">
						<xsl:value-of select="name()"/>
					</xsp:attribute>
				</sdx:debug>
			</xsl:if>
		</xsp:logic>
	</xsl:template>
	<!-- build a document -->
	<xsl:template name="sdx:document" match="sdx:page//sdx:document">
		<xsl:param name="parameters" select="true()"/>
		<xsp:logic xml:title="DOCUMENT">
			<xsl:call-template name="comment">
				<xsl:with-param name="name" select="'DOCUMENT'"/>
			</xsl:call-template> sdx_document=null;
			<xsl:if test="$parameters">
				<!-- id could be modified or setted by url, or indexed content -->
				<xsl:call-template name="sdx:id"/>
				<!-- type could be modified by content -->
				<xsl:call-template name="sdx:type"/>
				<xsl:call-template name="sdx:url"/>
				<xsl:call-template name="sdx:file"/>
				<xsl:call-template name="sdx:xml"/>
				<xsl:call-template name="sdx:dom"/>
			</xsl:if>
			/* set type */
			if ("text/xml".equals(sdx_type)) sdx_document=new XMLDocument();
			else if ("text/html".equals(sdx_type)) sdx_document=new HTMLDocument();
			else if (Document.DOCTYPE_XML.equals(sdx_type)) { sdx_type="text/xml"; sdx_document=new XMLDocument(); }
			else if (Document.DOCTYPE_HTML.equals(sdx_type)) { sdx_type="text/html"; sdx_document=new HTMLDocument(); }
			else if (sdx_check(sdx_xml)) { sdx_type="text/xml"; sdx_document=new XMLDocument();}
			else if (sdx_url != null) { sdx_type="text/xml"; sdx_document=new XMLDocument(); }
			else if (sdx_dom != null) { sdx_type="text/xml"; sdx_document=new XMLDocument(); }
			else { sdx_document=new XMLDocument(); sdx_type="text/xml"; }

			if (sdx_check(sdx_type)) sdx_document.setMimeType(sdx_type);

			/* set id */
			if (sdx_check(sdx_id)) sdx_document.setId(sdx_id);
			else if (sdx_url != null) sdx_document.setId(sdx_url.toExternalForm());
			/* set content */
			if (sdx_url != null) sdx_document.setContent(sdx_url);
			else if (sdx_check(sdx_xml)) sdx_document.setContent(sdx_xml.getBytes("UTF-8"));
			else if (sdx_file != null) sdx_document.setContent(sdx_file);
			else if (sdx_dom != null) ((XMLDocument)sdx_document).setContent(sdx_dom);
			else sdx_document=null;
		</xsp:logic>
	</xsl:template>
	<xsl:template match="sdx:uploadDocument">
		<xsp:logic xml:title="IMPORT">
			<xsl:call-template name="comment"/>
			<xsl:call-template name="sdx:repo"/>
			if (sdx_repo != null)
			{
				<xsl:call-template name="sdx:document"/>
				if (sdx_document != null)
				{
					<xsl:call-template name="sdx:index"/>
					sdx_base.index((IndexableDocument)sdx_document, sdx_repo, sdx_index , contentHandler);
					<xsl:apply-templates select="sdx:success/node()"/>
				}
				else 
				{
					<xsl:apply-templates select="sdx:fallback/*"/>
				}
			}
		</xsp:logic>
	</xsl:template>
	<xsl:template match="sdx:uploadDocuments">
		<xsp:logic xml:title="IMPORTS">
			<xsl:call-template name="comment"/>
			<xsl:call-template name="sdx:repo"/>
			if (sdx_check(sdx_type)) sdx_type="text/xml";
			if (sdx_repo != null)
			{
				<!-- sources for documents -->
				<xsl:call-template name="sdx:dir"/>
				<xsl:call-template name="sdx:url"/>
				<xsl:call-template name="sdx:zip"/>
				<xsl:call-template name="sdx:type"/>
				if (sdx_zip != null) sdx_dir=sdx_unzip(sdx_zip);
				if (sdx_dir != null)
				{
					<xsl:call-template name="sdx:parameter">
						<xsl:with-param name="name" select="'includes'"/>
					</xsl:call-template>
					sdx_pattern=sdx_parameter;
					<xsl:call-template name="sdx:parameter">
						<xsl:with-param name="name" select="'excludes'"/>
					</xsl:call-template>
					sdx_vector=sdx_dir(sdx_dir, sdx_pattern, sdx_parameter, null);
					sdx_enum = sdx_vector.elements();
					sdx_documents=new IndexableDocument[sdx_vector.size()];
					<xsl:if test="ancestor::sdx:debug">
						<sdx:debug title="DOCUMENTS">
							<xsp:attribute name="size">
								<xsp:expr>sdx_vector.size()</xsp:expr>
							</xsp:attribute>
						</sdx:debug>
					</xsl:if>
					sdx_i=0;
					while (sdx_enum.hasMoreElements())
					{
						sdx_document=new XMLDocument();
						if (false) {}
						else if ("text/html".equals(sdx_type)) sdx_document=new HTMLDocument();
						else if (Document.DOCTYPE_HTML.equals(sdx_type)) 
						{ 
							sdx_type="text/html"; 
							sdx_document=new HTMLDocument();
						}
						sdx_file=(File)sdx_enum.nextElement();
                        if (sdx_url != null)
                            sdx_document.setContent(sdx_file.toURL());
						else
                            sdx_document.setContent(sdx_file);
						<xsl:if test="ancestor::sdx:debug">
							<sdx:debug title="DOCUMENT">
								<xsp:attribute name="n">
									<xsp:expr>sdx_i</xsp:expr>
								</xsp:attribute>
								<xsp:attribute name="file">
									<xsp:expr>sdx_file</xsp:expr>
								</xsp:attribute>
							</sdx:debug>
						</xsl:if>
						sdx_documents[sdx_i]=sdx_document;
						sdx_i++;
					}
					<xsl:call-template name="sdx:index"/>
					sdx_base.index((IndexableDocument[])sdx_documents, sdx_repo, sdx_index , contentHandler);
					<xsl:apply-templates select="sdx:success/node()"/>
                    if (sdx_zip != null &amp;&amp; sdx_dir != null)
                            FileUtil.deleteDirectory(sdx_dir);//recursive delete of tmp zip dir
				}
				else 
				{
					<xsl:apply-templates select="sdx:fallback/node()"/>
				}
			} 
		</xsp:logic>
	</xsl:template>
	<!--
            Ce tag permet de supprimer un document d'une base. Il prend un paramètre,
            soit le nom du paramètre qui contient l'identificateur du document.
            Ce paramètre doit être dans l'attribut "idParam".
    -->
	<xsl:template match="sdx:deleteDocument ">
		<xsp:logic xml:title="DELETE - ">
			<xsl:call-template name="comment"/>
			<xsl:call-template name="sdx:base"/>
			<xsl:call-template name="sdx:parameter">
				<xsl:with-param name="name" select="'delete'"/>
			</xsl:call-template>
			if (sdx_bool)
			{
				<xsl:call-template name="sdx:id"/>
				if (sdx_check(sdx_id))
				{
					<!-- in fact, we don't need to know the type of document before delete, TEMP -->
					sdx_document=new XMLDocument(sdx_id);
					sdx_base.delete(sdx_document, contentHandler);
					<xsl:apply-templates select="sdx:success"/>
				}
			}
			<xsl:if test="sdx:fallback">
				else
				{
					<xsl:apply-templates select="sdx:fallback"/>
				}
			</xsl:if>
		</xsp:logic>
	</xsl:template>
	<!-- 
		Behaviour : reacts on a qid attribute, 
		or on the queries nested ;
		queries may be executed before deleting 
	-->
	<xsl:template match="sdx:deleteDocuments">
		<xsp:logic xml:title="DELETES - delete docs on a query (cached or expressed)">
			<xsl:call-template name="sdx:parameter">
				<xsl:with-param name="name" select="'delete'"/>
			</xsl:call-template>
			if (sdx_bool)
			{
				<xsl:call-template name="comment"/>
				sdx_query=null;
				sdx_results=null;
				<xsl:call-template name="sdx:build-locations"/>
				<xsl:apply-templates select="*[contains(name(), 'Query')]"/>
				<xsl:call-template name="sdx:results"/>
				if (sdx_results != null)
				{
					sdx_pipeline = new DeleteResultsPipeline();
					sdx_pipeline.enableLogging(sdx_log);
					/* needed so that the framework will be available for executing the deletions */
					sdx_pipeline.compose(manager);
					/* indicates the id of the application from which deletion is desired */
					((DeleteResultsPipeline)sdx_pipeline).setApplicationId(sdx_application.getId());
					/* the content handler to feed with deletion events */
					sdx_pipeline.setConsumer((XMLConsumer)contentHandler);
					/* passing result events to the delete results transformation */
					<!-- use the show template -->
					// sdx_results.toSAX(sdx_pipeline); 
					<xsl:call-template name="sdx:show"/>
					sdx_results=null;
					session.removeAttribute("sdx_"+sdx_qid);
				}
			}
		</xsp:logic>
	</xsl:template>
	<!--                                                                      -->
	<!-- ========================== RIGHTS =================================== -->
	<!--                                                                      -->
	<xsl:template match="sdx:login">
		<xsp:logic xml:title="LOGIN">
			<xsl:call-template name="comment"/>
			<xsl:call-template name="sdx:app"/>
			<xsl:call-template name="sdx:parameter">
				<xsl:with-param name="name" select="'id'"/>
			</xsl:call-template> sdx_id=sdx_parameter;
			<xsl:call-template name="sdx:parameter">
				<xsl:with-param name="name" select="'pass'"/>
			</xsl:call-template>
			<xsl:if test="ancestor::sdx:debug">
				<sdx:debug title="LOGIN">
					<xsp:attribute name="id">
						<xsp:expr>sdx_id</xsp:expr>
					</xsp:attribute>
					<xsp:attribute name="pass">
						<xsp:expr>sdx_parameter</xsp:expr>
					</xsp:attribute>
					<xsp:attribute name="element">
						<xsl:value-of select="name()"/>
					</xsp:attribute>
					<xsp:attribute name="app">
						<xsp:expr>sdx_app</xsp:expr>
					</xsp:attribute>
				</sdx:debug>
			</xsl:if>
			if (sdx_check(sdx_id))
			{
                if (sdx_app != null &amp;&amp; sdx_app.validateUser(sdx_id, sdx_parameter))
				{
					/* logged-in */
					sdx_user=sdx_app.getUserInformation(sdx_id);
					session.setAttribute("sdx_user", sdx_user);
					<xsl:apply-templates select="*[name()!='sdx:fallback']"/>
				}
				/* not logged-in */
				else
				{
					<xsl:apply-templates select="sdx:fallback/*"/>
				}
			}
		</xsp:logic>
	</xsl:template>
	<xsl:template match="sdx:loginSu">
		<xsp:logic xml:title="loginSu - logged as super-user (server admin)">
			<xsl:call-template name="comment"/>
			<xsl:call-template name="sdx:parameter">
				<xsl:with-param name="name" select="'id'"/>
			</xsl:call-template> 
			sdx_id=sdx_parameter;
			<xsl:call-template name="sdx:parameter">
				<xsl:with-param name="name" select="'pass'"/>
			</xsl:call-template>
			if (sdx_check(sdx_id) &amp;&amp; sdx_check(sdx_parameter))
			{
				try {
					sdx_user=sdx_frame.validateSuperUser(sdx_id, sdx_parameter);
					session.setAttribute("sdx_user", sdx_user);
					<xsl:apply-templates select="*[name()!='sdx:fallback']"/>
				}
				catch(Exception e) { 
					<xsl:apply-templates select="sdx:fallback/*"/> 
				}
			}
		</xsp:logic>
	</xsl:template>
	<!--
    When this tag is matched,
    if the sdx:parameter @logout is set to true
    then any user saved in session is replaced
    by anonymous user
   -->
	<xsl:template match="sdx:logout">
		<xsp:logic xml:title="LOGOUT">
			<xsl:call-template name="comment"/>
			<xsl:call-template name="sdx:app"/>
			<xsl:call-template name="sdx:parameter">
				<xsl:with-param name="name" select="'logout'"/>
			</xsl:call-template>
			if (sdx_check(sdx_parameter))
			{
				if (sdx_app != null) sdx_user=sdx_app.getUserInformation(null);
				else sdx_user=null;
				session.setAttribute("sdx_user", sdx_user);
			}
		</xsp:logic>
	</xsl:template>
	<xsl:template match="sdx:userIsAdmin ">
		<xsp:logic xml:title="userIsAdmin">
			<xsl:call-template name="comment"/>
			<xsl:call-template name="sdx:app"/>
			if (sdx_app != null) sdx_parameter=sdx_app.getDefaultAdminGroupId();
			if (sdx_user != null &amp;&amp; sdx_app != null &amp;&amp; 
				sdx_app.getId().equals(sdx_user.getAppId()) &amp;&amp; 
				sdx_user.isMember(sdx_parameter))
			{ 
				<xsp:logic xml:title="ISADMIN">
					<xsl:apply-templates select="*[name()!='sdx:fallback']"/>
				</xsp:logic> 
			}
			<xsl:if test="sdx:fallback">
				/* not Member */
				else 
				{ 
					<xsp:logic xml:title="NOT ADMIN">
						<xsl:apply-templates select="sdx:fallback/*"/>
					</xsp:logic>
				}
			</xsl:if>
		</xsp:logic>
	</xsl:template>
	<xsl:template match="sdx:userIsMember">
		<xsp:logic xml:title="ISMEMBER">
			<xsl:call-template name="comment"/>
			<xsl:call-template name="sdx:app"/>
			<xsl:call-template name="sdx:parameters">
				<xsl:with-param name="name" select="'group'"/>
			</xsl:call-template>
			<xsl:call-template name="sdx:parameter">
				<xsl:with-param name="name" select="'op'"/>
			</xsl:call-template>
			if (sdx_op == Query.OPERATOR_AND) sdx_bool=true;
			else sdx_bool=false;
			/* isMember */
			if (sdx_user != null &amp;&amp; sdx_app != null &amp;&amp; 
				sdx_app.getId().equals(sdx_user.getAppId()) &amp;&amp; 
				sdx_user.isMember(sdx_parameters, sdx_bool))
			{ 
				<xsl:apply-templates select="*[name()!='sdx:fallback']"/>
			}
			/* not Member */
			else 
			{
				<xsl:apply-templates select="sdx:fallback/*"/>
			}
		</xsp:logic>
	</xsl:template>
	<xsl:template match="sdx:userIsSu">
		<xsp:logic xml:title="ISSU">
			<xsl:call-template name="comment"/>
			if (sdx_frame.isSuperUserSet() &amp;&amp; sdx_user != null &amp;&amp; sdx_user.isSuperuser())
			/* isMember */
			{
				<xsl:apply-templates select="*[name()!='sdx:fallback']"/>
			}
			/* not isMember */
			else
			{
				<xsl:apply-templates select="sdx:fallback/*"/>
			}
		</xsp:logic>
	</xsl:template>
	<xsl:template match="sdx:userIsAdminOrSu">
		<xsl:call-template name="comment"/>
		<xsl:call-template name="sdx:app"/>
		<xsp:logic>
			if (
				(sdx_app !=null &amp;&amp; 
				sdx_app.getId().equals(sdx_user.getAppId()) &amp;&amp; 
				sdx_user.isMember(sdx_app.getDefaultAdminGroupId()))
				|| 
				(sdx_frame.isSuperUserSet() &amp;&amp; sdx_user != null &amp;&amp; sdx_user.isSuperuser())
			)
			/* isMember */
			{
				<xsl:apply-templates select="*[name()!='sdx:fallback']"/>
			}
			/* not isMember */
			else
			{
				<xsl:apply-templates select="sdx:fallback/*"/>
			}
		</xsp:logic>
	</xsl:template>
</xsl:stylesheet>
