/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.httpclient;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.net.Socket;
import java.net.SocketException;
import javax.net.ssl.SSLSocketFactory;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.HttpRecoverableException;
import org.apache.commons.httpclient.RequestOutputStream;
import org.apache.commons.httpclient.ResponseInputStream;
import org.apache.commons.httpclient.log.Log;
import org.apache.commons.httpclient.log.LogSource;

public class HttpConnection {
    private static final Log log = LogSource.getInstance("org.apache.commons.httpclient.HttpConnection");
    private static final Log wireLog = LogSource.getInstance("httpclient.wire");
    private String _host = null;
    private int _port = -1;
    private String _proxyHost = null;
    private int _proxyPort = -1;
    private Socket _socket = null;
    private InputStream _input = null;
    private OutputStream _output = null;
    private boolean _open = false;
    private boolean _ssl = false;
    private static final byte[] CRLF = "\r\n".getBytes();
    private int _so_timeout = 0;

    public HttpConnection(String host, int port) {
        this(null, -1, host, port, false);
    }

    public HttpConnection(String host, int port, boolean secure) {
        this(null, -1, host, port, secure);
    }

    public HttpConnection(String proxyHost, int proxyPort, String host, int port) {
        this(proxyHost, proxyPort, host, port, false);
    }

    public HttpConnection(String proxyHost, int proxyPort, String host, int port, boolean secure) {
        log.debug("HttpConnection.HttpConnection");
        if (host == null) {
            throw new NullPointerException("host parameter is null");
        }
        this._proxyHost = proxyHost;
        this._proxyPort = proxyPort;
        this._host = host;
        this._port = port;
        this._ssl = secure;
    }

    public String getHost() {
        return this._host;
    }

    public void setHost(String host) throws IllegalStateException {
        if (host == null) {
            throw new NullPointerException("host parameter is null");
        }
        this.assertNotOpen();
        this._host = host;
    }

    public int getPort() {
        return this._port;
    }

    public void setPort(int port) throws IllegalStateException {
        this.assertNotOpen();
        this._port = port;
    }

    public String getProxyHost() {
        return this._proxyHost;
    }

    public void setProxyHost(String host) throws IllegalStateException {
        this.assertNotOpen();
        this._proxyHost = host;
    }

    public int getProxyPort() {
        return this._proxyPort;
    }

    public void setProxyPort(int port) throws IllegalStateException {
        this.assertNotOpen();
        this._proxyPort = port;
    }

    public boolean isSecure() {
        return this._ssl;
    }

    public void setSecure(boolean secure) throws IllegalStateException {
        this.assertNotOpen();
        this._ssl = secure;
    }

    public boolean isOpen() {
        return this._open;
    }

    public boolean isProxied() {
        return null != this._proxyHost && 0 < this._proxyPort;
    }

    public void setSoTimeout(int timeout) throws SocketException, IllegalStateException {
        log.debug("HttpConnection.setSoTimeout()");
        this._so_timeout = timeout;
        if (this._socket != null) {
            this._socket.setSoTimeout(timeout);
        }
    }

    public void open() throws IOException {
        log.debug("HttpConnection.open()");
        this.assertNotOpen();
        try {
            if (null == this._socket) {
                String host = null == this._proxyHost ? this._host : this._proxyHost;
                int port = null == this._proxyHost ? this._port : this._proxyPort;
                this._socket = this._ssl ? SSLSocketFactory.getDefault().createSocket(host, port) : new Socket(host, port);
            }
            this._socket.setSoTimeout(this._so_timeout);
            this._input = this._socket.getInputStream();
            this._output = this._socket.getOutputStream();
            this._open = true;
        }
        catch (IOException e) {
            this.closeSocketAndStreams();
            throw e;
        }
    }

    public OutputStream getRequestOutputStream() throws IOException, IllegalStateException {
        this.assertOpen();
        RequestOutputStream out = new RequestOutputStream(this._output);
        return out;
    }

    public OutputStream getRequestOutputStream(boolean useChunking) throws IOException, IllegalStateException {
        this.assertOpen();
        RequestOutputStream out = new RequestOutputStream(this._output, useChunking);
        return out;
    }

    public InputStream getResponseInputStream(HttpMethod method) throws IOException, IllegalStateException {
        this.assertOpen();
        return new ResponseInputStream(this._input, method);
    }

    public void write(byte[] data) throws IOException, IllegalStateException, HttpRecoverableException {
        if (log.isDebugEnabled()) {
            log.debug("HttpConnection.write(byte[])");
        }
        this.assertOpen();
        if (wireLog.isInfoEnabled() && data.length > 0) {
            wireLog.info(">> \"" + new String(data) + "\"");
        }
        try {
            this._output.write(data);
        }
        catch (SocketException e) {
            if (log.isDebugEnabled()) {
                log.debug("HttpConnection: Socket exception while writing data", e);
            }
            throw new HttpRecoverableException(e.toString());
        }
        catch (IOException e) {
            if (log.isDebugEnabled()) {
                log.debug("HttpConnection: Exception while writing data", e);
            }
            throw e;
        }
    }

    public void writeLine(byte[] data) throws IOException, IllegalStateException, HttpRecoverableException {
        if (log.isDebugEnabled()) {
            log.debug("HttpConnection.writeLine(byte[])");
        }
        this.assertOpen();
        if (wireLog.isInfoEnabled() && data.length > 0) {
            wireLog.info(">> \"" + new String(data) + "\"");
        }
        try {
            this._output.write(data);
            this.writeLine();
        }
        catch (SocketException e) {
            if (log.isDebugEnabled()) {
                log.debug("HttpConnection: Socket exception while writing data", e);
            }
            throw new HttpRecoverableException(e.toString());
        }
        catch (IOException e) {
            throw e;
        }
    }

    public void writeLine() throws IOException, IllegalStateException, HttpRecoverableException {
        if (log.isDebugEnabled()) {
            log.debug("HttpConnection.writeLine()");
        }
        wireLog.info(">> \\r\\n");
        try {
            this._output.write(CRLF);
        }
        catch (SocketException e) {
            if (log.isDebugEnabled()) {
                log.debug("HttpConnection: Socket exception while writing data", e);
            }
            throw new HttpRecoverableException(e.toString());
        }
        catch (IOException e) {
            throw e;
        }
    }

    public void print(String data) throws IOException, IllegalStateException, HttpRecoverableException {
        this.write(data.getBytes());
    }

    public void printLine(String data) throws IOException, IllegalStateException, HttpRecoverableException {
        this.writeLine(data.getBytes());
    }

    public void printLine() throws IOException, IllegalStateException, HttpRecoverableException {
        this.writeLine();
    }

    public String readLine() throws IOException, IllegalStateException {
        log.debug("HttpConnection.readLine()");
        this.assertOpen();
        StringBuffer buf = new StringBuffer();
        while (true) {
            int ch;
            if ((ch = this._input.read()) < 0) {
                if (buf.length() != 0) break;
                return null;
            }
            if (ch == 13) continue;
            if (ch == 10) break;
            buf.append((char)ch);
        }
        if (wireLog.isInfoEnabled() && buf.length() > 0) {
            wireLog.info("<< \"" + buf.toString() + "\" [\\r\\n]");
        }
        return buf.toString();
    }

    public void shutdownOutput() throws IOException {
        log.debug("HttpConnection.shutdownOutput()");
        try {
            Class[] paramsClasses = new Class[]{};
            Method shutdownOutput = this._socket.getClass().getMethod("shutdownOutput", paramsClasses);
            Object[] params = new Object[]{};
            shutdownOutput.invoke((Object)this._socket, params);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void close() throws IOException {
        log.debug("HttpConnection.close()");
        this.closeSocketAndStreams();
    }

    protected void closeSocketAndStreams() {
        log.debug("HttpConnection.closeSocketAndStreams()");
        try {
            this._input.close();
        }
        catch (Exception e) {
            // empty catch block
        }
        this._input = null;
        try {
            this._output.close();
        }
        catch (Exception e) {
            // empty catch block
        }
        this._output = null;
        try {
            this._socket.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this._socket = null;
        this._open = false;
    }

    protected void assertNotOpen() throws IllegalStateException {
        if (this._open) {
            throw new IllegalStateException("Connection is open");
        }
    }

    protected void assertOpen() throws IllegalStateException {
        if (!this._open) {
            throw new IllegalStateException("Connection is not open");
        }
    }
}

