/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.gvt.font;

import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphJustificationInfo;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.text.AttributedCharacterIterator;
import org.apache.batik.gvt.font.GVTFont;
import org.apache.batik.gvt.font.GVTGlyphMetrics;
import org.apache.batik.gvt.font.GVTGlyphVector;
import org.apache.batik.gvt.font.Glyph;

public final class SVGGVTGlyphVector
implements GVTGlyphVector {
    private GVTFont font;
    private Glyph[] glyphs;
    private FontRenderContext frc;
    private GeneralPath outline;
    private Rectangle2D logicalBounds;
    private Rectangle2D bounds2D;
    private Shape[] glyphLogicalBounds;
    private boolean[] glyphVisible;
    private Point2D endPos;

    public SVGGVTGlyphVector(GVTFont gVTFont, Glyph[] glyphArray, FontRenderContext fontRenderContext) {
        this.font = gVTFont;
        this.glyphs = glyphArray;
        this.frc = fontRenderContext;
        this.outline = null;
        this.bounds2D = null;
        this.logicalBounds = null;
        this.glyphLogicalBounds = new Shape[glyphArray.length];
        this.glyphVisible = new boolean[glyphArray.length];
        for (int i = 0; i < glyphArray.length; ++i) {
            this.glyphVisible[i] = true;
        }
        this.endPos = glyphArray[glyphArray.length - 1].getPosition();
        this.endPos = new Point2D.Float((float)(this.endPos.getX() + (double)glyphArray[glyphArray.length - 1].getHorizAdvX()), (float)this.endPos.getY());
    }

    public GVTFont getFont() {
        return this.font;
    }

    public FontRenderContext getFontRenderContext() {
        return this.frc;
    }

    public int getGlyphCode(int n) throws IndexOutOfBoundsException {
        if (n < 0 || n > this.glyphs.length - 1) {
            throw new IndexOutOfBoundsException("glyphIndex " + n + " is out of bounds, should be between 0 and " + (this.glyphs.length - 1));
        }
        return this.glyphs[n].getGlyphCode();
    }

    public int[] getGlyphCodes(int n, int n2, int[] nArray) throws IndexOutOfBoundsException, IllegalArgumentException {
        if (n2 < 0) {
            throw new IllegalArgumentException("numEntries argument value, " + n2 + ", is illegal. It must be > 0.");
        }
        if (n < 0) {
            throw new IndexOutOfBoundsException("beginGlyphIndex " + n + " is out of bounds, should be between 0 and " + (this.glyphs.length - 1));
        }
        if (n + n2 > this.glyphs.length) {
            throw new IndexOutOfBoundsException("beginGlyphIndex + numEntries (" + n + "+" + n2 + ") exceeds the number of glpyhs in this GlyphVector");
        }
        if (nArray == null) {
            nArray = new int[n2];
        }
        for (int i = n; i < n + n2; ++i) {
            nArray[i - n] = this.glyphs[i].getGlyphCode();
        }
        return nArray;
    }

    public GlyphJustificationInfo getGlyphJustificationInfo(int n) {
        if (n < 0 || n > this.glyphs.length - 1) {
            throw new IndexOutOfBoundsException("glyphIndex: " + n + ", is out of bounds. Should be between 0 and " + (this.glyphs.length - 1) + ".");
        }
        return null;
    }

    public Shape getGlyphLogicalBounds(int n) {
        if (this.glyphLogicalBounds[n] == null && this.glyphVisible[n]) {
            this.computeGlyphLogicalBounds();
        }
        return this.glyphLogicalBounds[n];
    }

    private void computeGlyphLogicalBounds() {
        GeneralPath generalPath;
        Rectangle2D rectangle2D;
        Object object;
        Shape[] shapeArray;
        float f = 0.0f;
        float f2 = 0.0f;
        if (this.font != null) {
            shapeArray = this.font.getLineMetrics("By", this.frc);
            f = shapeArray.getAscent();
            f2 = shapeArray.getDescent();
            if (f2 < 0.0f) {
                f2 = -f2;
            }
        }
        if (f == 0.0f) {
            float f3 = 0.0f;
            float f4 = 0.0f;
            for (int i = 0; i < this.getNumGlyphs(); ++i) {
                if (!this.glyphVisible[i]) continue;
                object = this.getGlyphMetrics(i);
                Rectangle2D rectangle2D2 = ((GVTGlyphMetrics)object).getBounds2D();
                f = (float)(-rectangle2D2.getMinY());
                f2 = (float)(rectangle2D2.getHeight() - (double)f);
                if (f > f3) {
                    f3 = f;
                }
                if (!(f2 > f4)) continue;
                f4 = f2;
            }
            f = f3;
            f2 = f4;
        }
        shapeArray = new Shape[this.getNumGlyphs()];
        boolean[] blArray = new boolean[this.getNumGlyphs()];
        boolean[] blArray2 = new boolean[this.getNumGlyphs()];
        object = new boolean[this.getNumGlyphs()];
        double d = -1.0;
        double d2 = -1.0;
        for (int i = 0; i < this.getNumGlyphs(); ++i) {
            Rectangle2D rectangle2D3;
            double d3;
            if (!this.glyphVisible[i]) {
                shapeArray[i] = null;
                continue;
            }
            AffineTransform affineTransform = this.getGlyphTransform(i);
            GVTGlyphMetrics gVTGlyphMetrics = this.getGlyphMetrics(i);
            rectangle2D = new Rectangle2D.Double(0.0, -f, gVTGlyphMetrics.getHorizontalAdvance(), f + f2);
            if (rectangle2D.isEmpty()) {
                if (i > 0) {
                    blArray[i] = blArray[i - 1];
                    blArray2[i] = blArray2[i - 1];
                    object[i] = object[i - 1];
                    continue;
                }
                blArray[i] = true;
                blArray2[i] = false;
                object[i] = false;
                continue;
            }
            Point2D.Double double_ = new Point2D.Double(rectangle2D.getMinX(), rectangle2D.getMinY());
            Point2D.Double double_2 = new Point2D.Double(rectangle2D.getMaxX(), rectangle2D.getMinY());
            Point2D.Double double_3 = new Point2D.Double(rectangle2D.getMinX(), rectangle2D.getMaxY());
            AffineTransform affineTransform2 = AffineTransform.getTranslateInstance(this.getGlyphPosition(i).getX(), this.getGlyphPosition(i).getY());
            if (affineTransform != null) {
                affineTransform2.concatenate(affineTransform);
            }
            shapeArray[i] = affineTransform2.createTransformedShape(rectangle2D);
            Point2D.Double double_4 = new Point2D.Double();
            Point2D.Double double_5 = new Point2D.Double();
            Point2D.Double double_6 = new Point2D.Double();
            affineTransform2.transform(double_, double_4);
            affineTransform2.transform(double_2, double_5);
            affineTransform2.transform(double_3, double_6);
            double d4 = ((Point2D)double_4).getX() - ((Point2D)double_5).getX();
            double d5 = ((Point2D)double_4).getX() - ((Point2D)double_6).getX();
            double d6 = ((Point2D)double_4).getY() - ((Point2D)double_5).getY();
            double d7 = ((Point2D)double_4).getY() - ((Point2D)double_6).getY();
            if (Math.abs(d4) < 0.001 && Math.abs(d7) < 0.001) {
                blArray[i] = false;
                double d8 = ((Point2D)double_).getX() - ((Point2D)double_3).getX();
                d3 = ((Point2D)double_).getY() - ((Point2D)double_2).getY();
                if (Math.abs(d5 + d8) < 0.001) {
                    blArray2[i] = true;
                }
                if (Math.abs(d6 + d3) < 0.001) {
                    object[i] = true;
                }
            } else if (Math.abs(d5) < 0.001 && Math.abs(d6) < 0.001) {
                blArray[i] = false;
                double d9 = ((Point2D)double_).getX() - ((Point2D)double_2).getX();
                d3 = ((Point2D)double_).getY() - ((Point2D)double_3).getY();
                if (Math.abs(d4 + d9) < 0.001) {
                    blArray2[i] = true;
                }
                if (Math.abs(d7 + d3) < 0.001) {
                    object[i] = true;
                }
            } else {
                blArray[i] = true;
                blArray2[i] = false;
                object[i] = false;
            }
            if ((rectangle2D3 = shapeArray[i].getBounds2D()).getWidth() > d) {
                d = rectangle2D3.getWidth();
            }
            if (!(rectangle2D3.getHeight() > d2)) continue;
            d2 = rectangle2D3.getHeight();
        }
        GeneralPath generalPath2 = new GeneralPath();
        for (int i = 0; i < this.getNumGlyphs(); ++i) {
            if (shapeArray[i] == null) continue;
            generalPath2.append(shapeArray[i], false);
        }
        Rectangle2D rectangle2D4 = generalPath2.getBounds2D();
        if (rectangle2D4.getHeight() < d2 * 1.5) {
            for (int i = 0; i < this.getNumGlyphs(); ++i) {
                if (blArray[i] || shapeArray[i] == null) continue;
                rectangle2D = shapeArray[i].getBounds2D();
                double d10 = rectangle2D.getMinX();
                double d11 = rectangle2D.getWidth();
                if (i < this.getNumGlyphs() - 1 && shapeArray[i + 1] != null) {
                    Rectangle2D rectangle2D5 = shapeArray[i + 1].getBounds2D();
                    if (rectangle2D5.getX() > d10) {
                        d11 = rectangle2D5.getX() - d10;
                    } else {
                        double d12 = rectangle2D5.getX() + rectangle2D5.getWidth();
                        d11 += d10 - d12;
                        d10 = d12;
                    }
                }
                float f5 = (float)d10;
                float f6 = (float)((double)f5 + d11);
                float f7 = (float)rectangle2D4.getMinY();
                float f8 = (float)((double)f7 + rectangle2D4.getHeight());
                if (blArray2[i]) {
                    if (object[i] != false) {
                        generalPath = new GeneralPath();
                        generalPath.moveTo(f6, f8);
                        generalPath.lineTo(f5, f8);
                        generalPath.lineTo(f5, f7);
                        generalPath.lineTo(f6, f7);
                        generalPath.lineTo(f6, f8);
                        generalPath.closePath();
                        shapeArray[i] = generalPath;
                        continue;
                    }
                    generalPath = new GeneralPath();
                    generalPath.moveTo(f6, f7);
                    generalPath.lineTo(f5, f7);
                    generalPath.lineTo(f5, f8);
                    generalPath.lineTo(f6, f8);
                    generalPath.lineTo(f6, f7);
                    generalPath.closePath();
                    shapeArray[i] = generalPath;
                    continue;
                }
                if (object[i] != false) {
                    generalPath = new GeneralPath();
                    generalPath.moveTo(f5, f8);
                    generalPath.lineTo(f6, f8);
                    generalPath.lineTo(f6, f7);
                    generalPath.lineTo(f5, f7);
                    generalPath.lineTo(f5, f8);
                    generalPath.closePath();
                    shapeArray[i] = generalPath;
                    continue;
                }
                shapeArray[i] = new Rectangle2D.Double(f5, f7, f6 - f5, f8 - f7);
            }
        } else if (rectangle2D4.getWidth() < d * 1.5) {
            for (int i = 0; i < this.getNumGlyphs(); ++i) {
                if (blArray[i] || shapeArray[i] == null) continue;
                rectangle2D = shapeArray[i].getBounds2D();
                double d13 = rectangle2D.getMinY();
                double d14 = rectangle2D.getHeight();
                if (i < this.getNumGlyphs() - 1 && shapeArray[i + 1] != null) {
                    Rectangle2D rectangle2D6 = shapeArray[i + 1].getBounds2D();
                    if (rectangle2D6.getY() > d13) {
                        d14 = rectangle2D6.getY() - d13;
                    } else {
                        double d15 = rectangle2D6.getY() + rectangle2D6.getHeight();
                        d14 += d13 - d15;
                        d13 = d15;
                    }
                }
                float f9 = (float)rectangle2D4.getMinX();
                float f10 = (float)((double)f9 + rectangle2D4.getWidth());
                float f11 = (float)d13;
                float f12 = (float)((double)f11 + d14);
                if (blArray2[i]) {
                    if (object[i] != false) {
                        generalPath = new GeneralPath();
                        generalPath.moveTo(f10, f12);
                        generalPath.lineTo(f9, f12);
                        generalPath.lineTo(f9, f11);
                        generalPath.lineTo(f10, f11);
                        generalPath.lineTo(f10, f12);
                        generalPath.closePath();
                        shapeArray[i] = generalPath;
                        continue;
                    }
                    generalPath = new GeneralPath();
                    generalPath.moveTo(f10, f11);
                    generalPath.lineTo(f9, f11);
                    generalPath.lineTo(f9, f12);
                    generalPath.lineTo(f10, f12);
                    generalPath.lineTo(f10, f11);
                    generalPath.closePath();
                    shapeArray[i] = generalPath;
                    continue;
                }
                if (object[i] != false) {
                    generalPath = new GeneralPath();
                    generalPath.moveTo(f9, f12);
                    generalPath.lineTo(f10, f12);
                    generalPath.lineTo(f10, f11);
                    generalPath.lineTo(f9, f11);
                    generalPath.lineTo(f9, f12);
                    generalPath.closePath();
                    shapeArray[i] = generalPath;
                    continue;
                }
                shapeArray[i] = new Rectangle2D.Double(f9, f11, f10 - f9, f12 - f11);
            }
        }
        for (int i = 0; i < this.getNumGlyphs(); ++i) {
            this.glyphLogicalBounds[i] = shapeArray[i];
        }
    }

    public GVTGlyphMetrics getGlyphMetrics(int n) {
        if (n < 0 || n > this.glyphs.length - 1) {
            throw new IndexOutOfBoundsException("glyphIndex: " + n + ", is out of bounds. Should be between 0 and " + (this.glyphs.length - 1) + ".");
        }
        if (n < this.glyphs.length - 1 && this.font != null) {
            float f = this.font.getHKern(this.glyphs[n].getGlyphCode(), this.glyphs[n + 1].getGlyphCode());
            float f2 = this.font.getVKern(this.glyphs[n].getGlyphCode(), this.glyphs[n + 1].getGlyphCode());
            return this.glyphs[n].getGlyphMetrics(f, f2);
        }
        return this.glyphs[n].getGlyphMetrics();
    }

    public Shape getGlyphOutline(int n) {
        if (n < 0 || n > this.glyphs.length - 1) {
            throw new IndexOutOfBoundsException("glyphIndex: " + n + ", is out of bounds. Should be between 0 and " + (this.glyphs.length - 1) + ".");
        }
        return this.glyphs[n].getOutline();
    }

    public Point2D getGlyphPosition(int n) {
        if (n == this.glyphs.length) {
            return this.endPos;
        }
        if (n < 0 || n > this.glyphs.length - 1) {
            throw new IndexOutOfBoundsException("glyphIndex: " + n + ", is out of bounds. Should be between 0 and " + (this.glyphs.length - 1) + ".");
        }
        return this.glyphs[n].getPosition();
    }

    public float[] getGlyphPositions(int n, int n2, float[] fArray) {
        if (n2 < 0) {
            throw new IllegalArgumentException("numEntries argument value, " + n2 + ", is illegal. It must be > 0.");
        }
        if (n < 0) {
            throw new IndexOutOfBoundsException("beginGlyphIndex " + n + " is out of bounds, should be between 0 and " + (this.glyphs.length - 1));
        }
        if (n + n2 > this.glyphs.length + 1) {
            throw new IndexOutOfBoundsException("beginGlyphIndex + numEntries (" + n + "+" + n2 + ") exceeds the number of glpyhs in this GlyphVector");
        }
        if (fArray == null) {
            fArray = new float[n2 * 2];
        }
        if (n + n2 == this.glyphs.length + 1) {
            fArray[--n2 * 2] = (float)this.endPos.getX();
            fArray[n2 * 2 + 1] = (float)this.endPos.getY();
        }
        for (int i = n; i < n + n2; ++i) {
            Point2D point2D = this.glyphs[i].getPosition();
            fArray[(i - n) * 2] = (float)point2D.getX();
            fArray[(i - n) * 2 + 1] = (float)point2D.getY();
        }
        return fArray;
    }

    public AffineTransform getGlyphTransform(int n) {
        if (n < 0 || n > this.glyphs.length - 1) {
            throw new IndexOutOfBoundsException("glyphIndex: " + n + ", is out of bounds. Should be between 0 and " + (this.glyphs.length - 1) + ".");
        }
        return this.glyphs[n].getTransform();
    }

    public Shape getGlyphVisualBounds(int n) {
        if (n < 0 || n > this.glyphs.length - 1) {
            throw new IndexOutOfBoundsException("glyphIndex: " + n + ", is out of bounds. Should be between 0 and " + (this.glyphs.length - 1) + ".");
        }
        return this.glyphs[n].getOutline();
    }

    public Rectangle2D getBounds2D(AttributedCharacterIterator attributedCharacterIterator) {
        if (this.bounds2D != null) {
            return this.bounds2D;
        }
        Rectangle2D rectangle2D = null;
        for (int i = 0; i < this.getNumGlyphs(); ++i) {
            Rectangle2D rectangle2D2;
            if (!this.glyphVisible[i] || (rectangle2D2 = this.glyphs[i].getBounds2D()) == null) continue;
            rectangle2D = rectangle2D == null ? rectangle2D2 : rectangle2D2.createUnion(rectangle2D);
        }
        this.bounds2D = rectangle2D;
        if (this.bounds2D == null) {
            this.bounds2D = new Rectangle2D.Float();
        }
        return this.bounds2D;
    }

    public Rectangle2D getLogicalBounds() {
        if (this.logicalBounds == null) {
            GeneralPath generalPath = new GeneralPath();
            for (int i = 0; i < this.getNumGlyphs(); ++i) {
                Shape shape = this.getGlyphLogicalBounds(i);
                if (shape == null) continue;
                generalPath.append(shape, false);
            }
            this.logicalBounds = generalPath.getBounds2D();
        }
        return this.logicalBounds;
    }

    public int getNumGlyphs() {
        if (this.glyphs != null) {
            return this.glyphs.length;
        }
        return 0;
    }

    public Shape getOutline() {
        if (this.outline == null) {
            this.outline = new GeneralPath();
            for (int i = 0; i < this.glyphs.length; ++i) {
                Shape shape;
                if (!this.glyphVisible[i] || (shape = this.glyphs[i].getOutline()) == null) continue;
                this.outline.append(shape, false);
            }
        }
        return this.outline;
    }

    public Shape getOutline(float f, float f2) {
        Shape shape = this.getOutline();
        AffineTransform affineTransform = AffineTransform.getTranslateInstance(f, f2);
        Shape shape2 = affineTransform.createTransformedShape(shape);
        return shape2;
    }

    public Rectangle2D getGeometricBounds() {
        return this.getOutline().getBounds2D();
    }

    public void performDefaultLayout() {
        float f = 0.0f;
        float f2 = 0.0f;
        for (int i = 0; i < this.glyphs.length; ++i) {
            this.glyphs[i].setPosition(new Point2D.Float(f, f2));
            this.glyphs[i].setTransform(null);
            this.glyphLogicalBounds[i] = null;
            f += this.glyphs[i].getHorizAdvX();
            this.logicalBounds = null;
            this.outline = null;
            this.bounds2D = null;
        }
        this.endPos = new Point2D.Float(f, f2);
    }

    public void setGlyphPosition(int n, Point2D point2D) throws IndexOutOfBoundsException {
        if (n == this.glyphs.length) {
            this.endPos = (Point2D)point2D.clone();
            return;
        }
        if (n < 0 || n > this.glyphs.length - 1) {
            throw new IndexOutOfBoundsException("glyphIndex: " + n + ", is out of bounds. Should be between 0 and " + (this.glyphs.length - 1) + ".");
        }
        this.glyphs[n].setPosition(point2D);
        this.glyphLogicalBounds[n] = null;
        this.outline = null;
        this.bounds2D = null;
        this.logicalBounds = null;
    }

    public void setGlyphTransform(int n, AffineTransform affineTransform) {
        if (n < 0 || n > this.glyphs.length - 1) {
            throw new IndexOutOfBoundsException("glyphIndex: " + n + ", is out of bounds. Should be between 0 and " + (this.glyphs.length - 1) + ".");
        }
        this.glyphs[n].setTransform(affineTransform);
        this.glyphLogicalBounds[n] = null;
        this.outline = null;
        this.bounds2D = null;
        this.logicalBounds = null;
    }

    public void setGlyphVisible(int n, boolean bl) {
        if (bl == this.glyphVisible[n]) {
            return;
        }
        this.glyphVisible[n] = bl;
        this.outline = null;
        this.bounds2D = null;
        this.logicalBounds = null;
        this.glyphLogicalBounds[n] = null;
    }

    public boolean isGlyphVisible(int n) {
        return this.glyphVisible[n];
    }

    public int getCharacterCount(int n, int n2) {
        int n3 = 0;
        if (n < 0) {
            n = 0;
        }
        if (n2 > this.glyphs.length - 1) {
            n2 = this.glyphs.length - 1;
        }
        for (int i = n; i <= n2; ++i) {
            Glyph glyph = this.glyphs[i];
            if (glyph.getGlyphCode() == -1) {
                ++n3;
                continue;
            }
            String string = glyph.getUnicode();
            n3 += string.length();
        }
        return n3;
    }

    public void draw(Graphics2D graphics2D, AttributedCharacterIterator attributedCharacterIterator) {
        for (int i = 0; i < this.glyphs.length; ++i) {
            if (!this.glyphVisible[i]) continue;
            this.glyphs[i].draw(graphics2D);
        }
    }
}

