/*
 * Decompiled with CFR 0.152.
 */
package org.apache.excalibur.altrmi.server;

import org.apache.excalibur.altrmi.server.PublicationException;

public final class PublicationDescription {
    private final Class[] m_interfacesToExpose;
    private final Class[] m_additionalFacades;

    public PublicationDescription(Class interfaceToExpose) {
        this.m_interfacesToExpose = new Class[]{interfaceToExpose};
        this.m_additionalFacades = new Class[0];
    }

    public PublicationDescription(Class interfaceToExpose, Class additionalFacade) {
        this.m_interfacesToExpose = new Class[]{interfaceToExpose};
        this.m_additionalFacades = new Class[]{additionalFacade};
    }

    public PublicationDescription(Class interfaceToExpose, Class[] additionalFacades) {
        this.m_interfacesToExpose = new Class[]{interfaceToExpose};
        this.m_additionalFacades = additionalFacades;
    }

    public PublicationDescription(Class[] interfacesToExpose) {
        this.m_interfacesToExpose = interfacesToExpose;
        this.m_additionalFacades = new Class[0];
    }

    public PublicationDescription(Class[] interfacesToExpose, Class[] additionalFacades) {
        this.m_interfacesToExpose = interfacesToExpose;
        this.m_additionalFacades = additionalFacades;
    }

    public PublicationDescription(String interfaceToExpose, ClassLoader classLoader) throws PublicationException {
        this.m_interfacesToExpose = PublicationDescription.makeClasses(new String[]{interfaceToExpose}, classLoader);
        this.m_additionalFacades = new Class[0];
    }

    public PublicationDescription(String interfaceToExpose, String additionalFacade, ClassLoader classLoader) throws PublicationException {
        this.m_interfacesToExpose = PublicationDescription.makeClasses(new String[]{interfaceToExpose}, classLoader);
        this.m_additionalFacades = PublicationDescription.makeClasses(new String[]{additionalFacade}, classLoader);
    }

    public PublicationDescription(String interfaceToExpose, String[] additionalFacades, ClassLoader classLoader) throws PublicationException {
        this.m_interfacesToExpose = PublicationDescription.makeClasses(new String[]{interfaceToExpose}, classLoader);
        this.m_additionalFacades = PublicationDescription.makeClasses(additionalFacades, classLoader);
    }

    public PublicationDescription(String[] interfacesToExpose, ClassLoader classLoader) throws PublicationException {
        this.m_interfacesToExpose = PublicationDescription.makeClasses(interfacesToExpose, classLoader);
        this.m_additionalFacades = new Class[0];
    }

    public PublicationDescription(String[] interfacesToExpose, String[] additionalFacades, ClassLoader classLoader) throws PublicationException {
        this.m_interfacesToExpose = PublicationDescription.makeClasses(interfacesToExpose, classLoader);
        this.m_additionalFacades = PublicationDescription.makeClasses(additionalFacades, classLoader);
    }

    private static Class[] makeClasses(String[] classNames, ClassLoader classLoader) throws PublicationException {
        try {
            Class[] classes = new Class[classNames.length];
            int i = 0;
            while (i < classNames.length) {
                String clsNam = classNames[i];
                classes[i] = classLoader.loadClass(clsNam);
                ++i;
            }
            return classes;
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
            throw new PublicationException("Class not found during publication:" + e.getMessage() + " " + e.getException().getMessage());
        }
    }

    public Class[] getInterfacesToExpose() {
        return this.m_interfacesToExpose;
    }

    public Class[] getAdditionalFacades() {
        return this.m_additionalFacades;
    }

    public Class getMostDerivedType(Object beanImpl) {
        Class facadeRetVal = null;
        int i = 0;
        while (i < this.m_additionalFacades.length) {
            Class facade = this.m_additionalFacades[i];
            if (facade.isAssignableFrom(beanImpl.getClass())) {
                if (facadeRetVal == null) {
                    facadeRetVal = facade;
                } else if (facadeRetVal.isAssignableFrom(facade)) {
                    facadeRetVal = facade;
                }
            }
            ++i;
        }
        return facadeRetVal;
    }
}

