/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.parsers;

import java.io.StringReader;
import org.apache.xerces.dom3.DOMErrorHandler;
import org.apache.xerces.dom3.ls.DOMBuilder;
import org.apache.xerces.dom3.ls.DOMBuilderFilter;
import org.apache.xerces.dom3.ls.DOMEntityResolver;
import org.apache.xerces.dom3.ls.DOMInputSource;
import org.apache.xerces.parsers.AbstractDOMParser;
import org.apache.xerces.parsers.DTDXSParserConfiguration;
import org.apache.xerces.util.DOMEntityResolverWrapper;
import org.apache.xerces.util.DOMErrorHandlerWrapper;
import org.apache.xerces.util.SymbolTable;
import org.apache.xerces.xni.XNIException;
import org.apache.xerces.xni.grammars.XMLGrammarPool;
import org.apache.xerces.xni.parser.XMLConfigurationException;
import org.apache.xerces.xni.parser.XMLInputSource;
import org.apache.xerces.xni.parser.XMLParserConfiguration;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class DOMBuilderImpl
extends AbstractDOMParser
implements DOMBuilder {
    protected static final String NAMESPACE_DECLARATIONS = "namespace-declarations";
    protected static final String VALIDATION = "validation";
    protected static final String EXTERNAL_PARAMETER_ENTITIES = "external-parameter-entities";
    protected static final String EXTERNAL_GENERAL_ENTITIES = "external-general-entities";
    protected static final String EXTERNAL_DTD_SUBSET = "external-dtd-subset";
    protected static final String VALIDATE_IF_SCHEMA = "validate-if-schema";
    protected static final String VALIDATE_AGAINST_DTD = "validate-against-dtd";
    protected static final String DATATYPE_NORMALIZATION = "datatype-normalization";
    protected static final String CREATE_ENTITY_REFERENCE_NODES = "create-entity-ref-nodes";
    protected static final String CREATE_ENTITY_NODES = "create-entity-nodes";
    protected static final String WHITESPACE_IN_ELEMENT_CONTENT = "whitespace-in-element-content";
    protected static final String COMMENTS = "comments";
    protected static final String CHARSET_OVERRIDES_XML_ENCODING = "charset-overrides-xml-encoding";
    protected static final String LOAD_AS_INFOSET = "load-as-infoset";
    protected static final String SUPPORTED_MEDIATYPES_ONLY = "supported-mediatypes-only";
    protected static final String VALIDATION_FEATURE = "http://xml.org/sax/features/validation";
    protected static final String EXTERNAL_PARAMETER_ENTITIES_FEATURE = "http://xml.org/sax/features/external-parameter-entities";
    protected static final String EXTERNAL_GENERAL_ENTITIES_FEATURE = "http://xml.org/sax/features/external-general-entities";
    protected static final String LOAD_EXTERNAL_DTD_FEATURE = "http://apache.org/xml/features/nonvalidating/load-external-dtd";
    protected static final String XMLSCHEMA = "http://apache.org/xml/features/validation/schema";
    protected static final String DYNAMIC_VALIDATION = "http://apache.org/xml/features/validation/dynamic";

    public DOMBuilderImpl() {
        this(new DTDXSParserConfiguration());
    }

    public DOMBuilderImpl(XMLParserConfiguration xMLParserConfiguration) {
        super(xMLParserConfiguration);
        String[] stringArray = new String[]{NAMESPACE_DECLARATIONS, VALIDATE_IF_SCHEMA, VALIDATE_AGAINST_DTD, DATATYPE_NORMALIZATION, CREATE_ENTITY_NODES, WHITESPACE_IN_ELEMENT_CONTENT, CHARSET_OVERRIDES_XML_ENCODING, LOAD_AS_INFOSET, SUPPORTED_MEDIATYPES_ONLY};
        this.fConfiguration.addRecognizedFeatures(stringArray);
        this.fConfiguration.setFeature(NAMESPACE_DECLARATIONS, true);
        this.fConfiguration.setFeature(VALIDATE_IF_SCHEMA, false);
        this.fConfiguration.setFeature(VALIDATE_AGAINST_DTD, false);
        this.fConfiguration.setFeature(CREATE_ENTITY_NODES, true);
        this.fConfiguration.setFeature(WHITESPACE_IN_ELEMENT_CONTENT, true);
        this.fConfiguration.setFeature(CHARSET_OVERRIDES_XML_ENCODING, true);
        this.fConfiguration.setFeature(LOAD_AS_INFOSET, false);
        this.fConfiguration.setFeature(SUPPORTED_MEDIATYPES_ONLY, false);
        this.fConfiguration.setFeature("http://apache.org/xml/features/validation/schema/normalized-value", false);
    }

    public DOMBuilderImpl(SymbolTable symbolTable) {
        this(new DTDXSParserConfiguration(symbolTable));
    }

    public DOMBuilderImpl(SymbolTable symbolTable, XMLGrammarPool xMLGrammarPool) {
        this(new DTDXSParserConfiguration(symbolTable, xMLGrammarPool));
    }

    public void reset() {
        super.reset();
    }

    public DOMEntityResolver getEntityResolver() {
        DOMEntityResolver dOMEntityResolver = null;
        try {
            DOMEntityResolver dOMEntityResolver2 = (DOMEntityResolver)this.fConfiguration.getProperty("http://apache.org/xml/properties/internal/entity-resolver");
            if (dOMEntityResolver2 != null && dOMEntityResolver2 instanceof DOMEntityResolverWrapper) {
                dOMEntityResolver = ((DOMEntityResolverWrapper)((Object)dOMEntityResolver2)).getEntityResolver();
            }
        }
        catch (XMLConfigurationException xMLConfigurationException) {
            // empty catch block
        }
        return dOMEntityResolver;
    }

    public void setEntityResolver(DOMEntityResolver dOMEntityResolver) {
        try {
            this.fConfiguration.setProperty("http://apache.org/xml/properties/internal/entity-resolver", new DOMEntityResolverWrapper(dOMEntityResolver));
        }
        catch (XMLConfigurationException xMLConfigurationException) {
            // empty catch block
        }
    }

    public DOMErrorHandler getErrorHandler() {
        DOMErrorHandler dOMErrorHandler = null;
        try {
            DOMErrorHandler dOMErrorHandler2 = (DOMErrorHandler)this.fConfiguration.getProperty("http://apache.org/xml/properties/internal/error-handler");
            if (dOMErrorHandler2 != null && dOMErrorHandler2 instanceof DOMErrorHandlerWrapper) {
                dOMErrorHandler = ((DOMErrorHandlerWrapper)dOMErrorHandler2).getErrorHandler();
            }
        }
        catch (XMLConfigurationException xMLConfigurationException) {
            // empty catch block
        }
        return dOMErrorHandler;
    }

    public void setErrorHandler(DOMErrorHandler dOMErrorHandler) {
        try {
            this.fConfiguration.setProperty("http://apache.org/xml/properties/internal/error-handler", new DOMErrorHandlerWrapper(dOMErrorHandler));
        }
        catch (XMLConfigurationException xMLConfigurationException) {
            // empty catch block
        }
    }

    public DOMBuilderFilter getFilter() {
        throw new DOMException(9, "Not supported");
    }

    public void setFilter(DOMBuilderFilter dOMBuilderFilter) {
        throw new DOMException(9, "Not supported");
    }

    public void setFeature(String string, boolean bl) throws DOMException {
        block22: {
            try {
                if (this.canSetFeature(string, bl)) {
                    if (string.equals(VALIDATION)) {
                        this.fConfiguration.setFeature(VALIDATION_FEATURE, bl);
                    } else if (string.equals(VALIDATE_IF_SCHEMA)) {
                        this.fConfiguration.setFeature(DYNAMIC_VALIDATION, bl);
                        this.fConfiguration.setFeature(XMLSCHEMA, bl);
                    } else if (string.equals(WHITESPACE_IN_ELEMENT_CONTENT)) {
                        this.fConfiguration.setFeature("http://apache.org/xml/features/dom/include-ignorable-whitespace", bl);
                    } else if (string.equals(DATATYPE_NORMALIZATION)) {
                        this.fConfiguration.setFeature("http://apache.org/xml/features/validation/schema/normalized-value", bl);
                    } else if (string.equals(EXTERNAL_PARAMETER_ENTITIES)) {
                        this.fConfiguration.setFeature(EXTERNAL_PARAMETER_ENTITIES_FEATURE, bl);
                    } else if (string.equals(EXTERNAL_GENERAL_ENTITIES)) {
                        this.fConfiguration.setFeature(EXTERNAL_GENERAL_ENTITIES_FEATURE, bl);
                    } else if (string.equals(EXTERNAL_DTD_SUBSET)) {
                        this.fConfiguration.setFeature(LOAD_EXTERNAL_DTD_FEATURE, bl);
                    } else if (string.equals(COMMENTS)) {
                        this.fConfiguration.setFeature("include-comments", bl);
                    } else if (string.equals(CREATE_ENTITY_REFERENCE_NODES)) {
                        this.fConfiguration.setFeature("http://apache.org/xml/features/dom/create-entity-ref-nodes", bl);
                    } else {
                        this.fConfiguration.setFeature(string, bl);
                    }
                    break block22;
                }
                throw new DOMException(9, "Feature \"" + string + "\" cannot be set to \"" + bl + "\"");
            }
            catch (XMLConfigurationException xMLConfigurationException) {
                if (xMLConfigurationException.getType() == 0) {
                    throw new DOMException(8, "Feature \"" + string + "\" not recognized");
                }
                throw new DOMException(9, "Feature \"" + string + "\" not supported");
            }
        }
    }

    public boolean canSetFeature(String string, boolean bl) {
        if (string.equals(NAMESPACE_DECLARATIONS) && !bl) {
            return false;
        }
        if (string.equals(VALIDATE_AGAINST_DTD) && bl) {
            return false;
        }
        if (string.equals(CREATE_ENTITY_NODES) && !bl) {
            return false;
        }
        if (string.equals(LOAD_AS_INFOSET) && bl) {
            return false;
        }
        return !string.equals(SUPPORTED_MEDIATYPES_ONLY) || !bl;
    }

    public boolean getFeature(String string) throws DOMException {
        try {
            if (string.equals(VALIDATION)) {
                return this.fConfiguration.getFeature(VALIDATION_FEATURE);
            }
            if (string.equals(EXTERNAL_PARAMETER_ENTITIES)) {
                return this.fConfiguration.getFeature(EXTERNAL_PARAMETER_ENTITIES_FEATURE);
            }
            if (string.equals(EXTERNAL_GENERAL_ENTITIES)) {
                return this.fConfiguration.getFeature(EXTERNAL_GENERAL_ENTITIES_FEATURE);
            }
            if (string.equals(EXTERNAL_DTD_SUBSET)) {
                return this.fConfiguration.getFeature(LOAD_EXTERNAL_DTD_FEATURE);
            }
            if (string.equals(COMMENTS)) {
                return this.fConfiguration.getFeature("include-comments");
            }
            if (string.equals(CREATE_ENTITY_REFERENCE_NODES)) {
                return this.fConfiguration.getFeature("http://apache.org/xml/features/dom/create-entity-ref-nodes");
            }
            if (string.equals(VALIDATE_IF_SCHEMA)) {
                return this.fConfiguration.getFeature(DYNAMIC_VALIDATION);
            }
            if (string.equals(WHITESPACE_IN_ELEMENT_CONTENT)) {
                return this.fConfiguration.getFeature("http://apache.org/xml/features/dom/include-ignorable-whitespace");
            }
            if (string.equals(DATATYPE_NORMALIZATION)) {
                return this.fConfiguration.getFeature("http://apache.org/xml/features/validation/schema/normalized-value");
            }
            return this.fConfiguration.getFeature(string);
        }
        catch (XMLConfigurationException xMLConfigurationException) {
            if (xMLConfigurationException.getType() == 0) {
                throw new DOMException(8, "Feature \"" + string + "\" not recognized");
            }
            throw new DOMException(9, "Feature \"" + string + "\" not supported");
        }
    }

    public Document parseURI(String string) throws Exception {
        XMLInputSource xMLInputSource = new XMLInputSource(null, string, null);
        try {
            this.parse(xMLInputSource);
        }
        catch (XNIException xNIException) {
            Exception exception = xNIException.getException();
            throw exception;
        }
        return this.getDocument();
    }

    public Document parse(DOMInputSource dOMInputSource) throws Exception {
        try {
            XMLInputSource xMLInputSource = this.dom2xmlInputSource(dOMInputSource);
            this.parse(xMLInputSource);
        }
        catch (XNIException xNIException) {
            Exception exception = xNIException.getException();
            throw exception;
        }
        return this.getDocument();
    }

    public void parseWithContext(DOMInputSource dOMInputSource, Node node, short s) throws DOMException {
        throw new DOMException(9, "Not supported");
    }

    XMLInputSource dom2xmlInputSource(DOMInputSource dOMInputSource) {
        XMLInputSource xMLInputSource = null;
        xMLInputSource = dOMInputSource.getStringData() != null ? new XMLInputSource(dOMInputSource.getPublicId(), dOMInputSource.getSystemId(), dOMInputSource.getBaseURI(), new StringReader(dOMInputSource.getStringData()), "UTF-16") : (dOMInputSource.getCharacterStream() != null ? new XMLInputSource(dOMInputSource.getPublicId(), dOMInputSource.getSystemId(), dOMInputSource.getBaseURI(), dOMInputSource.getCharacterStream(), "UTF-16") : (dOMInputSource.getByteStream() != null ? new XMLInputSource(dOMInputSource.getPublicId(), dOMInputSource.getSystemId(), dOMInputSource.getBaseURI(), dOMInputSource.getByteStream(), dOMInputSource.getEncoding()) : new XMLInputSource(dOMInputSource.getPublicId(), dOMInputSource.getSystemId(), dOMInputSource.getBaseURI())));
        return xMLInputSource;
    }
}

