/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.transformation;

import java.io.IOException;
import java.util.Map;
import java.util.StringTokenizer;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.environment.ObjectModelHelper;
import org.apache.cocoon.environment.Request;
import org.apache.cocoon.environment.SourceResolver;
import org.apache.cocoon.transformation.FilterTransformer;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class RoleFilterTransformer
extends FilterTransformer {
    private static final String URI = "http://apache.org/cocoon/role-filter/1.0";
    private static final String RESTRICT = "restricted";
    private static final String VIEW = "read-only";
    Request request = null;

    public final void setup(SourceResolver resolver, Map objectModel, String src, Parameters params) throws ProcessingException, SAXException, IOException {
        super.setup(resolver, objectModel, src, params);
        this.request = ObjectModelHelper.getRequest(objectModel);
    }

    public long generateKey() {
        return 0L;
    }

    public final void startElement(String uri, String loc, String raw, Attributes a) throws SAXException {
        StringTokenizer roles;
        int roleIndex = a.getIndex(URI, RESTRICT);
        int viewIndex = a.getIndex(URI, VIEW);
        boolean propogate = true;
        boolean readOnly = false;
        if (roleIndex >= 0) {
            String roleRestriction = a.getValue(roleIndex);
            roles = new StringTokenizer(roleRestriction, ",", false);
            propogate = false;
            while (!propogate && roles.hasMoreTokens()) {
                if (!this.request.isUserInRole(roles.nextToken())) continue;
                propogate = true;
            }
        }
        if (!propogate) {
            this.elementName = loc;
        } else if (viewIndex >= 0) {
            String viewRestriction = a.getValue(viewIndex);
            roles = new StringTokenizer(viewRestriction, ",", false);
            while (!readOnly && roles.hasMoreTokens()) {
                if (!this.request.isUserInRole(roles.nextToken())) continue;
                readOnly = true;
            }
        }
        super.startElement(uri, loc, raw, this.copyAttributes(a, roleIndex, viewIndex, readOnly));
    }

    public final void endElement(String uri, String loc, String raw) throws SAXException {
        super.endElement(uri, loc, raw);
        if (!this.skip) {
            this.elementName = "";
        }
    }

    private final Attributes copyAttributes(Attributes a, int role, int view, boolean readOnly) {
        if (role < 0 && view < 0) {
            return a;
        }
        AttributesImpl attr = new AttributesImpl();
        attr.setAttributes(a);
        if (role >= 0) {
            attr.removeAttribute(role);
        }
        if (view >= 0) {
            if (readOnly) {
                attr.setValue(view, "");
            } else {
                attr.removeAttribute(view);
            }
        }
        return attr;
    }

    public void recycle() {
        this.request = null;
    }
}

