/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.components.treeprocessor.sitemap;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.avalon.framework.component.ComponentException;
import org.apache.avalon.framework.component.ComponentManager;
import org.apache.avalon.framework.component.Composable;
import org.apache.cocoon.components.treeprocessor.AbstractProcessingNode;
import org.apache.cocoon.components.treeprocessor.InvokeContext;
import org.apache.cocoon.components.treeprocessor.TreeProcessor;
import org.apache.cocoon.components.treeprocessor.variables.VariableResolver;
import org.apache.cocoon.environment.Environment;

public class MountNode
extends AbstractProcessingNode
implements Composable {
    private VariableResolver prefix;
    private VariableResolver source;
    private Map processors = new HashMap();
    private TreeProcessor parentProcessor;
    private String language;
    private ComponentManager manager;

    public MountNode(VariableResolver prefix, VariableResolver source, String language, TreeProcessor parentProcessor) {
        this.prefix = prefix;
        this.source = source;
        this.language = language;
        this.parentProcessor = parentProcessor;
    }

    public void compose(ComponentManager manager) throws ComponentException {
        this.manager = manager;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final boolean invoke(Environment env, InvokeContext context) throws Exception {
        boolean bl;
        String oldURI;
        String oldPrefix;
        block5: {
            boolean bl2;
            block4: {
                List mapStack = context.getMapStack();
                Map objectModel = env.getObjectModel();
                String resolvedSource = this.source.resolve(context, objectModel);
                TreeProcessor processor = (TreeProcessor)this.processors.get(resolvedSource);
                if (processor == null) {
                    processor = this.getProcessor(env, resolvedSource);
                }
                String resolvedPrefix = this.prefix.resolve(context, objectModel);
                oldPrefix = env.getURIPrefix();
                oldURI = env.getURI();
                try {
                    env.changeContext(resolvedPrefix, resolvedSource);
                    if (context.isInternalRequest()) {
                        bl2 = processor.process(env, context.getStreamPipeline(), context.getEventPipeline());
                        Object var12_12 = null;
                        env.setContext(oldPrefix, oldURI);
                        break block4;
                    }
                    bl = processor.process(env);
                    break block5;
                }
                catch (Throwable throwable) {
                    Object var12_14 = null;
                    env.setContext(oldPrefix, oldURI);
                    context.recompose(this.manager);
                    throw throwable;
                }
            }
            context.recompose(this.manager);
            return bl2;
        }
        Object var12_13 = null;
        env.setContext(oldPrefix, oldURI);
        context.recompose(this.manager);
        return bl;
    }

    private synchronized TreeProcessor getProcessor(Environment env, String source) throws Exception {
        TreeProcessor processor = (TreeProcessor)this.processors.get(source);
        if (processor == null) {
            String actualSource = source.charAt(source.length() - 1) == '/' ? source + "sitemap.xmap" : source;
            processor = this.parentProcessor.createChildProcessor(this.manager, this.language, env.resolve(actualSource));
            this.processors.put(source, processor);
        }
        return processor;
    }

    public void dispose() {
        Iterator iter = this.processors.values().iterator();
        while (iter.hasNext()) {
            ((TreeProcessor)iter.next()).dispose();
        }
    }
}

