/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.components.treeprocessor.sitemap;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import org.apache.avalon.framework.CascadingRuntimeException;
import org.apache.avalon.framework.component.ComponentException;
import org.apache.avalon.framework.component.ComponentSelector;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.configuration.DefaultConfiguration;
import org.apache.cocoon.components.ExtendedComponentSelector;
import org.apache.cocoon.components.pipeline.OutputComponentSelector;
import org.apache.cocoon.sitemap.SitemapComponentSelector;

public class ComponentsSelector
extends ExtendedComponentSelector
implements OutputComponentSelector,
SitemapComponentSelector {
    public static final int UNKNOWN = -1;
    public static final int GENERATOR = 0;
    public static final int TRANSFORMER = 1;
    public static final int SERIALIZER = 2;
    public static final int READER = 3;
    public static final int MATCHER = 4;
    public static final int SELECTOR = 5;
    public static final int ACTION = 6;
    public static final String[] SELECTOR_ROLES = new String[]{"org.apache.cocoon.generation.GeneratorSelector", "org.apache.cocoon.transformation.TransformerSelector", "org.apache.cocoon.serialization.SerializerSelector", "org.apache.cocoon.reading.ReaderSelector", "org.apache.cocoon.matching.MatcherSelector", "org.apache.cocoon.selection.SelectorSelector", "org.apache.cocoon.acting.ActionSelector"};
    public static final String[] COMPONENT_NAMES = new String[]{"generator", "transformer", "serializer", "reader", "matcher", "selector", "action"};
    private int roleId;
    private Map hintMimeTypes;
    private Map hintLabels;
    private Set knownHints = new HashSet();
    private SitemapComponentSelector parentSitemapSelector;
    static /* synthetic */ Class class$org$apache$cocoon$sitemap$NotifyingGenerator;
    static /* synthetic */ Class class$org$apache$cocoon$sitemap$ContentAggregator;
    static /* synthetic */ Class class$org$apache$cocoon$sitemap$LinkTranslator;

    public void setParentSelector(ComponentSelector selector) {
        super.setParentSelector(selector);
        if (selector instanceof SitemapComponentSelector) {
            this.parentSitemapSelector = (SitemapComponentSelector)selector;
        }
    }

    protected String getComponentInstanceName() {
        return this.roleId == -1 ? null : COMPONENT_NAMES[this.roleId];
    }

    protected String getClassAttributeName() {
        return this.roleId == -1 ? "class" : "src";
    }

    public void configure(Configuration config2) throws ConfigurationException {
        String role = this.getRoleName(config2);
        this.roleId = -1;
        int i = 0;
        while (i < SELECTOR_ROLES.length) {
            if (SELECTOR_ROLES[i].equals(role)) {
                this.roleId = i;
                break;
            }
            ++i;
        }
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("Setting up sitemap component selector for " + role + " (role id = " + this.roleId + ")");
        }
        if (this.roleId == 2 || this.roleId == 3) {
            this.hintMimeTypes = new HashMap();
        }
        this.hintLabels = new HashMap();
        super.configure(config2);
    }

    public void addComponent(Object hint, Class clazz, Configuration config2) throws ComponentException {
        String label;
        String mimeType;
        super.addComponent(hint, clazz, config2);
        this.knownHints.add(hint);
        if ((this.roleId == 2 || this.roleId == 3) && (mimeType = config2.getAttribute("mime-type", null)) != null) {
            this.hintMimeTypes.put(hint, mimeType);
        }
        if ((label = config2.getAttribute("label", null)) != null) {
            StringTokenizer st = new StringTokenizer(label, " ,", false);
            String[] labels = new String[st.countTokens()];
            int i = 0;
            while (i < labels.length) {
                labels[i] = st.nextToken();
                ++i;
            }
            this.hintLabels.put(hint, labels);
        }
    }

    public void initialize() {
        try {
            DefaultConfiguration config2 = null;
            switch (this.roleId) {
                case 0: {
                    config2 = new DefaultConfiguration(COMPONENT_NAMES[0], "autogenerated");
                    config2.setAttribute("name", "<notifier>");
                    this.ensureExists("<notifier>", class$org$apache$cocoon$sitemap$NotifyingGenerator == null ? (class$org$apache$cocoon$sitemap$NotifyingGenerator = ComponentsSelector.class$("org.apache.cocoon.sitemap.NotifyingGenerator")) : class$org$apache$cocoon$sitemap$NotifyingGenerator, (Configuration)config2);
                    config2 = new DefaultConfiguration(COMPONENT_NAMES[0], "autogenerated");
                    config2.setAttribute("name", "<aggregator>");
                    this.ensureExists("<aggregator>", class$org$apache$cocoon$sitemap$ContentAggregator == null ? (class$org$apache$cocoon$sitemap$ContentAggregator = ComponentsSelector.class$("org.apache.cocoon.sitemap.ContentAggregator")) : class$org$apache$cocoon$sitemap$ContentAggregator, (Configuration)config2);
                    break;
                }
                case 1: {
                    config2 = new DefaultConfiguration(COMPONENT_NAMES[1], "autogenerated");
                    config2.setAttribute("name", "<translator>");
                    this.ensureExists("<translator>", class$org$apache$cocoon$sitemap$LinkTranslator == null ? (class$org$apache$cocoon$sitemap$LinkTranslator = ComponentsSelector.class$("org.apache.cocoon.sitemap.LinkTranslator")) : class$org$apache$cocoon$sitemap$LinkTranslator, (Configuration)config2);
                }
            }
            super.initialize();
            this.knownHints = null;
        }
        catch (Exception e) {
            throw new CascadingRuntimeException("Cannot setup default components", (Throwable)e);
        }
    }

    private void ensureExists(Object hint, Class clazz, Configuration config2) throws ComponentException {
        if (!this.knownHints.contains(hint)) {
            this.addComponent(hint, clazz, config2);
        }
    }

    public String getMimeTypeForHint(Object hint) {
        if (this.hintMimeTypes == null) {
            return null;
        }
        String mimeType = (String)this.hintMimeTypes.get(hint);
        if (mimeType != null) {
            return mimeType;
        }
        if (this.parentSitemapSelector != null) {
            return this.parentSitemapSelector.getMimeTypeForHint(hint);
        }
        return null;
    }

    public boolean hasLabel(Object hint, String label) {
        String[] labels = (String[])this.hintLabels.get(hint);
        if (labels != null) {
            int i = 0;
            while (i < labels.length) {
                if (labels[i].equals(label)) {
                    return true;
                }
                ++i;
            }
        } else if (this.parentSitemapSelector != null) {
            return this.parentSitemapSelector.hasLabel(hint, label);
        }
        return false;
    }

    public String[] getLabels(Object hint) {
        String[] labels = (String[])this.hintLabels.get(hint);
        if (labels == null && this.parentSitemapSelector != null) {
            return this.parentSitemapSelector.getLabels(hint);
        }
        return labels;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

