/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.components.treeprocessor.sitemap;

import java.util.Map;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.cocoon.components.pipeline.EventPipeline;
import org.apache.cocoon.components.treeprocessor.AbstractProcessingNode;
import org.apache.cocoon.components.treeprocessor.InvokeContext;
import org.apache.cocoon.components.treeprocessor.ProcessingNode;
import org.apache.cocoon.components.treeprocessor.variables.VariableResolver;
import org.apache.cocoon.environment.Environment;
import org.apache.cocoon.sitemap.ContentAggregator;
import org.apache.cocoon.sitemap.PatternException;

public class AggregateNode
extends AbstractProcessingNode {
    private VariableResolver element;
    private VariableResolver nsURI;
    private VariableResolver nsPrefix;
    private Part[] allParts;
    private Map viewParts;
    private Map viewNodes;

    public AggregateNode(VariableResolver element, VariableResolver nsURI, VariableResolver nsPrefix) throws PatternException {
        this.element = element;
        this.nsURI = nsURI;
        this.nsPrefix = nsPrefix;
    }

    public void setParts(Part[] allParts, Map viewParts) {
        this.allParts = allParts;
        this.viewParts = viewParts;
    }

    public void setViewNodes(Map viewNodes) {
        this.viewNodes = viewNodes;
    }

    public boolean invoke(Environment env, InvokeContext context) throws Exception {
        ProcessingNode viewNode;
        Part[] actualParts;
        boolean infoEnabled = this.getLogger().isInfoEnabled();
        Map objectModel = env.getObjectModel();
        EventPipeline eventPipeline = context.getEventPipeline();
        eventPipeline.setGenerator("<aggregator>", null, Parameters.EMPTY_PARAMETERS);
        ContentAggregator aggregator = (ContentAggregator)eventPipeline.getGenerator();
        aggregator.setRootElement(this.element.resolve(context, objectModel), this.nsURI.resolve(context, objectModel), this.nsPrefix.resolve(context, objectModel));
        String cocoonView = env.getView();
        if (cocoonView == null) {
            actualParts = this.allParts;
        } else {
            actualParts = (Part[])this.viewParts.get(cocoonView);
            if (actualParts == null) {
                actualParts = this.allParts;
            }
        }
        int i = 0;
        while (i < actualParts.length) {
            Part part = actualParts[i];
            if (part != null) {
                aggregator.addPart(part.source.resolve(context, objectModel), part.element.resolve(context, objectModel), part.nsURI.resolve(context, objectModel), part.stripRoot.resolve(context, objectModel), part.nsPrefix.resolve(context, objectModel));
            }
            ++i;
        }
        if (actualParts != this.allParts && (viewNode = (ProcessingNode)this.viewNodes.get(cocoonView)) != null) {
            if (infoEnabled) {
                this.getLogger().info("Jumping to view '" + cocoonView + "' from aggregate part at " + this.getLocation());
            }
            return viewNode.invoke(env, context);
        }
        if (cocoonView != null && this.viewNodes != null && (viewNode = (ProcessingNode)this.viewNodes.get(cocoonView)) != null) {
            if (infoEnabled) {
                this.getLogger().info("Jumping to view '" + cocoonView + "' from aggregate at " + this.getLocation());
            }
            return viewNode.invoke(env, context);
        }
        return false;
    }

    public static class Part {
        private VariableResolver source;
        private VariableResolver element;
        private VariableResolver nsURI;
        private VariableResolver nsPrefix;
        private VariableResolver stripRoot;

        public Part(VariableResolver source, VariableResolver element, VariableResolver nsURI, VariableResolver nsPrefix, VariableResolver stripRoot) throws PatternException {
            this.source = source;
            this.element = element;
            this.nsURI = nsURI;
            this.nsPrefix = nsPrefix;
            this.stripRoot = stripRoot;
        }
    }
}

