/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.components.profiler;

import java.io.IOException;
import java.util.Map;
import org.apache.avalon.excalibur.pool.Recyclable;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.components.profiler.ProfilerData;
import org.apache.cocoon.components.saxconnector.SAXConnector;
import org.apache.cocoon.environment.SourceResolver;
import org.apache.cocoon.xml.AbstractXMLPipe;
import org.apache.cocoon.xml.XMLConsumer;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class ProfilingSAXConnector
extends AbstractXMLPipe
implements Recyclable,
SAXConnector {
    private ProfilerData data;
    private int index;
    private long time;
    private long total;

    public void setup(SourceResolver resolver, Map objectModel, String src, Parameters params) throws ProcessingException, SAXException, IOException {
        this.data = (ProfilerData)objectModel.get("profiler");
    }

    public void recycle() {
        this.data = null;
        this.total = 0L;
        this.time = 0L;
        this.index = -1;
        super.recycle();
    }

    public void setConsumer(XMLConsumer consumer) {
        super.setConsumer(consumer);
        this.index = this.data != null ? this.data.indexOf(consumer) : -1;
    }

    public void startDocument() throws SAXException {
        this.time = System.currentTimeMillis();
        super.startDocument();
        this.total += System.currentTimeMillis() - this.time;
    }

    public void endDocument() throws SAXException {
        this.time = System.currentTimeMillis();
        super.endDocument();
        this.total += System.currentTimeMillis() - this.time;
        if (this.index != -1) {
            this.data.setTime(this.index, this.total);
        }
    }

    public void startPrefixMapping(String prefix, String uri) throws SAXException {
        this.time = System.currentTimeMillis();
        super.startPrefixMapping(prefix, uri);
        this.total += System.currentTimeMillis() - this.time;
    }

    public void endPrefixMapping(String prefix) throws SAXException {
        this.time = System.currentTimeMillis();
        super.endPrefixMapping(prefix);
        this.total += System.currentTimeMillis() - this.time;
    }

    public void startElement(String uri, String loc, String raw, Attributes a) throws SAXException {
        this.time = System.currentTimeMillis();
        super.startElement(uri, loc, raw, a);
        this.total += System.currentTimeMillis() - this.time;
    }

    public void endElement(String uri, String loc, String raw) throws SAXException {
        this.time = System.currentTimeMillis();
        super.endElement(uri, loc, raw);
        this.total += System.currentTimeMillis() - this.time;
    }

    public void characters(char[] c, int start, int len) throws SAXException {
        this.time = System.currentTimeMillis();
        super.characters(c, start, len);
        this.total += System.currentTimeMillis() - this.time;
    }

    public void ignorableWhitespace(char[] c, int start, int len) throws SAXException {
        this.time = System.currentTimeMillis();
        super.ignorableWhitespace(c, start, len);
        this.total += System.currentTimeMillis() - this.time;
    }

    public void processingInstruction(String target, String data) throws SAXException {
        this.time = System.currentTimeMillis();
        super.processingInstruction(target, data);
        this.total += System.currentTimeMillis() - this.time;
    }

    public void skippedEntity(String name) throws SAXException {
        this.time = System.currentTimeMillis();
        super.skippedEntity(name);
        this.total += System.currentTimeMillis() - this.time;
    }

    public void startDTD(String name, String publicId, String systemId) throws SAXException {
        this.time = System.currentTimeMillis();
        super.startDTD(name, publicId, systemId);
        this.total += System.currentTimeMillis() - this.time;
    }

    public void endDTD() throws SAXException {
        this.time = System.currentTimeMillis();
        super.endDTD();
        this.total += System.currentTimeMillis() - this.time;
    }

    public void startEntity(String name) throws SAXException {
        this.time = System.currentTimeMillis();
        super.startEntity(name);
        this.total += System.currentTimeMillis() - this.time;
    }

    public void endEntity(String name) throws SAXException {
        this.time = System.currentTimeMillis();
        super.endEntity(name);
        this.total += System.currentTimeMillis() - this.time;
    }

    public void startCDATA() throws SAXException {
        this.time = System.currentTimeMillis();
        super.startCDATA();
        this.total += System.currentTimeMillis() - this.time;
    }

    public void endCDATA() throws SAXException {
        this.time = System.currentTimeMillis();
        super.endCDATA();
        this.total += System.currentTimeMillis() - this.time;
    }

    public void comment(char[] ch, int start, int len) throws SAXException {
        this.time = System.currentTimeMillis();
        super.comment(ch, start, len);
        this.total += System.currentTimeMillis() - this.time;
    }
}

