/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.components.language.markup.xsp;

import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import org.apache.cocoon.components.language.markup.xsp.EsqlConnection;

public class EsqlQuery {
    private static final int UPDATE_COUNT_UNSET = -2;
    private Connection connection = null;
    private Statement statement = null;
    private PreparedStatement preparedStatement = null;
    private ResultSet resultSet = null;
    private ResultSetMetaData resultSetMetaData = null;
    private int updateCount = -2;
    private int updateCountCount = 0;
    private int resultCount = 0;
    private boolean hasResultSet = false;
    private boolean resultSetValid = false;
    private int position = -1;
    private int maxRows = -1;
    private int skipRows = 0;
    private boolean keepgoing = true;
    private ArrayList groups = null;
    private int groupLevel = -1;
    private int changeLevel = -1;
    private String query;
    private int limitMethod;

    public EsqlQuery(EsqlConnection connection, String query) {
        this.connection = connection;
        this.limitMethod = connection.getLimitMethod();
        this.query = query;
    }

    public EsqlQuery(ResultSet aResultSet) {
        this.connection = null;
        this.statement = null;
        this.query = null;
        this.resultSetValid = true;
        this.resultSet = aResultSet;
        this.hasResultSet = this.resultSet != null;
    }

    public int getSkipRows() {
        return this.skipRows;
    }

    public void setSkipRows(int i) {
        this.skipRows = i;
    }

    public int getMaxRows() {
        return this.maxRows;
    }

    public void setMaxRows(int i) {
        this.maxRows = i;
    }

    public int getCurrentRow() {
        return this.position;
    }

    public String getQueryString() {
        switch (this.limitMethod) {
            case 1: {
                if (this.skipRows > 0) {
                    if (this.maxRows > -1) {
                        return this.query + " LIMIT " + this.maxRows + "," + this.skipRows;
                    }
                    return this.query + " OFFSET " + this.skipRows;
                }
                if (this.maxRows > -1) {
                    return this.query + " LIMIT " + this.maxRows;
                }
                return this.query;
            }
            case 2: {
                if (this.skipRows > 0) {
                    if (this.maxRows > -1) {
                        return this.query + " LIMIT " + this.skipRows + "," + this.maxRows;
                    }
                    throw new RuntimeException("MySQL does not support a skip of rows only");
                }
                if (this.maxRows > -1) {
                    return this.query + " LIMIT " + this.maxRows;
                }
                return this.query;
            }
        }
        return this.query;
    }

    public PreparedStatement prepareStatement() throws SQLException {
        switch (this.limitMethod) {
            case 1: 
            case 2: {
                this.preparedStatement = this.connection.prepareStatement(this.getQueryString());
                break;
            }
            case 3: {
                this.preparedStatement = this.connection.prepareStatement(this.getQueryString(), 1004, 1007);
                break;
            }
            default: {
                this.preparedStatement = this.connection.prepareStatement(this.getQueryString());
            }
        }
        this.statement = this.preparedStatement;
        return this.preparedStatement;
    }

    public CallableStatement prepareCall() throws SQLException {
        switch (this.limitMethod) {
            case 1: 
            case 2: {
                this.preparedStatement = this.connection.prepareCall(this.getQueryString());
                break;
            }
            case 3: {
                this.preparedStatement = this.connection.prepareCall(this.getQueryString(), 1004, 1007);
                break;
            }
            default: {
                this.preparedStatement = this.connection.prepareCall(this.getQueryString());
            }
        }
        this.statement = this.preparedStatement;
        return (CallableStatement)this.preparedStatement;
    }

    public PreparedStatement getPreparedStatement() {
        return this.preparedStatement;
    }

    public CallableStatement getCallableStatement() {
        return (CallableStatement)this.preparedStatement;
    }

    public ResultSet getResultSet() {
        return this.resultSet;
    }

    public boolean nextRow() throws SQLException {
        ++this.position;
        return this.resultSet.next();
    }

    public boolean keepGoing() {
        return this.keepgoing;
    }

    public void setKeepGoing(boolean still) {
        this.keepgoing = still;
    }

    public void groupLevelPlusPlus() {
        ++this.groupLevel;
    }

    public void groupLevelMinusMinus() {
        --this.groupLevel;
    }

    public boolean groupLevelExists() {
        return this.groups != null && this.groups.size() >= this.groupLevel + 1 && this.groups.get(this.groupLevel) != null;
    }

    public void setGroupingVar(String key) throws SQLException {
        if (this.groups == null) {
            this.groups = new ArrayList(1);
        }
        this.groups.ensureCapacity(this.groupLevel);
        this.groups.add(this.groupLevel, new EsqlGroup(key, this.getResultSet().getObject(key)));
    }

    public boolean hasGroupingVarChanged() throws SQLException {
        if (this.changeLevel != -1) {
            if (this.changeLevel < this.groupLevel) {
                return true;
            }
            this.changeLevel = -1;
            return true;
        }
        boolean result = false;
        int i = 0;
        while (i <= this.groupLevel) {
            Object tmp = this.getResultSet().getObject(((EsqlGroup)this.groups.get((int)i)).var);
            if (!tmp.equals(((EsqlGroup)this.groups.get((int)i)).value)) {
                ((EsqlGroup)this.groups.get((int)i)).value = tmp;
                result = true;
                if (this.changeLevel == -1 && this.groupLevel != i) {
                    this.changeLevel = i;
                }
            }
            ++i;
        }
        return result;
    }

    public ResultSetMetaData getResultSetMetaData() {
        return this.resultSetMetaData;
    }

    public Statement createStatement() throws SQLException {
        switch (this.limitMethod) {
            case 3: {
                this.statement = this.connection.createStatement(1004, 1007);
                break;
            }
            default: {
                this.statement = this.connection.createStatement();
            }
        }
        return this.statement;
    }

    public Statement getStatement() {
        return this.statement;
    }

    public int getUpdateCount() throws SQLException {
        return this.updateCount;
    }

    public int getUpdateCountCount() {
        return this.updateCountCount;
    }

    public int getResultCount() {
        return this.resultCount;
    }

    public boolean getMoreResults() throws SQLException {
        if (this.statement == null) {
            return false;
        }
        this.hasResultSet = this.statement.getMoreResults();
        this.resultSetValid = false;
        this.adjustCounts();
        return this.hasResultSet || this.updateCount > -1;
    }

    protected void adjustCounts() throws SQLException {
        this.updateCount = this.statement.getUpdateCount();
        if (this.hasResultSet) {
            ++this.resultCount;
        } else {
            ++this.updateCountCount;
        }
    }

    public boolean execute() throws SQLException {
        return this.execute(false);
    }

    public boolean execute(int resultSetFromObject) throws SQLException {
        this.hasResultSet = this.execute(false);
        this.resultSet = (ResultSet)((CallableStatement)this.preparedStatement).getObject(resultSetFromObject);
        this.resultSetValid = true;
        return this.hasResultSet;
    }

    public boolean execute(boolean needsQuery) throws SQLException {
        if (needsQuery) {
            this.resultSet = this.preparedStatement != null ? this.preparedStatement.executeQuery() : this.statement.executeQuery(this.getQueryString());
            this.hasResultSet = this.resultSet != null;
            this.resultSetValid = true;
        } else {
            this.hasResultSet = this.preparedStatement != null ? this.preparedStatement.execute() : this.statement.execute(this.getQueryString());
            this.resultSetValid = false;
        }
        this.adjustCounts();
        return this.hasResultSet;
    }

    public boolean hasResultSet() {
        return this.hasResultSet;
    }

    public int rowCount() throws SQLException {
        switch (this.limitMethod) {
            case 3: {
                ResultSet resultSet = this.resultSet;
                synchronized (resultSet) {
                    int currentRow = this.resultSet.getRow();
                    this.resultSet.last();
                    int count = this.resultSet.getRow();
                    if (currentRow > 0) {
                        this.resultSet.absolute(currentRow);
                    } else {
                        this.resultSet.first();
                        this.resultSet.relative(-1);
                    }
                    int n = count;
                    return n;
                }
            }
        }
        throw new RuntimeException("not yet implemented");
    }

    public void getResultRows() throws SQLException {
        if (!this.resultSetValid) {
            this.resultSet = this.statement.getResultSet();
        }
        this.resultSetMetaData = this.resultSet.getMetaData();
        this.position = 0;
        if (this.skipRows > 0) {
            block0 : switch (this.limitMethod) {
                case 1: {
                    this.position = this.skipRows;
                    break;
                }
                case 2: {
                    this.position = this.skipRows;
                    break;
                }
                case 3: {
                    this.resultSet.absolute(this.skipRows);
                    this.position = this.skipRows;
                    break;
                }
                default: {
                    while (this.resultSet.next()) {
                        ++this.position;
                        if (this.position == this.skipRows) break block0;
                    }
                    break block0;
                }
            }
        }
    }

    class EsqlGroup {
        public String var = null;
        public Object value = null;

        EsqlGroup(String var, Object value) {
            this.var = var;
            this.value = value;
        }
    }
}

