/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.components;

import org.apache.avalon.excalibur.component.RoleManageable;
import org.apache.avalon.excalibur.component.RoleManager;
import org.apache.avalon.excalibur.logger.LogKitManageable;
import org.apache.avalon.excalibur.logger.LogKitManager;
import org.apache.avalon.framework.activity.Disposable;
import org.apache.avalon.framework.activity.Initializable;
import org.apache.avalon.framework.activity.Startable;
import org.apache.avalon.framework.component.ComponentManager;
import org.apache.avalon.framework.component.Composable;
import org.apache.avalon.framework.configuration.Configurable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.context.Context;
import org.apache.avalon.framework.context.Contextualizable;
import org.apache.avalon.framework.logger.Loggable;
import org.apache.avalon.framework.parameters.Parameterizable;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.log.Logger;

public class LifecycleHelper {
    private Logger m_logger;
    private Context m_context;
    private ComponentManager m_componentManager;
    private Configuration m_configuration;
    private RoleManager m_roles;
    private LogKitManager m_logkit;

    public LifecycleHelper(Logger logger, Context context, ComponentManager componentManager, RoleManager roles, LogKitManager logkit, Configuration configuration) {
        this.m_logger = logger;
        this.m_context = context;
        this.m_componentManager = componentManager;
        this.m_roles = roles;
        this.m_logkit = logkit;
        this.m_configuration = configuration;
    }

    public Object setupComponent(Object component) throws Exception {
        return this.setupComponent(component, true);
    }

    public Object setupComponent(Object component, boolean initializeAndStart) throws Exception {
        return LifecycleHelper.setupComponent(component, this.m_logger, this.m_context, this.m_componentManager, this.m_roles, this.m_logkit, this.m_configuration, initializeAndStart);
    }

    public static Object setupComponent(Object component, Logger logger, Context context, ComponentManager componentManager, RoleManager roles, LogKitManager logkit, Configuration configuration) throws Exception {
        return LifecycleHelper.setupComponent(component, logger, context, componentManager, roles, logkit, configuration, true);
    }

    public static Object setupComponent(Object component, Logger logger, Context context, ComponentManager componentManager, RoleManager roles, LogKitManager logkit, Configuration configuration, boolean initializeAndStart) throws Exception {
        if (component instanceof Loggable) {
            String loggerName;
            Logger usedLogger = null == logkit ? logger : (configuration == null ? logger : (null == (loggerName = configuration.getAttribute("logger", null)) ? logger : logkit.getLogger(loggerName)));
            ((Loggable)component).setLogger(usedLogger);
        }
        if (null != context && component instanceof Contextualizable) {
            ((Contextualizable)component).contextualize(context);
        }
        if (null != componentManager && component instanceof Composable) {
            ((Composable)component).compose(componentManager);
        }
        if (null != roles && component instanceof RoleManageable) {
            ((RoleManageable)component).setRoleManager(roles);
        }
        if (null != logkit && component instanceof LogKitManageable) {
            ((LogKitManageable)component).setLogKitManager(logkit);
        }
        if (null != configuration && component instanceof Configurable) {
            ((Configurable)component).configure(configuration);
        }
        if (null != configuration && component instanceof Parameterizable) {
            ((Parameterizable)component).parameterize(Parameters.fromConfiguration((Configuration)configuration));
        }
        if (initializeAndStart && component instanceof Initializable) {
            ((Initializable)component).initialize();
        }
        if (initializeAndStart && component instanceof Startable) {
            ((Startable)component).start();
        }
        return component;
    }

    public static final void decommission(Object component) throws Exception {
        if (component instanceof Startable) {
            ((Startable)component).stop();
        }
        LifecycleHelper.dispose(component);
    }

    public static final void dispose(Object component) {
        if (component instanceof Disposable) {
            ((Disposable)component).dispose();
        }
    }
}

