/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.components;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.avalon.framework.component.Component;
import org.apache.avalon.framework.component.ComponentManager;
import org.apache.avalon.framework.component.ComponentSelector;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.DefaultConfiguration;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.environment.Environment;

final class EnvironmentDescription {
    private static final Configuration EMPTY_CONFIGURATION = new DefaultConfiguration("config", "");
    Environment environment;
    Map objectModel;
    Map requestLifecycleComponents = new HashMap(5);
    List autoreleaseComponents = new ArrayList(2);
    List sitemapConfigurations = new ArrayList(4);

    EnvironmentDescription(Environment env) {
        this.environment = env;
        this.objectModel = env.getObjectModel();
    }

    void release() {
        Iterator iter = this.requestLifecycleComponents.values().iterator();
        while (iter.hasNext()) {
            Object[] o = (Object[])iter.next();
            Component component = (Component)o[0];
            ((ComponentManager)o[1]).release(component);
        }
        int i = 0;
        while (i < this.autoreleaseComponents.size()) {
            Object[] o = (Object[])this.autoreleaseComponents.get(i);
            Component component = (Component)o[0];
            if (o[1] instanceof ComponentManager) {
                ((ComponentManager)o[1]).release(component);
            } else {
                ((ComponentSelector)o[1]).release(component);
                if (o[2] != null) {
                    ((ComponentManager)o[2]).release((Component)o[1]);
                }
            }
            ++i;
        }
        this.requestLifecycleComponents.clear();
        this.autoreleaseComponents.clear();
        this.sitemapConfigurations.clear();
        this.environment = null;
        this.objectModel = null;
    }

    void addRequestLifecycleComponent(String role, Component co, ComponentManager manager) {
        this.requestLifecycleComponents.put(role, new Object[]{co, manager});
    }

    boolean containsRequestLifecycleComponent(String role) {
        return this.requestLifecycleComponents.containsKey(role);
    }

    Component getRequestLifecycleComponent(String role) {
        Object[] o = (Object[])this.requestLifecycleComponents.get(role);
        if (null != o) {
            return (Component)o[0];
        }
        return null;
    }

    void addToAutoRelease(ComponentSelector selector, Component component, ComponentManager manager) {
        this.autoreleaseComponents.add(new Object[]{component, selector, manager});
    }

    void addToAutoRelease(ComponentManager manager, Component component) {
        this.autoreleaseComponents.add(new Object[]{component, manager});
    }

    void removeFromAutoRelease(Component component) throws ProcessingException {
        int i = 0;
        boolean found = false;
        while (i < this.autoreleaseComponents.size() && !found) {
            Object[] o = (Object[])this.autoreleaseComponents.get(i);
            if (o[0] == component) {
                found = true;
                if (o[1] instanceof ComponentManager) {
                    ((ComponentManager)o[1]).release(component);
                } else {
                    ((ComponentSelector)o[1]).release(component);
                    if (o[2] != null) {
                        ((ComponentManager)o[2]).release((Component)o[1]);
                    }
                }
                this.autoreleaseComponents.remove(i);
                continue;
            }
            ++i;
        }
        if (!found) {
            throw new ProcessingException("Unable to remove component from automatic release: component not found.");
        }
    }

    void addSitemapConfiguration(Configuration conf) {
        if (conf != null) {
            this.sitemapConfigurations.add(conf);
        } else {
            this.sitemapConfigurations.add(EMPTY_CONFIGURATION);
        }
    }

    List getSitemapConfigurations() {
        return this.sitemapConfigurations;
    }

    void removeLastSitemapConfiguration() {
        this.sitemapConfigurations.remove(this.sitemapConfigurations.size() - 1);
    }
}

