/*
 * Decompiled with CFR 0.152.
 */
package net.sf.pizzacompiler.compiler;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import net.sf.pizzacompiler.compiler.SourceReader;
import pizza.support.array;

public class MapSourceReader
extends SourceReader {
    private Map _sourceNameToJavaSource;

    public MapSourceReader(Map map) throws MapSourceReaderException {
        try {
            map.keySet().toArray((Object[])array.asObject(new String[0]));
            map.values().toArray((Object[])array.asObject(new String[0]));
        }
        catch (ArrayStoreException arrayStoreException) {
            throw new MapSourceReaderException("Map must be String to String");
        }
        this._sourceNameToJavaSource = map;
    }

    public InputStream getInputStream(String string) throws IOException {
        String string2 = (String)this._sourceNameToJavaSource.get(string);
        if (string2 == null) {
            throw new IOException(String.valueOf("unknown source: ").concat(String.valueOf(string2)));
        }
        return new ByteArrayInputStream(string2.getBytes());
    }

    public static class MapSourceReaderException
    extends RuntimeException {
        MapSourceReaderException(String string) {
            super(string);
        }
    }
}

