/*
 * Decompiled with CFR 0.152.
 */
package net.sf.pizzacompiler.compiler;

import java.io.IOException;
import net.sf.pizzacompiler.compiler.AST;
import net.sf.pizzacompiler.compiler.ASTgen;
import net.sf.pizzacompiler.compiler.AssignItem;
import net.sf.pizzacompiler.compiler.Basic;
import net.sf.pizzacompiler.compiler.Bits;
import net.sf.pizzacompiler.compiler.ByteCodeGen$$closures;
import net.sf.pizzacompiler.compiler.Chain;
import net.sf.pizzacompiler.compiler.ClassSymbol;
import net.sf.pizzacompiler.compiler.ClassWriter;
import net.sf.pizzacompiler.compiler.CompilerOutput;
import net.sf.pizzacompiler.compiler.CondItem;
import net.sf.pizzacompiler.compiler.ConstType;
import net.sf.pizzacompiler.compiler.Constants;
import net.sf.pizzacompiler.compiler.Env;
import net.sf.pizzacompiler.compiler.FunSymbol;
import net.sf.pizzacompiler.compiler.Gen;
import net.sf.pizzacompiler.compiler.GenInfo;
import net.sf.pizzacompiler.compiler.ImmediateItem;
import net.sf.pizzacompiler.compiler.IndexedItem;
import net.sf.pizzacompiler.compiler.IntConst;
import net.sf.pizzacompiler.compiler.Item;
import net.sf.pizzacompiler.compiler.LocalItem;
import net.sf.pizzacompiler.compiler.MemberItem;
import net.sf.pizzacompiler.compiler.Name;
import net.sf.pizzacompiler.compiler.Namer;
import net.sf.pizzacompiler.compiler.OperatorSymbol;
import net.sf.pizzacompiler.compiler.Pretty;
import net.sf.pizzacompiler.compiler.Report;
import net.sf.pizzacompiler.compiler.StackItem;
import net.sf.pizzacompiler.compiler.StaticItem;
import net.sf.pizzacompiler.compiler.StringConst;
import net.sf.pizzacompiler.compiler.Switches;
import net.sf.pizzacompiler.compiler.Symbol;
import net.sf.pizzacompiler.compiler.Symtab;
import net.sf.pizzacompiler.compiler.Type;
import net.sf.pizzacompiler.compiler.TypeSymbol;
import net.sf.pizzacompiler.compiler.VarSymbol;
import net.sf.pizzacompiler.lang.List;
import net.sf.pizzacompiler.lang.ListBuffer;
import net.sf.pizzacompiler.util.Enumeration;
import pizza.support.Closure;

class ByteCodeGen
implements Constants {
    static Name valueOfS = Name.fromString("valueOf");
    static Name concatS = Name.fromString("concat");
    static Name forNameS = Name.fromString("forName");
    static Name TYPES = Name.fromString("TYPE");

    static void loadIntConst(int n) {
        ImmediateItem.make(new IntConst(n)).load();
    }

    static LocalItem makeTemp(Type type) {
        return (LocalItem)LocalItem.make(0, type, Gen.newLocal(type));
    }

    static AST makeAssign(int n, Symbol symbol, AST aST) {
        return ASTgen.at(n).Exec(ASTgen.at(n).Assign(ASTgen.at(n).Ident(symbol.name).setSymbol(symbol).setType(symbol.type), aST).setType(symbol.type)).setType(Type.VoidType);
    }

    static AST[] normalizeDefs(AST[] aSTArray, ClassSymbol classSymbol) {
        Constants constants;
        Constants constants2;
        Object object;
        ListBuffer listBuffer = new ListBuffer();
        ListBuffer listBuffer2 = new ListBuffer();
        ListBuffer listBuffer3 = new ListBuffer();
        block5: for (int i = 0; i < aSTArray.length; ++i) {
            object = aSTArray[i];
            switch (((AST)object).net$sf$pizzacompiler$compiler$AST$$tag) {
                case 8: {
                    int n = ((AST.Block)object).mods;
                    ((n & 8) != 0 ? listBuffer2 : listBuffer).net$sf$pizzacompiler$lang$ListBuffer$append(object);
                    continue block5;
                }
                case 5: {
                    listBuffer3.net$sf$pizzacompiler$lang$ListBuffer$append(object);
                    continue block5;
                }
                case 6: {
                    AST.VarDef varDef = (AST.VarDef)object;
                    constants2 = varDef.sym;
                    constants = varDef.init;
                    int n = varDef.mods;
                    if (constants == null || ((Symbol)constants2).type.isConstant()) continue block5;
                    ((n & 8) != 0 ? listBuffer2 : listBuffer).net$sf$pizzacompiler$lang$ListBuffer$append(ByteCodeGen.makeAssign(((AST)object).pos, (Symbol)constants2, constants));
                    continue block5;
                }
                default: {
                    throw new InternalError();
                }
            }
        }
        if (listBuffer.length() != 0) {
            object = listBuffer.net$sf$pizzacompiler$lang$ListBuffer$toList();
            Enumeration enumeration = listBuffer3.net$sf$pizzacompiler$lang$ListBuffer$elements();
            while (enumeration.hasMoreElements()) {
                ByteCodeGen.normalizeFun((AST.FunDef)enumeration.net$sf$pizzacompiler$util$Enumeration$nextElement(), (List)object);
            }
        }
        if (listBuffer2.length() != 0) {
            object = new FunSymbol(8, Basic.clinitS, new Type.FunType(new Type[0], Type.VoidType, List.Nil), classSymbol);
            classSymbol.locals().enter((Symbol)object);
            AST[] aSTArray2 = ASTgen.toArray(listBuffer2);
            constants2 = ASTgen.at(aSTArray2[0].pos).share();
            constants = Type.VoidType.tsym();
            listBuffer3.net$sf$pizzacompiler$lang$ListBuffer$append(((ASTgen)constants2).FunDef(((Symbol)object).name, ((Symbol)object).modifiers, ((ASTgen)constants2).Ident(((Symbol)constants).name).setSymbol((Symbol)constants).setType(Type.VoidType), ASTgen.emptyVarDefs, ASTgen.emptyASTs, aSTArray2).setSymbol((Symbol)object).setType(((Symbol)object).type));
        }
        return ASTgen.toArray(listBuffer3);
    }

    static void enterFinals(FunSymbol funSymbol) {
        Symbol symbol = ((TypeSymbol)funSymbol.owner).locals().elems;
        while (symbol != null) {
            if (symbol.sym.kind == 4 && (symbol.sym.modifiers & 0x10) != 0 && !symbol.sym.type.isConstant() && (symbol.sym.modifiers & 8) == (funSymbol.modifiers & 8)) {
                VarSymbol varSymbol = (VarSymbol)symbol.sym;
                Gen.newFinal(varSymbol);
                Gen.letUninit(varSymbol.adr);
            }
            symbol = symbol.sibling;
        }
    }

    static void checkFinalsInit(int n, FunSymbol funSymbol) {
        Symbol symbol = ((TypeSymbol)funSymbol.owner).locals().elems;
        while (symbol != null) {
            if (symbol.sym.kind == 4 && (symbol.sym.modifiers & 0x10) != 0 && !symbol.sym.type.isConstant() && (symbol.sym.modifiers & 8) == (funSymbol.modifiers & 8)) {
                VarSymbol varSymbol = (VarSymbol)symbol.sym;
                Gen.checkInit(n, varSymbol.adr);
            }
            symbol = symbol.sibling;
        }
    }

    static void checkFinalsInit(AST aST) {
        switch (aST.net$sf$pizzacompiler$compiler$AST$$tag) {
            case 5: {
                FunSymbol funSymbol = ((AST.FunDef)aST).sym;
                if (!ByteCodeGen.isInitialConstructor((AST.FunDef)aST)) break;
                ByteCodeGen.checkFinalsInit(aST.pos, funSymbol);
            }
        }
    }

    static void endFinals(FunSymbol funSymbol) {
        Symbol symbol = ((TypeSymbol)funSymbol.owner).locals().elems;
        while (symbol != null) {
            if (symbol.sym.kind == 4 && (symbol.sym.modifiers & 0x10) != 0 && !symbol.sym.type.isConstant() && (symbol.sym.modifiers & 8) == (funSymbol.modifiers & 8)) {
                VarSymbol varSymbol = (VarSymbol)symbol.sym;
                Gen.endFinal(varSymbol);
            }
            symbol = symbol.sibling;
        }
    }

    static boolean isSyntheticInit(AST aST) {
        switch (aST.net$sf$pizzacompiler$compiler$AST$$tag) {
            case 19: {
                switch (((AST.Exec)aST).expr.net$sf$pizzacompiler$compiler$AST$$tag) {
                    case 31: {
                        switch (((AST.Assign)((AST.Exec)aST).expr).lhs.net$sf$pizzacompiler$compiler$AST$$tag) {
                            case 37: {
                                AST.Select select = (AST.Select)((AST.Assign)((AST.Exec)aST).expr).lhs;
                                switch (select.selected.net$sf$pizzacompiler$compiler$AST$$tag) {
                                    case 39: {
                                        Symbol symbol = select.sym;
                                        Name name = select.selector;
                                        Name name2 = ((AST.Self)select.selected).name;
                                        return (symbol.modifiers & 0x10000) != 0 && name2 == Basic.thisS && (name == Basic.this0S || name.startsWith(Basic.valDS));
                                    }
                                }
                            }
                        }
                    }
                }
                break;
            }
            default: {
                return false;
            }
        }
        return false;
    }

    static boolean isInitialConstructor(AST.FunDef funDef) {
        if (funDef.name != Basic.initS && funDef.name != Basic.clinitS) {
            return false;
        }
        if (funDef.stats.length >= 1) {
            AST aST = funDef.stats[0];
            block0 : switch (aST.net$sf$pizzacompiler$compiler$AST$$tag) {
                case 19: {
                    switch (((AST.Exec)aST).expr.net$sf$pizzacompiler$compiler$AST$$tag) {
                        case 28: {
                            switch (((AST.Apply)((AST.Exec)aST).expr).fn.net$sf$pizzacompiler$compiler$AST$$tag) {
                                case 39: {
                                    Name name = ((AST.Self)((AST.Apply)((AST.Exec)aST).expr).fn).name;
                                    if (name != Basic.thisS) break block0;
                                    return false;
                                }
                            }
                        }
                    }
                }
            }
        }
        return true;
    }

    static void normalizeFun(AST.FunDef funDef, List list) {
        if (funDef.name == Basic.initS && ByteCodeGen.isInitialConstructor(funDef)) {
            int n;
            ListBuffer listBuffer = new ListBuffer();
            listBuffer.net$sf$pizzacompiler$lang$ListBuffer$append(funDef.stats[0]);
            for (n = 1; n < funDef.stats.length && ByteCodeGen.isSyntheticInit(funDef.stats[n]); ++n) {
                listBuffer.net$sf$pizzacompiler$lang$ListBuffer$append(funDef.stats[n]);
            }
            Basic.append(listBuffer, list);
            while (n < funDef.stats.length) {
                listBuffer.net$sf$pizzacompiler$lang$ListBuffer$append(funDef.stats[n]);
                ++n;
            }
            funDef.stats = ASTgen.toArray(listBuffer);
        }
    }

    static void output(int n, ClassSymbol classSymbol, CompilerOutput compilerOutput) {
        try {
            Symtab.writer.writeClassFile(classSymbol, compilerOutput);
        }
        catch (IOException iOException) {
            Report.error(n, String.valueOf(String.valueOf(String.valueOf("error writing ").concat(String.valueOf(classSymbol.name))).concat(String.valueOf(".class: "))).concat(String.valueOf(iOException)));
        }
    }

    static void genTry(Env env, boolean bl) {
        AST.FunDef funDef = env.enclMethod;
        switch (funDef.net$sf$pizzacompiler$compiler$AST$$tag) {
            case 5: {
                AST.FunDef funDef2 = funDef;
                FunSymbol funSymbol = funDef2.sym;
                AST[] aSTArray = funDef2.stats;
                AST.VarDef[] varDefArray = funDef2.params;
                int n = funDef2.mods;
                if (aSTArray == null) break;
                funSymbol.code = Gen.newCode(bl, funSymbol);
                if ((n & 8) == 0) {
                    Gen.newLocal(funSymbol.owner.type);
                }
                for (int i = 0; i < varDefArray.length; ++i) {
                    Gen.newLocal(varDefArray[i].sym);
                    Gen.letInit(varDefArray[i].sym.adr);
                }
                if (ByteCodeGen.isInitialConstructor(env.enclMethod)) {
                    ByteCodeGen.enterFinals(funSymbol);
                }
                ByteCodeGen.genStats(aSTArray, env);
                Basic.assert(Gen.stackSize() == 0);
                if (ByteCodeGen.isInitialConstructor(env.enclMethod)) {
                    ByteCodeGen.checkFinalsInit(env.enclMethod.pos, funSymbol);
                    ByteCodeGen.endFinals(funSymbol);
                }
                if (Gen.alive) {
                    if (funSymbol.type.restype() != Type.VoidType) {
                        Report.error(env.enclMethod.pos, "missing method return");
                        Gen.markDead();
                    } else {
                        if (aSTArray.length == 0) {
                            Gen.statBegin(env.enclMethod.pos);
                        }
                        Gen.emitop(177);
                    }
                }
                Gen.endScopes(0);
                if (bl || !funSymbol.code.fatcode) break;
                boolean bl2 = Report.ignoreErrors;
                Report.ignoreErrors = true;
                ByteCodeGen.genTry(env, true);
                Report.ignoreErrors = bl2;
            }
        }
    }

    static void generate(AST.TopLevel topLevel, CompilerOutput compilerOutput) {
        Name name = Report.useSource(topLevel.sourcefile);
        Env env = new Env(topLevel, new GenInfo());
        env.toplevel = topLevel;
        for (int i = 0; i < topLevel.defs.length; ++i) {
            ByteCodeGen.genDef(topLevel.defs[i], env, compilerOutput);
        }
        Report.useSource(name);
    }

    static void genDef(AST aST, Env env, CompilerOutput compilerOutput) {
        switch (aST.net$sf$pizzacompiler$compiler$AST$$tag) {
            case 2: 
            case 3: {
                break;
            }
            case 4: {
                AST.ClassDef classDef = (AST.ClassDef)aST;
                ClassSymbol classSymbol = classDef.sym;
                AST[] aSTArray = classDef.defs;
                aSTArray = ByteCodeGen.normalizeDefs(aSTArray, classSymbol);
                ((AST.ClassDef)aST).defs = aSTArray;
                classSymbol.pool = Gen.newPool();
                Env env2 = env.net$sf$pizzacompiler$compiler$Env$dup(aST);
                env2.enclClass = (AST.ClassDef)aST;
                for (int i = 0; i < aSTArray.length; ++i) {
                    ByteCodeGen.genDef(aSTArray[i], env2, compilerOutput);
                }
                if (Report.getNrErrors() != 0) break;
                ByteCodeGen.output(aST.pos, classSymbol, compilerOutput);
                break;
            }
            case 5: {
                Env env3 = env.net$sf$pizzacompiler$compiler$Env$dup(aST);
                env3.enclMethod = (AST.FunDef)aST;
                ByteCodeGen.genTry(env3, false);
                break;
            }
            default: {
                Pretty.printDef(aST);
                System.out.println();
                throw new InternalError();
            }
        }
    }

    static void callFinalizer(Env env) {
        if (Gen.alive) {
            Gen.pushStack(4);
            ((GenInfo)env.info).cont = new Chain(Gen.curPc(), ((GenInfo)env.info).cont, Gen.stackSize(), Gen.uninitSet(), Gen.initSet());
            Gen.popStack(4);
            Gen.emitJump(((GenInfo)env.info).cont, 168);
        }
    }

    static Env jumpto(AST aST, Env env) {
        Env env2 = env;
        while (env2 != null && env2.tree != aST) {
            env2 = env2.next;
        }
        if (env2 != null) {
            AST aST2 = null;
            while (env != env2) {
                if (env.tree != aST2) {
                    AST aST3 = env.tree;
                    switch (aST3.net$sf$pizzacompiler$compiler$AST$$tag) {
                        case 16: {
                            AST aST4 = ((AST.Try)aST3).finalizer;
                            if (aST4 == null) break;
                            ByteCodeGen.callFinalizer(env);
                            break;
                        }
                        case 15: {
                            ByteCodeGen.callFinalizer(env);
                            break;
                        }
                    }
                    aST2 = env.tree;
                }
                env = env.next;
            }
        }
        return env2;
    }

    static boolean hasFinalizers(AST aST, Env env) {
        while (env.tree != aST) {
            AST aST2 = env.tree;
            switch (aST2.net$sf$pizzacompiler$compiler$AST$$tag) {
                case 16: {
                    AST aST3 = ((AST.Try)aST2).finalizer;
                    if (aST3 == null) break;
                    return true;
                }
                case 15: {
                    return true;
                }
            }
            env = env.next;
        }
        return false;
    }

    static void genStat(AST aST, Env env) {
        switch (aST.net$sf$pizzacompiler$compiler$AST$$tag) {
            case 47: {
                if (Gen.alive) {
                    Report.error(aST.pos, "possible fall-through from Pizza case");
                    Gen.markDead();
                }
                return;
            }
        }
        Gen.statBegin(aST.pos);
        switch (aST.net$sf$pizzacompiler$compiler$AST$$tag) {
            case 6: {
                AST.VarDef varDef = (AST.VarDef)aST;
                VarSymbol varSymbol = varDef.sym;
                AST aST2 = varDef.init;
                Gen.newLocal(varSymbol);
                Gen.letUninit(varSymbol.adr);
                if (aST2 == null || varSymbol.type.isConstant()) break;
                ByteCodeGen.genExpr(aST2, varSymbol.type).load();
                LocalItem.make(aST.pos, varSymbol).store();
                break;
            }
            case 8: {
                AST[] aSTArray = ((AST.Block)aST).stats;
                if (!Gen.alive && aST.pos == 0) break;
                int n = Gen.nextVar();
                ByteCodeGen.genStats(aSTArray, env);
                Gen.endScopes(n);
                break;
            }
            case 9: {
                AST.DoLoop doLoop = (AST.DoLoop)aST;
                AST aST3 = doLoop.body;
                AST aST4 = doLoop.cond;
                int n = Gen.curPc();
                Bits bits = Gen.enterLoop();
                Env env2 = env.net$sf$pizzacompiler$compiler$Env$dup(aST, ((GenInfo)env.info).dup());
                ByteCodeGen.genStat(aST3, env2);
                Gen.resolve(((GenInfo)env2.info).cont);
                Gen.statBegin(aST4.pos);
                CondItem condItem = ByteCodeGen.genExpr(aST4, Type.booleanType).mkCond();
                Gen.resolve(condItem.jumpTrue(), n);
                Gen.resolve(condItem.falseJumps);
                Gen.resolve(((GenInfo)env2.info).exit);
                Gen.exitLoop(bits);
                break;
            }
            case 10: {
                AST.WhileLoop whileLoop = (AST.WhileLoop)aST;
                AST aST5 = whileLoop.body;
                AST aST6 = whileLoop.cond;
                int n = Gen.curPc();
                Bits bits = Gen.enterLoop();
                CondItem condItem = ByteCodeGen.genExpr(aST6, Type.booleanType).mkCond();
                Env env3 = env.net$sf$pizzacompiler$compiler$Env$dup(aST, ((GenInfo)env.info).dup());
                ((GenInfo)env3.info).exit = condItem.jumpFalse();
                if (condItem.trueJumps != null || condItem.opcode != Gen.dontgoto) {
                    Gen.resolve(condItem.trueJumps);
                    ByteCodeGen.genStat(aST5, env3);
                    Gen.resolve(((GenInfo)env3.info).cont);
                    Gen.resolve(Gen.branch(167), n);
                }
                Gen.resolve(((GenInfo)env3.info).exit);
                Gen.exitLoop(bits);
                break;
            }
            case 11: {
                CondItem condItem;
                AST.ForLoop forLoop = (AST.ForLoop)aST;
                AST aST7 = forLoop.body;
                AST[] aSTArray = forLoop.step;
                AST aST8 = forLoop.cond;
                AST[] aSTArray2 = forLoop.init;
                ByteCodeGen.genStats(aSTArray2, env);
                int n = Gen.curPc();
                Bits bits = Gen.enterLoop();
                if (aST8 != null) {
                    Gen.statBegin(aST8.pos);
                    condItem = ByteCodeGen.genExpr(aST8, Type.booleanType).mkCond();
                } else {
                    condItem = CondItem.make(167);
                }
                Env env4 = env.net$sf$pizzacompiler$compiler$Env$dup(aST, ((GenInfo)env.info).dup());
                ((GenInfo)env4.info).exit = condItem.jumpFalse();
                if (condItem.trueJumps != null || condItem.opcode != Gen.dontgoto) {
                    Gen.resolve(condItem.trueJumps);
                    ByteCodeGen.genStat(aST7, env4);
                    Gen.resolve(((GenInfo)env4.info).cont);
                    ByteCodeGen.genStats(aSTArray, env4);
                    Gen.resolve(Gen.branch(167), n);
                }
                Gen.resolve(((GenInfo)env4.info).exit);
                Gen.exitLoop(bits);
                break;
            }
            case 12: {
                AST aST9 = ((AST.Labelled)aST).body;
                Env env5 = env.net$sf$pizzacompiler$compiler$Env$dup(aST9, ((GenInfo)env.info).dup());
                ByteCodeGen.genStat(aST9, env5);
                Gen.resolve(((GenInfo)env5.info).exit);
                break;
            }
            case 13: {
                AST.Switch switch_ = (AST.Switch)aST;
                AST.Case[] caseArray = switch_.cases;
                AST aST10 = switch_.selector;
                Item item = ByteCodeGen.genExpr(aST10, Type.intType);
                if (caseArray.length == 0) {
                    item.load().drop();
                    break;
                }
                if (caseArray.length == 1 && caseArray[0].pat == null) {
                    item.drop();
                    ByteCodeGen.genStats(caseArray[0].stats, env);
                    break;
                }
                item.load();
                ByteCodeGen.genSwitch(caseArray, env.net$sf$pizzacompiler$compiler$Env$dup(aST, ((GenInfo)env.info).dup()));
                break;
            }
            case 15: {
                AST.Synchronized synchronized_ = (AST.Synchronized)aST;
                AST aST11 = synchronized_.body;
                AST aST12 = synchronized_.lock;
                LocalItem localItem = ByteCodeGen.makeTemp(Symtab.objectType);
                ByteCodeGen.genExpr(aST12, aST12.type).load();
                ((Item)localItem).store();
                ((Item)localItem).load();
                Gen.emitop(194);
                Env env6 = env.net$sf$pizzacompiler$compiler$Env$dup(aST, ((GenInfo)env.info).dup());
                ByteCodeGen.genTryBlock(aST11, null, new ByteCodeGen$$closures(null, 0, new Object[]{localItem}), env6);
                break;
            }
            case 16: {
                AST.Try try_ = (AST.Try)aST;
                AST aST13 = try_.finalizer;
                AST.Catch[] catchArray = try_.catchers;
                AST aST14 = try_.body;
                Env env7 = env.net$sf$pizzacompiler$compiler$Env$dup(aST, ((GenInfo)env.info).dup());
                ByteCodeGen.genTryBlock(aST14, catchArray, aST13 == null ? null : new ByteCodeGen$$closures(null, 1, new Object[]{aST13, env}), env7);
                break;
            }
            case 18: {
                AST.Conditional conditional = (AST.Conditional)aST;
                AST aST15 = conditional.elsepart;
                AST aST16 = conditional.thenpart;
                AST aST17 = conditional.cond;
                Chain chain = null;
                CondItem condItem = ByteCodeGen.genExpr(aST17, Type.booleanType).mkCond();
                Chain chain2 = condItem.jumpFalse();
                if (condItem.trueJumps != null || condItem.opcode != Gen.dontgoto) {
                    Gen.resolve(condItem.trueJumps);
                    ByteCodeGen.genStat(aST16, env);
                    chain = Gen.branch(167);
                }
                if (aST15 != null && chain2 != null) {
                    Gen.resolve(chain2);
                    ByteCodeGen.genStat(aST15, env);
                    Gen.resolve(chain);
                    break;
                }
                Gen.resolve(chain);
                Gen.resolve(chain2);
                break;
            }
            case 19: {
                AST aST18 = ((AST.Exec)aST).expr;
                switch (aST18.net$sf$pizzacompiler$compiler$AST$$tag) {
                    case 34: {
                        int n = ((AST.Unop)aST18).opcode;
                        if (n == 8) {
                            ((AST.Unop)aST18).opcode = 6;
                            break;
                        }
                        if (n != 9) break;
                        ((AST.Unop)aST18).opcode = 7;
                    }
                }
                ByteCodeGen.genExpr(aST18, aST18.type).drop();
                break;
            }
            case 20: {
                AST aST19 = ((AST.Break)aST).target;
                Env env8 = ByteCodeGen.jumpto(aST19, env);
                if (env8 == null) break;
                ((GenInfo)env8.info).addExit(Gen.branch(167));
                break;
            }
            case 21: {
                AST aST20 = ((AST.Continue)aST).target;
                ((GenInfo)ByteCodeGen.jumpto((AST)aST20, (Env)env).info).addCont(Gen.branch(167));
                break;
            }
            case 22: {
                AST.Return return_ = (AST.Return)aST;
                AST aST21 = return_.target;
                AST aST22 = return_.expr;
                ByteCodeGen.checkFinalsInit(aST21);
                if (aST22 != null) {
                    Item item = ByteCodeGen.genExpr(aST22, aST.type);
                    if (ByteCodeGen.hasFinalizers(aST21, env)) {
                        item.load();
                        item = ByteCodeGen.makeTemp(aST.type);
                        item.store();
                    }
                    ByteCodeGen.jumpto(aST21, env);
                    item.load();
                    Gen.emitop(172 + Gen.truncate(Gen.typecode(aST.type)));
                    break;
                }
                ByteCodeGen.jumpto(aST21, env);
                Gen.emitop(177);
                break;
            }
            case 24: {
                AST aST23 = ((AST.Throw)aST).expr;
                ByteCodeGen.checkFinalsInit(env.enclMethod);
                ByteCodeGen.genExpr(aST23, aST23.type).load();
                Gen.emitop(191);
            }
        }
    }

    static void genCatch(AST aST, Env env, int n, int n2) {
        switch (aST.net$sf$pizzacompiler$compiler$AST$$tag) {
            case 17: {
                AST.Catch catch_ = (AST.Catch)aST;
                AST[] aSTArray = catch_.stats;
                AST.VarDef varDef = catch_.param;
                if (n == n2) break;
                Gen.registerCatch(n, n2, Gen.curPc(), Gen.mkref(varDef.type));
                Gen.newLocal(varDef.sym);
                LocalItem.make(aST.pos, varDef.sym).store();
                ByteCodeGen.genStats(aSTArray, env);
                break;
            }
            default: {
                throw new InternalError();
            }
        }
    }

    static AST[] stats(AST aST) {
        switch (aST.net$sf$pizzacompiler$compiler$AST$$tag) {
            case 8: {
                AST[] aSTArray = ((AST.Block)aST).stats;
                return aSTArray;
            }
        }
        return new AST[]{aST};
    }

    static void genTryBlock(AST aST, AST.Catch[] catchArray, Closure closure, Env env) {
        Bits bits;
        int n = Gen.nextVar();
        Bits bits2 = Gen.uninitSet();
        int n2 = Gen.curPc();
        ByteCodeGen.genStat(aST, env);
        int n3 = Gen.curPc();
        Bits bits3 = bits = Gen.initSet();
        if (closure != null) {
            ByteCodeGen.callFinalizer(env);
        }
        Chain chain = Gen.branch(167);
        if (n2 != n3 && catchArray != null) {
            for (int i = 0; i < catchArray.length; ++i) {
                Gen.entryPoint(bits2, bits);
                Gen.clearStack();
                Gen.pushStack(4);
                ByteCodeGen.genCatch(catchArray[i], env, n2, n3);
                bits3.orSet(Gen.initSet());
                if (closure != null) {
                    ByteCodeGen.callFinalizer(env);
                }
                chain = Gen.mergeChains(chain, Gen.branch(167));
            }
        }
        if (closure != null) {
            Gen.entryPoint(bits2, bits3);
            Gen.registerCatch(n2, Gen.curPc(), Gen.curPc(), 0);
            Gen.newRegSegment();
            Gen.clearStack();
            Gen.pushStack(4);
            LocalItem localItem = ByteCodeGen.makeTemp(Symtab.throwableType);
            ((Item)localItem).store();
            ByteCodeGen.callFinalizer(env);
            ((Item)localItem).load();
            Gen.emitop(191);
            Gen.entryPoint(bits2, bits3);
            Gen.clearStack();
            Gen.pushStack(4);
            Gen.resolve(((GenInfo)env.info).cont);
            LocalItem localItem2 = ByteCodeGen.makeTemp(Symtab.throwableType);
            localItem2.store();
            closure.$apply();
            Bits bits4 = Gen.uninitSet();
            Gen.emitop1w(169, Gen.regOf(localItem2.adr));
            if (Gen.alive) {
                Gen.markDead();
                Gen.resolve(chain);
                Gen.uninits.andSet(bits4);
            }
        } else {
            Gen.resolve(chain);
        }
        Gen.endScopes(n);
    }

    static void genSwitch(AST.Case[] caseArray, Env env) {
        block20: {
            int n;
            int n2;
            int n3 = Integer.MAX_VALUE;
            int n4 = Integer.MIN_VALUE;
            int n5 = 0;
            int[] nArray = new int[caseArray.length];
            int[] nArray2 = null;
            int n6 = -1;
            for (int i = 0; i < caseArray.length; ++i) {
                if (caseArray[i].pat != null) {
                    int n7;
                    nArray[i] = n7 = caseArray[i].pat.type.constValue().intValue();
                    if (n7 < n3) {
                        n3 = n7;
                    }
                    if (n4 < n7) {
                        n4 = n7;
                    }
                    ++n5;
                    continue;
                }
                Basic.assert(n6 == -1);
                n6 = i;
            }
            long l = 4L + (long)(n4 - n3 + 1);
            long l2 = 3L;
            long l3 = 3L + (long)(2 * n5);
            long l4 = n5;
            int n8 = n2 = l + 3L * l2 <= l3 + 3L * l4 ? 170 : 171;
            if (!Gen.alive) break block20;
            Bits bits = Gen.uninitSet();
            Bits bits2 = Gen.initSet();
            int n9 = Gen.curPc();
            Gen.emitop(n2);
            Gen.align(4);
            int n10 = Gen.curPc();
            Gen.emit4(-1);
            if (n2 == 170) {
                Gen.emit4(n3);
                Gen.emit4(n4);
                for (n = n3; n <= n4; ++n) {
                    Gen.emit4(-1);
                }
            } else {
                Gen.emit4(n5);
                for (n = 0; n < n5; ++n) {
                    Gen.emit4(-1);
                    Gen.emit4(-1);
                }
                nArray2 = new int[caseArray.length];
            }
            Gen.markDead();
            for (n = 0; n < caseArray.length; ++n) {
                AST.Case case_ = caseArray[n];
                if (n != n6) {
                    if (n2 == 170) {
                        Gen.put4(n10 + 4 * (nArray[n] - n3 + 3), Gen.curPc() - n9);
                    } else {
                        nArray2[n] = Gen.curPc() - n9;
                    }
                } else {
                    Gen.put4(n10, Gen.curPc() - n9);
                }
                Gen.entryPoint(bits, bits2);
                ByteCodeGen.genStats(case_.stats, env);
                if (!Switches.switchCheck || !Gen.alive || case_.stats.length == 0 || n >= caseArray.length - 1) continue;
                Report.warning(case_.pos, "possible fall-through from case");
            }
            Gen.resolve(((GenInfo)env.info).exit);
            if (Gen.get4(n10) == -1) {
                Gen.put4(n10, Gen.curPc() - n9);
                Gen.entryPoint(bits, bits2);
            }
            if (n2 == 170) {
                int n11 = Gen.get4(n10);
                for (int i = n3; i <= n4; ++i) {
                    if (Gen.get4(n10 + 4 * (i - n3 + 3)) != -1) continue;
                    Gen.put4(n10 + 4 * (i - n3 + 3), n11);
                }
            } else {
                if (n6 >= 0) {
                    for (int i = n6; i < caseArray.length - 1; ++i) {
                        nArray[i] = nArray[i + 1];
                        nArray2[i] = nArray2[i + 1];
                    }
                }
                Basic.qsort2(nArray, nArray2, 0, n5 - 1);
                for (int i = 0; i < n5; ++i) {
                    int n12 = n10 + 8 * (i + 1);
                    Gen.put4(n12, nArray[i]);
                    Gen.put4(n12 + 4, nArray2[i]);
                }
            }
        }
    }

    static void genStats(AST[] aSTArray, Env env) {
        for (int i = 0; i < aSTArray.length; ++i) {
            ByteCodeGen.genStat(aSTArray[i], env);
        }
    }

    static Item genClassOf(Type type) {
        Type type2 = type.deref();
        switch (type2.net$sf$pizzacompiler$compiler$Type$$tag) {
            case 1: {
                int n = ((Type.NumType)type2).tag;
                Name name = Type.boxedName[n];
                try {
                    ClassSymbol classSymbol = Symtab.reader.loadClass(name);
                    Symbol symbol = Namer.resolveMember(Gen.statPos, TYPES, classSymbol.type, null, 8);
                    if (symbol != null) {
                        return StaticItem.make(Gen.statPos, symbol);
                    }
                }
                catch (IOException iOException) {
                    Namer.notFound(Gen.statPos, TYPES, name, null);
                }
                break;
            }
            default: {
                ImmediateItem.make(new StringConst(ClassWriter.xClassName(type).replace((byte)47, (byte)46))).load();
                Symbol symbol = Namer.resolveMember(Gen.statPos, forNameS, Symtab.classType, new Type[]{Symtab.stringType}, 8);
                if (symbol == null) break;
                return StaticItem.make(Gen.statPos, symbol).invoke();
            }
        }
        Gen.emitop(1);
        return StackItem.make(Symtab.classType);
    }

    static Item mkString(Type type) {
        Symbol symbol = Namer.resolveMember(Gen.statPos, valueOfS, Type.stringType, new Type[]{type}, 8);
        if (symbol != null) {
            return StaticItem.make(Gen.statPos, symbol).invoke();
        }
        return StackItem.make(Type.stringType);
    }

    static Item completeBinop(Item item, AST aST, AST aST2, OperatorSymbol operatorSymbol) {
        Type.FunType funType = (Type.FunType)operatorSymbol.type;
        int n = operatorSymbol.opcode;
        if (n == 256) {
            item.load();
            ByteCodeGen.mkString(aST.type);
            ByteCodeGen.genExpr(aST2, aST2.type).load();
            ByteCodeGen.mkString(aST2.type);
            Symbol symbol = Namer.resolveMember(Gen.statPos, concatS, Type.stringType, new Type[]{Type.stringType}, 0);
            if (symbol != null) {
                return MemberItem.make(Gen.statPos, symbol, false, false).invoke();
            }
            return StackItem.make(Type.stringType);
        }
        Type type = funType.argtypes[0];
        Type type2 = funType.argtypes[1];
        if (n >= 270 && n <= 275) {
            n += -150;
            type2 = Type.intType;
        }
        item.coerce(type).load();
        ByteCodeGen.genExpr(aST2, type2).load();
        if (n >= 512) {
            Gen.emitop(n >> 9);
            n &= 0xFF;
        }
        if (n >= 153 && n <= 166) {
            return CondItem.make(n);
        }
        Gen.emitop(n);
        return StackItem.make(funType.restype);
    }

    static Item completeUnop(Item item, int n, OperatorSymbol operatorSymbol) {
        Item item2;
        int n2 = operatorSymbol.opcode;
        switch (n) {
            case 2: {
                item2 = item.load();
                break;
            }
            case 3: {
                item2 = item.load();
                Gen.emitop(n2);
                break;
            }
            case 4: {
                item2 = item.mkCond().negate();
                break;
            }
            case 5: {
                item2 = item.load();
                Gen.emitMinusOne(item.typecode);
                Gen.emitop(n2);
                break;
            }
            case 6: 
            case 7: {
                item.duplicate();
                if (item instanceof LocalItem && n2 == 96) {
                    ((LocalItem)item).incr(n == 6 ? 1 : 255);
                    item2 = item;
                    break;
                }
                item.load();
                Gen.emitop(Gen.one(item.typecode));
                Gen.emitop(n2);
                item2 = AssignItem.make(item);
                break;
            }
            case 8: 
            case 9: {
                item.duplicate();
                if (item instanceof LocalItem && n2 == 96) {
                    item2 = item.load();
                    ((LocalItem)item).incr(n == 8 ? 1 : 255);
                    break;
                }
                item2 = item.load();
                item.stash(item.typecode);
                Gen.emitop(Gen.one(item.typecode));
                Gen.emitop(n2);
                item.store();
                break;
            }
            default: {
                throw new InternalError();
            }
        }
        return item2;
    }

    private static int tcode(Type type) {
        Type type2 = type.deref();
        switch (type2.net$sf$pizzacompiler$compiler$Type$$tag) {
            case 1: {
                int n = ((Type.NumType)type2).tag;
                switch (n) {
                    case 1: {
                        return 8;
                    }
                    case 8: {
                        return 4;
                    }
                    case 3: {
                        return 9;
                    }
                    case 2: {
                        return 5;
                    }
                    case 4: {
                        return 10;
                    }
                    case 5: {
                        return 11;
                    }
                    case 6: {
                        return 6;
                    }
                    case 7: {
                        return 7;
                    }
                }
                throw new InternalError();
            }
            case 3: {
                return 0;
            }
            case 4: {
                return 1;
            }
        }
        throw new InternalError(String.valueOf("tcode ").concat(String.valueOf(type)));
    }

    static Item makeNewArray(Type type, int n, Type type2) {
        Type type3 = type.elemtype();
        int n2 = ByteCodeGen.tcode(type3);
        if (n2 == 0 || n2 == 1 && n == 1) {
            Gen.emitop2(189, Gen.mkref(type3));
        } else if (n2 == 1) {
            Gen.emitop(197, 1 - n);
            Gen.emit2(Gen.mkref(type));
            Gen.emit1(n);
        } else {
            Gen.emitop1(188, n2);
        }
        return StackItem.make(type);
    }

    static Item genExpr(AST aST, Type type) {
        Item item;
        if (aST.type.isConstant()) {
            item = ImmediateItem.make(aST.type.constValue());
        } else {
            switch (aST.net$sf$pizzacompiler$compiler$AST$$tag) {
                case 18: {
                    AST.Conditional conditional = (AST.Conditional)aST;
                    AST aST2 = conditional.elsepart;
                    AST aST3 = conditional.thenpart;
                    AST aST4 = conditional.cond;
                    Chain chain = null;
                    CondItem condItem = ByteCodeGen.genExpr(aST4, Type.booleanType).mkCond();
                    Chain chain2 = condItem.jumpFalse();
                    if (condItem.trueJumps != null || condItem.opcode != Gen.dontgoto) {
                        Gen.resolve(condItem.trueJumps);
                        ByteCodeGen.genExpr(aST3, type).load();
                        chain = Gen.branch(167);
                    }
                    if (aST2 != null && chain2 != null) {
                        Gen.resolve(chain2);
                        ByteCodeGen.genExpr(aST2, type).load();
                        Gen.resolve(chain);
                    } else {
                        Gen.resolve(chain);
                        Gen.resolve(chain2);
                    }
                    item = StackItem.make(type);
                    break;
                }
                case 25: 
                case 26: {
                    throw new InternalError();
                }
                case 27: {
                    AST[] aSTArray = ((AST.Aggregate)aST).elems;
                    Type type2 = aST.type.elemtype();
                    ByteCodeGen.loadIntConst(aSTArray.length);
                    Item item2 = ByteCodeGen.makeNewArray(aST.type, 1, type);
                    for (int i = 0; i < aSTArray.length; ++i) {
                        item2.duplicate();
                        ByteCodeGen.loadIntConst(i);
                        ByteCodeGen.genExpr(aSTArray[i], type2).load();
                        IndexedItem.make(type2).store();
                    }
                    item = item2;
                    break;
                }
                case 28: {
                    AST.Apply apply = (AST.Apply)aST;
                    AST[] aSTArray = apply.args;
                    AST aST5 = apply.fn;
                    Item item3 = ByteCodeGen.genExpr(aST5, aST5.type);
                    ByteCodeGen.loadArgs(aSTArray, aST5.type.argtypes());
                    item = item3.invoke();
                    break;
                }
                case 29: {
                    AST.NewClass newClass = (AST.NewClass)aST;
                    Symbol symbol = newClass.constructor;
                    AST aST6 = newClass.def;
                    AST[] aSTArray = newClass.args;
                    AST aST7 = newClass.encl;
                    Basic.assert(aST7 == null && aST6 == null);
                    Gen.emitop2(187, Gen.mkref(aST.type));
                    Gen.emitop(89);
                    ByteCodeGen.loadArgs(aSTArray, symbol.type.argtypes());
                    MemberItem.make(aST.pos, symbol, true, false).invoke();
                    item = StackItem.make(aST.type);
                    break;
                }
                case 30: {
                    AST[] aSTArray = ((AST.NewArray)aST).dims;
                    for (int i = 0; i < aSTArray.length; ++i) {
                        ByteCodeGen.genExpr(aSTArray[i], Type.intType).load();
                    }
                    item = ByteCodeGen.makeNewArray(aST.type, aSTArray.length, type);
                    break;
                }
                case 31: {
                    AST.Assign assign = (AST.Assign)aST;
                    AST aST8 = assign.rhs;
                    AST aST9 = assign.lhs;
                    Item item4 = ByteCodeGen.genExpr(aST9, aST9.type);
                    ByteCodeGen.genExpr(aST8, aST9.type).load();
                    item = AssignItem.make(item4);
                    break;
                }
                case 32: {
                    AST.Assignop assignop = (AST.Assignop)aST;
                    Symbol symbol = assignop.operator;
                    AST aST10 = assignop.rhs;
                    AST aST11 = assignop.lhs;
                    int n = assignop.opcode;
                    Item item5 = ByteCodeGen.genExpr(aST11, aST11.type);
                    if ((n == 24 || n == 25) && item5 instanceof LocalItem && aST11.type.tag() <= 4 && aST10.type.tag() <= 4 && aST10.type.isConstant()) {
                        int n2 = aST10.type.constValue().intValue();
                        if (n == 25) {
                            n2 = -n2;
                        }
                        if (-128 <= n2 && n2 <= 127) {
                            ((LocalItem)item5).incr(n2);
                            return item5;
                        }
                    }
                    item5.duplicate();
                    ByteCodeGen.completeBinop(item5, aST11, aST10, (OperatorSymbol)symbol).coerce(aST11.type);
                    item = AssignItem.make(item5);
                    break;
                }
                case 33: {
                    AST.Binop binop = (AST.Binop)aST;
                    Symbol symbol = binop.operator;
                    AST aST12 = binop.rhs;
                    AST aST13 = binop.lhs;
                    int n = binop.opcode;
                    Item item6 = ByteCodeGen.genExpr(aST13, aST13.type);
                    if (n == 10) {
                        CondItem condItem = item6.mkCond();
                        if (condItem.falseJumps != null || condItem.opcode != 167) {
                            Chain chain = condItem.jumpTrue();
                            Gen.resolve(condItem.falseJumps);
                            CondItem condItem2 = ByteCodeGen.genExpr(aST12, aST12.type).mkCond();
                            item = CondItem.make(condItem2.opcode, Gen.mergeChains(chain, condItem2.trueJumps), condItem2.falseJumps);
                            break;
                        }
                        item = condItem;
                        break;
                    }
                    if (n == 11) {
                        CondItem condItem = item6.mkCond();
                        if (condItem.trueJumps != null || condItem.opcode != Gen.dontgoto) {
                            Chain chain = condItem.jumpFalse();
                            Gen.resolve(condItem.trueJumps);
                            CondItem condItem3 = ByteCodeGen.genExpr(aST12, aST12.type).mkCond();
                            item = CondItem.make(condItem3.opcode, condItem3.trueJumps, Gen.mergeChains(chain, condItem3.falseJumps));
                            break;
                        }
                        item = condItem;
                        break;
                    }
                    item = ByteCodeGen.completeBinop(item6, aST13, aST12, (OperatorSymbol)symbol);
                    break;
                }
                case 34: {
                    AST.Unop unop = (AST.Unop)aST;
                    Symbol symbol = unop.operator;
                    AST aST14 = unop.operand;
                    int n = unop.opcode;
                    item = ByteCodeGen.completeUnop(ByteCodeGen.genExpr(aST14, symbol.type.argtypes()[0]), n, (OperatorSymbol)symbol);
                    break;
                }
                case 35: {
                    AST.Typeop typeop = (AST.Typeop)aST;
                    AST aST15 = typeop.clazz;
                    AST aST16 = typeop.expr;
                    int n = typeop.opcode;
                    Item item7 = ByteCodeGen.genExpr(aST16, aST16.type);
                    if (n == 31) {
                        if (aST15.type.isBasic()) {
                            item = item7.coerce(aST15.type).load();
                            break;
                        }
                        item = item7.load();
                        if (aST16.type.mgb(aST15.type.tsym()) != null) break;
                        Gen.emitop2(192, Gen.mkref(aST15.type));
                        break;
                    }
                    item7.load();
                    Gen.emitop2(193, Gen.mkref(aST15.type));
                    item = StackItem.make(Type.booleanType);
                    break;
                }
                case 36: {
                    AST.Index index = (AST.Index)aST;
                    AST aST17 = index.index;
                    AST aST18 = index.indexed;
                    ByteCodeGen.genExpr(aST18, aST18.type).load();
                    ByteCodeGen.genExpr(aST17, Type.intType).load();
                    item = IndexedItem.make(aST.type);
                    break;
                }
                case 37: {
                    AST.Select select = (AST.Select)aST;
                    Symbol symbol = select.sym;
                    Name name = select.selector;
                    AST aST19 = select.selected;
                    if (name == Basic.classS) {
                        item = ByteCodeGen.genClassOf(aST19.type);
                        break;
                    }
                    if ((symbol.modifiers & 8) != 0) {
                        item = StaticItem.make(aST.pos, symbol);
                        break;
                    }
                    Symbol symbol2 = aST19.symbol();
                    boolean bl = symbol2 != null && (symbol2.kind == 2 || symbol2.name == Basic.superS);
                    boolean bl2 = symbol2 != null && (symbol2.kind == 2 || symbol2.name == Basic.thisS);
                    Item item8 = bl ? Item.superItem : ByteCodeGen.genExpr(aST19, aST19.type);
                    item8.load();
                    if (symbol == Symtab.lengthVar) {
                        Gen.emitop(190);
                        item = StackItem.make(Type.intType);
                        break;
                    }
                    item = MemberItem.make(aST.pos, symbol, (symbol.modifiers & 2) != 0 || bl, bl2);
                    break;
                }
                case 38: {
                    Symbol symbol = ((AST.Ident)aST).sym;
                    if (symbol == Symtab.nullConst) {
                        Gen.emitop(1);
                        item = StackItem.make(aST.type);
                        break;
                    }
                    if (symbol.kind == 4 && symbol.owner.kind == 8) {
                        item = LocalItem.make(aST.pos, (VarSymbol)symbol);
                        break;
                    }
                    if ((symbol.modifiers & 8) != 0) {
                        item = StaticItem.make(aST.pos, symbol);
                        break;
                    }
                    Item.thisItem.load();
                    item = MemberItem.make(aST.pos, symbol, (symbol.modifiers & 2) != 0, true);
                    break;
                }
                case 39: {
                    AST.Self self = (AST.Self)aST;
                    Symbol symbol = self.sym;
                    Name name = self.name;
                    AST aST20 = self.encl;
                    Basic.assert(aST20 == null);
                    Item item9 = item = name == Basic.thisS ? Item.thisItem : Item.superItem;
                    if (symbol.kind != 8) break;
                    item.load();
                    item = MemberItem.make(aST.pos, symbol, true, false);
                    break;
                }
                case 40: {
                    ConstType constType = ((AST.Literal)aST).value;
                    item = ImmediateItem.make(constType);
                    break;
                }
                default: {
                    throw new InternalError();
                }
            }
        }
        return item.coerce(type);
    }

    static void loadArgs(AST[] aSTArray, Type[] typeArray) {
        for (int i = 0; i < aSTArray.length; ++i) {
            ByteCodeGen.genExpr(aSTArray[i], typeArray[i]).load();
        }
    }

    ByteCodeGen() {
    }

    static /* synthetic */ void $closure$net$sf$pizzacompiler$compiler$ByteCodeGen$0s(Object[] objectArray) {
        Item item = (Item)objectArray[0];
        item.load();
        Gen.emitop(195);
    }

    static /* synthetic */ void $closure$net$sf$pizzacompiler$compiler$ByteCodeGen$1s(Object[] objectArray) {
        AST aST = (AST)objectArray[0];
        Env env = (Env)objectArray[1];
        ByteCodeGen.genStat(aST, env);
    }
}

