/*
 * Decompiled with CFR 0.152.
 */
package com.coyotegulch.jisp;

import com.coyotegulch.jisp.BTreeException;
import com.coyotegulch.jisp.BTreeSharedConstants;
import com.coyotegulch.jisp.BTreeSharedExceptions;
import com.coyotegulch.jisp.KeyObject;
import com.coyotegulch.jisp.PageFileHeader;
import com.coyotegulch.jisp.PageHeader;
import com.coyotegulch.jisp.StringKey;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

class Page
implements Externalizable,
BTreeSharedExceptions,
BTreeSharedConstants {
    static final long serialVersionUID = -8324209659131142291L;
    public PageHeader m_header;
    public KeyObject[] m_key;
    public long[] m_recPtr;
    public long[] m_link;

    public Page() {
        this.m_header = null;
        this.m_key = null;
        this.m_recPtr = null;
        this.m_link = null;
    }

    public Page(PageFileHeader pageFileHeader) throws BTreeException {
        this.m_header = new PageHeader();
        this.m_header.m_filePtr = -1L;
        this.m_header.m_parentPtr = -1L;
        this.m_header.m_numKeys = 0;
        this.m_key = new KeyObject[pageFileHeader.m_maxKeys];
        this.m_recPtr = new long[pageFileHeader.m_maxKeys];
        this.m_link = new long[pageFileHeader.m_order];
        int n = 0;
        while (n < pageFileHeader.m_order) {
            this.m_link[n] = -1L;
            ++n;
        }
        int n2 = 0;
        while (n2 < pageFileHeader.m_maxKeys) {
            this.m_recPtr[n2] = -1L;
            this.m_key[n2] = new StringKey("" + n2);
            ++n2;
        }
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        objectOutput.writeObject(this.m_header);
        objectOutput.writeObject(this.m_recPtr);
        objectOutput.writeObject(this.m_link);
        int n = 0;
        while (n < this.m_key.length) {
            objectOutput.writeObject(this.m_key[n]);
            ++n;
        }
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        this.m_header = (PageHeader)objectInput.readObject();
        this.m_recPtr = (long[])objectInput.readObject();
        this.m_link = (long[])objectInput.readObject();
        this.m_key = new KeyObject[this.m_recPtr.length];
        int n = 0;
        while (n < this.m_key.length) {
            this.m_key[n] = (KeyObject)objectInput.readObject();
            ++n;
        }
    }
}

