/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.mesa.rdf.jena.rdb;

import com.hp.hpl.mesa.rdf.jena.rdb.TestDBConnection;
import com.hp.hpl.mesa.rdf.jena.rdb.TestGenericDriver;
import com.hp.hpl.mesa.rdf.jena.rdb.TestJenaRegression;
import com.hp.hpl.mesa.rdf.jena.rdb.TestStoreRDB;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class TestRDB
extends TestCase {
    private static String TEST_LAYOUT = "Generic";
    private static String TEST_DB = "Generic";
    private static boolean fullRegression = false;

    public TestRDB(String string) {
        super(string);
    }

    public static TestSuite suite() {
        TestSuite testSuite = new TestSuite();
        testSuite.addTest((Test)TestDBConnection.suite(TEST_LAYOUT, TEST_DB));
        testSuite.addTest((Test)TestGenericDriver.suite(TEST_LAYOUT, TEST_DB));
        testSuite.addTest((Test)TestStoreRDB.suite(TEST_LAYOUT, TEST_DB));
        if (fullRegression) {
            testSuite.addTest((Test)TestJenaRegression.suite(TEST_LAYOUT, TEST_DB));
        }
        return testSuite;
    }

    public static void main(String[] stringArray) {
        if (stringArray.length < 2 || stringArray.length > 3) {
            System.out.println("Usage: : TestRDF layoutType databaseType [full]");
            System.exit(1);
        }
        TEST_LAYOUT = stringArray[0];
        TEST_DB = stringArray[1];
        if (stringArray.length == 3) {
            fullRegression = stringArray[2].equalsIgnoreCase("full");
        }
        try {
            if (System.getProperty("jena.rdb.test.dbbase") == null) {
                if (TEST_DB.equals("Mysql")) {
                    System.setProperty("jena.rdb.test.dbbase", "jdbc:mysql://morte.hpl.hp.com/");
                } else if (TEST_DB.equals("Postgresql")) {
                    System.setProperty("jena.rdb.test.dbbase", "jdbc:postgresql:");
                } else if (TEST_DB.equals("Interbase")) {
                    System.setProperty("jena.rdb.test.dbbase", "jdbc:interbase://reynolds-d-3.hpl.hp.com/c:/der/java/databases/");
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        TestRunner.run((Test)TestRDB.suite());
    }
}

