/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.mesa.rdf.jena.rdb;

import com.hp.hpl.jena.util.Log;
import com.hp.hpl.mesa.rdf.jena.rdb.IDBConnection;
import com.hp.hpl.mesa.rdf.jena.rdb.RDFRDBException;
import com.hp.hpl.mesa.rdf.jena.rdb.ResultSetIterator;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;

public class SQLCache {
    protected Properties m_sql;
    protected HashMap m_preparedStatements = new HashMap();
    protected IDBConnection m_connection;
    protected static final int MAX_PS_CACHE = 4;
    protected boolean CACHE_PREPARED_STATEMENTS = true;
    static /* synthetic */ Class class$com$hp$hpl$mesa$rdf$jena$rdb$SQLCache;

    public SQLCache(String string, Properties properties, IDBConnection iDBConnection, String string2) throws IOException {
        this.m_sql = SQLCache.loadSQLFile(string, properties, string2);
        this.m_connection = iDBConnection;
    }

    public void setCachePreparedStatements(boolean bl) {
        this.CACHE_PREPARED_STATEMENTS = bl;
    }

    public boolean getCachePreparedStatements() {
        return this.CACHE_PREPARED_STATEMENTS;
    }

    public void flushPreparedStatementCache() throws RDFRDBException {
        try {
            try {
                Iterator iterator = this.m_preparedStatements.values().iterator();
                while (iterator.hasNext()) {
                    Iterator iterator2 = ((List)iterator.next()).iterator();
                    while (iterator2.hasNext()) {
                        ((PreparedStatement)iterator2.next()).close();
                    }
                }
            }
            catch (SQLException sQLException) {
                throw new RDFRDBException("Problem flushing PS cache", (Exception)sQLException);
            }
            Object var4_4 = null;
            this.m_preparedStatements = new HashMap();
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            this.m_preparedStatements = new HashMap();
            throw throwable;
        }
    }

    public Connection getConnection() throws SQLException {
        return this.m_connection.getConnection();
    }

    public void setConnection(IDBConnection iDBConnection) {
        this.m_connection = iDBConnection;
    }

    public String getSQLStatement(String string) {
        return this.m_sql.getProperty(string);
    }

    public String getSQLStatement(String string, String string2) {
        return SQLCache.substitute(this.m_sql.getProperty(string), "${a}", string2);
    }

    public Collection getSQLStatementGroup(String string) throws SQLException {
        String string2 = this.m_sql.getProperty(string);
        if (string2 == null) {
            throw new SQLException("Unable to find SQL for operation: " + string);
        }
        int n = 0;
        int n2 = 0;
        LinkedList<String> linkedList = new LinkedList<String>();
        while (n2 != -1) {
            n2 = string2.indexOf(";;\n", n);
            String string3 = null;
            if (n2 == -1) {
                string3 = string2.substring(n);
            } else {
                string3 = string2.substring(n, n2);
                n = n2 + 2;
            }
            if (string3.trim().equals("")) continue;
            linkedList.add(string3);
        }
        return linkedList;
    }

    public synchronized PreparedStatement getPreparedSQLStatement(String string) throws SQLException {
        if (this.m_connection == null || string == null) {
            return null;
        }
        List list = (List)this.m_preparedStatements.get(string);
        if (list == null || list.isEmpty()) {
            String string2 = this.getSQLStatement(string);
            if (string2 == null) {
                throw new SQLException("No SQL defined for operation: " + string);
            }
            if (list == null && this.CACHE_PREPARED_STATEMENTS) {
                this.m_preparedStatements.put(string, new LinkedList());
            }
            return this.getConnection().prepareStatement(string2);
        }
        return (PreparedStatement)list.remove(0);
    }

    public synchronized PreparedStatement getPreparedSQLStatement(String string, String string2) throws SQLException {
        if (this.m_connection == null || string == null) {
            return null;
        }
        String string3 = string + string2;
        List list = (List)this.m_preparedStatements.get(string3);
        if (list == null || list.isEmpty()) {
            String string4 = this.getSQLStatement(string, string2);
            if (string4 == null) {
                throw new SQLException("No SQL defined for operation: " + string);
            }
            if (list == null && this.CACHE_PREPARED_STATEMENTS) {
                this.m_preparedStatements.put(string3, new LinkedList());
            }
            return this.getConnection().prepareStatement(string4);
        }
        return (PreparedStatement)list.remove(0);
    }

    public synchronized void returnPreparedSQLStatement(PreparedStatement preparedStatement, String string) {
        if (!this.CACHE_PREPARED_STATEMENTS) {
            try {
                preparedStatement.close();
            }
            catch (SQLException sQLException) {
                Log.warning("Problem discarded prepared statement", sQLException);
            }
            return;
        }
        LinkedList<PreparedStatement> linkedList = (LinkedList<PreparedStatement>)this.m_preparedStatements.get(string);
        if (linkedList == null) {
            linkedList = new LinkedList<PreparedStatement>();
            this.m_preparedStatements.put(string, linkedList);
        }
        if (linkedList.size() >= 4) {
            try {
                preparedStatement.close();
            }
            catch (SQLException sQLException) {
                Log.warning("Problem discarded prepared statement", sQLException);
            }
        } else {
            linkedList.add(preparedStatement);
        }
    }

    public ResultSetIterator runSQLQuery(String string, Object[] objectArray) throws SQLException {
        PreparedStatement preparedStatement = this.getPreparedSQLStatement(string);
        if (objectArray != null) {
            int n = 0;
            while (n < objectArray.length) {
                preparedStatement.setObject(n + 1, objectArray[n]);
                ++n;
            }
        }
        return this.executeSQL(preparedStatement, string, new ResultSetIterator());
    }

    public ResultSetIterator runSQLQuery(String string, Object[] objectArray, ResultSetIterator resultSetIterator) throws SQLException {
        PreparedStatement preparedStatement = this.getPreparedSQLStatement(string);
        if (objectArray != null) {
            int n = 0;
            while (n < objectArray.length) {
                preparedStatement.setObject(n + 1, objectArray[n]);
                ++n;
            }
        }
        return this.executeSQL(preparedStatement, string, resultSetIterator);
    }

    public void runSQLGroup(String string) throws SQLException {
        String string2 = null;
        SQLException sQLException = null;
        String string3 = null;
        Statement statement = this.getConnection().createStatement();
        Iterator iterator = this.getSQLStatementGroup(string).iterator();
        while (iterator.hasNext()) {
            string2 = (String)iterator.next();
            try {
                statement.execute(string2);
            }
            catch (SQLException sQLException2) {
                string3 = string2;
                sQLException = sQLException2;
            }
        }
        statement.close();
        if (sQLException != null) {
            throw sQLException;
        }
    }

    public void close() throws SQLException {
        Iterator iterator = this.m_preparedStatements.values().iterator();
        while (iterator.hasNext()) {
            List list = (List)iterator.next();
            Iterator iterator2 = list.iterator();
            while (iterator2.hasNext()) {
                PreparedStatement preparedStatement = (PreparedStatement)iterator2.next();
                preparedStatement.close();
            }
            iterator.remove();
        }
    }

    public static Properties loadSQLFile(String string, Properties properties, String string2) throws IOException {
        Properties properties2 = new Properties(properties);
        BufferedReader bufferedReader = SQLCache.openResourceFile(string);
        String string3 = null;
        while ((string3 = bufferedReader.readLine()) != null) {
            if (string3.startsWith("#")) continue;
            String string4 = string3.trim();
            StringBuffer stringBuffer = new StringBuffer();
            while (true) {
                if ((string3 = bufferedReader.readLine()) == null || string3.trim().equals("")) break;
                if (string3.startsWith("#")) continue;
                stringBuffer.append(SQLCache.substitute(string3.trim(), "${id}", string2));
                stringBuffer.append("\n");
            }
            properties2.setProperty(string4, stringBuffer.toString());
            if (string3 != null) continue;
        }
        return properties2;
    }

    public static String substitute(String string, String string2, String string3) {
        int n = string.indexOf(string2);
        if (n != -1) {
            return string.substring(0, n) + string3 + SQLCache.substitute(string.substring(n + string2.length()), string2, string3);
        }
        return string;
    }

    protected Properties getSQLTable() {
        return this.m_sql;
    }

    public static BufferedReader openResourceFile(String string) throws IOException {
        InputStream inputStream = (class$com$hp$hpl$mesa$rdf$jena$rdb$SQLCache == null ? (class$com$hp$hpl$mesa$rdf$jena$rdb$SQLCache = SQLCache.class$("com.hp.hpl.mesa.rdf.jena.rdb.SQLCache")) : class$com$hp$hpl$mesa$rdf$jena$rdb$SQLCache).getClassLoader().getResourceAsStream(string);
        if (inputStream == null) {
            throw new IOException("Can't open resource " + string);
        }
        return new BufferedReader(new InputStreamReader(inputStream, "US-ASCII"));
    }

    protected ResultSetIterator executeSQL(PreparedStatement preparedStatement, String string, ResultSetIterator resultSetIterator) throws SQLException {
        if (preparedStatement.execute()) {
            ResultSet resultSet = preparedStatement.getResultSet();
            resultSetIterator.reset(resultSet, preparedStatement, this, string);
            return resultSetIterator;
        }
        this.returnPreparedSQLStatement(preparedStatement, string);
        return null;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

