/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.mesa.rdf.jena.mem;

import com.hp.hpl.mesa.rdf.jena.common.ErrorHelper;
import com.hp.hpl.mesa.rdf.jena.common.NsIteratorImpl;
import com.hp.hpl.mesa.rdf.jena.common.ResIteratorImpl;
import com.hp.hpl.mesa.rdf.jena.common.ResourceImpl;
import com.hp.hpl.mesa.rdf.jena.common.Store;
import com.hp.hpl.mesa.rdf.jena.common.StoreCom;
import com.hp.hpl.mesa.rdf.jena.model.Model;
import com.hp.hpl.mesa.rdf.jena.model.NsIterator;
import com.hp.hpl.mesa.rdf.jena.model.Property;
import com.hp.hpl.mesa.rdf.jena.model.RDFException;
import com.hp.hpl.mesa.rdf.jena.model.RDFNode;
import com.hp.hpl.mesa.rdf.jena.model.ResIterator;
import com.hp.hpl.mesa.rdf.jena.model.Resource;
import com.hp.hpl.mesa.rdf.jena.model.Statement;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;

class StoreMem
extends StoreCom
implements Store {
    HashSet statements = new HashSet();
    NodeMap subjects = new NodeMap();
    NodeMap predicates = new NodeMap();
    NodeMap objects = new NodeMap();

    public Resource getResource(String string, Model model) throws RDFException {
        ResourceImpl resourceImpl = new ResourceImpl(string, model);
        Statement statement = this.subjects.getFirst(resourceImpl);
        if (statement != null) {
            return statement.getSubject();
        }
        statement = this.objects.getFirst(resourceImpl);
        if (statement != null) {
            return (Resource)statement.getObject();
        }
        statement = this.predicates.getFirst(resourceImpl);
        if (statement != null) {
            return statement.getPredicate();
        }
        return resourceImpl;
    }

    public Property getProperty(Property property) {
        Statement statement = this.predicates.getFirst(property);
        if (statement != null) {
            return statement.getPredicate();
        }
        return property;
    }

    public synchronized void add(Statement statement) throws RDFException {
        if (this.statements.contains(statement)) {
            return;
        }
        this.statements.add(statement);
        this.subjects.add(statement.getSubject(), statement);
        this.predicates.add(statement.getPredicate(), statement);
        this.objects.add(statement.getObject(), statement);
    }

    public synchronized void remove(Statement statement) throws RDFException {
        this.statements.remove(statement);
        this.subjects.remove(statement.getSubject(), statement);
        this.predicates.remove(statement.getPredicate(), statement);
        this.objects.remove(statement.getObject(), statement);
    }

    public synchronized int size() throws RDFException {
        return this.statements.size();
    }

    public synchronized boolean contains(Statement statement) throws RDFException {
        return this.statements.contains(statement);
    }

    public synchronized boolean contains(Resource resource, Property property) throws RDFException {
        Iterator iterator = null;
        iterator = this.listBySubject(resource);
        while (iterator.hasNext()) {
            if (!((Statement)iterator.next()).getPredicate().equals(property)) continue;
            return true;
        }
        return false;
    }

    public synchronized Iterator list() throws RDFException {
        return this.statements.iterator();
    }

    public synchronized Iterator list(Resource resource, Property property, RDFNode rDFNode) throws RDFException {
        if (resource != null) {
            return this.listBySubject(resource);
        }
        if (rDFNode != null) {
            return this.listByObject(rDFNode);
        }
        if (property != null) {
            return this.listByPredicate(property);
        }
        return this.list();
    }

    public synchronized Iterator listBySubject(Resource resource) {
        return this.subjects.iterator(resource);
    }

    public synchronized Iterator listByPredicate(Property property) {
        return this.predicates.iterator(property);
    }

    public synchronized Iterator listByObject(RDFNode rDFNode) {
        return this.objects.iterator(rDFNode);
    }

    public synchronized ResIterator listSubjects() throws RDFException {
        try {
            HashSet<Resource> hashSet = new HashSet<Resource>();
            Iterator iterator = this.subjects.listFirstStatements();
            while (iterator.hasNext()) {
                hashSet.add(((Statement)iterator.next()).getSubject());
            }
            return new ResIteratorImpl(hashSet.iterator(), hashSet);
        }
        catch (Exception exception) {
            ErrorHelper.logInternalError(this.getClass().getName(), 1, exception);
            throw new RDFException(exception);
        }
    }

    public synchronized NsIterator listNameSpaces() throws RDFException {
        try {
            HashSet<String> hashSet = new HashSet<String>();
            Iterator iterator = this.predicates.listFirstStatements();
            while (iterator.hasNext()) {
                hashSet.add(((Statement)iterator.next()).getPredicate().getNameSpace());
            }
            return new NsIteratorImpl(hashSet.iterator(), hashSet);
        }
        catch (Exception exception) {
            ErrorHelper.logInternalError(this.getClass().getName(), 2, exception);
            throw new RDFException(exception);
        }
    }

    protected class NodeMap {
        HashMap map = new HashMap();

        protected NodeMap() {
        }

        protected void add(RDFNode rDFNode, Statement statement) {
            LinkedList<Statement> linkedList = (LinkedList<Statement>)this.map.get(rDFNode);
            if (linkedList == null) {
                linkedList = new LinkedList<Statement>();
                this.map.put(rDFNode, linkedList);
            }
            linkedList.add(statement);
        }

        protected void remove(RDFNode rDFNode, Statement statement) {
            LinkedList linkedList = (LinkedList)this.map.get(rDFNode);
            if (linkedList != null) {
                linkedList.remove(statement);
                if (linkedList.size() == 0) {
                    this.map.put(rDFNode, null);
                }
            }
        }

        protected Iterator iterator(RDFNode rDFNode) {
            LinkedList linkedList = (LinkedList)this.map.get(rDFNode);
            if (linkedList == null) {
                return new LinkedList().iterator();
            }
            return linkedList.iterator();
        }

        protected Statement getFirst(RDFNode rDFNode) {
            LinkedList linkedList = (LinkedList)this.map.get(rDFNode);
            if (linkedList == null) {
                return null;
            }
            return (Statement)linkedList.getFirst();
        }

        protected Iterator listFirstStatements() {
            HashSet<Statement> hashSet = new HashSet<Statement>();
            Iterator iterator = this.map.values().iterator();
            while (iterator.hasNext()) {
                LinkedList linkedList = (LinkedList)iterator.next();
                if (linkedList == null) continue;
                hashSet.add((Statement)linkedList.getFirst());
            }
            return hashSet.iterator();
        }
    }
}

