/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.mesa.rdf.jena.bdb;

import com.hp.hpl.jena.util.Log;
import com.hp.hpl.mesa.rdf.jena.common.LiteralImpl;
import com.hp.hpl.mesa.rdf.jena.common.PropertyImpl;
import com.hp.hpl.mesa.rdf.jena.common.ResourceImpl;
import com.hp.hpl.mesa.rdf.jena.model.AnonId;
import com.hp.hpl.mesa.rdf.jena.model.Literal;
import com.hp.hpl.mesa.rdf.jena.model.Model;
import com.hp.hpl.mesa.rdf.jena.model.Property;
import com.hp.hpl.mesa.rdf.jena.model.RDFError;
import com.hp.hpl.mesa.rdf.jena.model.RDFException;
import com.hp.hpl.mesa.rdf.jena.model.RDFNode;
import com.hp.hpl.mesa.rdf.jena.model.Resource;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public abstract class ByteSerializer {
    protected static final byte ANONRESOURCETYPE = 1;
    protected static final byte URIRESOURCETYPE = 2;
    protected static final byte WELLFORMEDLITERALTYPE = 3;
    protected static final byte LITERALTYPE = 4;
    protected static final byte PROPERTYTYPE = 5;

    protected static void toData(RDFNode rDFNode, DataOutputStream dataOutputStream) throws IOException {
        if (rDFNode instanceof Property) {
            Property property = (Property)rDFNode;
            dataOutputStream.writeByte(5);
            dataOutputStream.writeUTF(property.getNameSpace());
            dataOutputStream.writeUTF(property.getLocalName());
        } else if (rDFNode instanceof Resource) {
            Resource resource = (Resource)rDFNode;
            if (resource.isAnon()) {
                dataOutputStream.writeByte(1);
                try {
                    dataOutputStream.writeUTF(resource.getId().toString());
                }
                catch (RDFException rDFException) {
                    Log.severe("failed getId failed", "ByteSerializer", "toData", rDFException);
                    throw new RDFError(rDFException);
                }
            } else {
                dataOutputStream.writeByte(2);
                dataOutputStream.writeUTF(resource.getURI());
            }
        } else {
            Literal literal = (Literal)rDFNode;
            if (literal.getWellFormed()) {
                dataOutputStream.writeByte(3);
            } else {
                dataOutputStream.writeByte(4);
            }
            try {
                dataOutputStream.writeUTF(literal.getString());
                dataOutputStream.writeUTF(literal.getLanguage());
            }
            catch (RDFException rDFException) {
                Log.severe("failed to get literal", "ByteSerializer", "toData", rDFException);
                throw new RDFError(rDFException);
            }
        }
    }

    protected static byte[] toBytes(RDFNode rDFNode) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        try {
            ByteSerializer.toData(rDFNode, dataOutputStream);
        }
        catch (IOException iOException) {
            Log.severe("toData failed", "ByteSerializer", "toData", iOException);
            throw new RDFError(iOException);
        }
        try {
            dataOutputStream.flush();
        }
        catch (Exception exception) {
            Log.severe("failed to flush bytestream", "ByteSerializer", "toBytes", exception);
            throw new RDFError(exception);
        }
        return byteArrayOutputStream.toByteArray();
    }

    protected static RDFNode fromData(DataInputStream dataInputStream, Model model) throws IOException {
        try {
            byte by = dataInputStream.readByte();
            switch (by) {
                case 1: {
                    return new ResourceImpl(new AnonId(dataInputStream.readUTF()), model);
                }
                case 2: {
                    return new ResourceImpl(dataInputStream.readUTF(), model);
                }
                case 3: {
                    return new LiteralImpl(dataInputStream.readUTF(), dataInputStream.readUTF(), true);
                }
                case 4: {
                    return new LiteralImpl(dataInputStream.readUTF(), dataInputStream.readUTF());
                }
                case 5: {
                    return new PropertyImpl(dataInputStream.readUTF(), dataInputStream.readUTF(), model);
                }
            }
            Log.severe("Internal Error, type = " + by, "ByteSerializer", "fromData");
            throw new RDFError("Internal Error in ByteSerializer.fromData");
        }
        catch (RDFException rDFException) {
            Log.severe("Internal Error", "ByteSerializer", "fromData", rDFException);
            throw new RDFError(rDFException);
        }
    }
}

