/*
 * Decompiled with CFR 0.152.
 */
package org.jfor.jfor.rtflib.rtfdoc;

import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Writer;
import org.jfor.jfor.converter.ConverterLogChannel;
import org.jfor.jfor.rtflib.exceptions.RtfStructureException;
import org.jfor.jfor.rtflib.rtfdoc.RtfAttributes;
import org.jfor.jfor.rtflib.rtfdoc.RtfContainer;
import org.jfor.jfor.rtflib.rtfdoc.RtfDocumentArea;
import org.jfor.jfor.rtflib.rtfdoc.RtfHeader;
import org.jfor.jfor.rtflib.rtfdoc.RtfListTable;
import org.jfor.jfor.rtflib.rtfdoc.RtfPageArea;
import org.jfor.jfor.rtflib.rtfdoc.RtfParagraph;
import org.jfor.jfor.rtflib.rtfdoc.RtfSection;

public class RtfFile
extends RtfContainer {
    private RtfHeader m_header;
    private RtfPageArea m_pageArea;
    private RtfListTable m_listTable;
    private RtfDocumentArea m_docArea;
    private ConverterLogChannel m_log;
    private RtfContainer m_listTableContainer;
    private int listNum = 0;

    public RtfFile(Writer writer) throws IOException {
        super(null, writer);
    }

    public void setLogChannel(ConverterLogChannel converterLogChannel) {
        this.m_log = converterLogChannel;
    }

    ConverterLogChannel getLog() {
        if (this.m_log == null) {
            this.m_log = new ConverterLogChannel(null);
        }
        return this.m_log;
    }

    public RtfHeader startHeader() throws IOException {
        if (this.m_header != null) {
            throw new RtfStructureException("startHeader called more than once");
        }
        this.m_header = new RtfHeader(this, this.m_writer);
        this.m_listTableContainer = new RtfContainer(this, this.m_writer);
        return this.m_header;
    }

    public RtfListTable startListTable(RtfAttributes rtfAttributes) throws IOException {
        ++this.listNum;
        this.m_listTable = new RtfListTable(this, this.m_writer, new Integer(this.listNum), rtfAttributes);
        this.m_listTableContainer.addChild(this.m_listTable);
        return this.m_listTable;
    }

    public RtfPageArea startPageArea() throws IOException, RtfStructureException {
        if (this.m_pageArea != null) {
            throw new RtfStructureException("startPageArea called more than once");
        }
        if (this.m_header == null) {
            this.startHeader();
        }
        this.m_header.close();
        this.m_pageArea = new RtfPageArea(this, this.m_writer);
        this.addChild(this.m_pageArea);
        return this.m_pageArea;
    }

    public RtfPageArea getPageArea() throws IOException, RtfStructureException {
        if (this.m_pageArea == null) {
            return this.startPageArea();
        }
        return this.m_pageArea;
    }

    public RtfDocumentArea startDocumentArea() throws IOException, RtfStructureException {
        if (this.m_docArea != null) {
            throw new RtfStructureException("startDocumentArea called more than once");
        }
        if (this.m_header == null) {
            this.startHeader();
        }
        this.m_header.close();
        this.m_docArea = new RtfDocumentArea(this, this.m_writer);
        this.addChild(this.m_docArea);
        return this.m_docArea;
    }

    public RtfDocumentArea getDocumentArea() throws IOException, RtfStructureException {
        if (this.m_docArea == null) {
            return this.startDocumentArea();
        }
        return this.m_docArea;
    }

    protected void writeRtfPrefix() throws IOException {
        this.writeGroupMark(true);
        this.writeControlWord("rtf1");
    }

    protected void writeRtfSuffix() throws IOException {
        this.writeGroupMark(false);
    }

    public synchronized void flush() throws IOException {
        this.writeRtf();
        this.m_writer.flush();
    }

    public static void main(String[] stringArray) throws Exception {
        Object object;
        BufferedWriter bufferedWriter = null;
        if (stringArray.length != 0) {
            object = stringArray[0];
            System.err.println("Outputting RTF to file '" + (String)object + "'");
            bufferedWriter = new BufferedWriter(new FileWriter((String)object));
        } else {
            System.err.println("Outputting RTF code to standard output");
            bufferedWriter = new BufferedWriter(new OutputStreamWriter(System.out));
        }
        object = new RtfFile(bufferedWriter);
        RtfSection rtfSection = ((RtfFile)object).startDocumentArea().newSection();
        RtfParagraph rtfParagraph = rtfSection.newParagraph();
        rtfParagraph.newText("Hello, RTF world.\n", null);
        RtfAttributes rtfAttributes = new RtfAttributes();
        rtfAttributes.set("b");
        rtfAttributes.set("i");
        rtfAttributes.set("fs", 36);
        rtfParagraph.newText("This is bold, italic, 36 points", rtfAttributes);
        ((RtfFile)object).flush();
        System.err.println("RtfFile test: all done.");
    }
}

