------------------------------------------------------------------------------
-- RAPID is free software;  you can  redistribute it  and/or modify
-- it under terms of the  GNU General Public License as published
-- by the Free Software  Foundation;  either version 2,  or (at your
-- option) any later version.  RAPID is distributed in the hope that
-- it will be useful, but WITHOUT ANY WARRANTY;  without even the
-- implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
-- PURPOSE.  See the GNU General Public License for more details.
-- You should have  received  a copy of the GNU General Public License
-- distributed with RAPID; see file COPYING.  If not, write to the
-- Free Software Foundation,  59 Temple Place - Suite 330,  Boston,
-- MA 02111-1307, USA.
--
-- As a special exception, if other files instantiate generics from
-- this unit, or you link this unit with other files to produce an
-- executable, this unit does not by itself cause the resulting
-- executable to be covered by the GNU General Public License.
-- This exception does not however invalidate any other reasons
-- why the executable file might be covered by the GNU Public
-- License.  This exception does not apply to executables which
-- are GUI design tools, or that could act as a replacement
-- for RAPID.
------------------------------------------------------------------------------
-- Copyright (C) 1999, Martin C. Carlisle <carlislem@acm.org>
--
-- contribution by Frederic Abiven to work around 3.10p bug
--
-- extended to allow two different types of lookup by Martin C. Carlisle
-- one string and one generic
with Lists_Generic;
with Lists_Generic.Key;
with Lists_Generic.Generic_Key;

generic

   type Element is private;
   with function GetKey (Item : in Element) return String;
   type Key2type is private;
   with function GetKey2 (Item : in Element) return Key2type;

package Lists_Generic_2Keys is

   package List_Package is new Lists_Generic (Element);

   package List_Package_Key is new List_Package.Key (GetKey);

   package List_Package_Key2 is new List_Package.Generic_Key (
      Key2type,
      GetKey2);
end Lists_Generic_2Keys;
