---------------------------------------------------------------
--
--  RAPID - Rapid Ada Portable Interface Designer
--
--  MCC.TEXT_ENTRY_TYPES
--  Description : specifies types for auto-fill of Text_Entry
--
--  Copyright (C) 2000, Martin C. Carlisle <carlislem@acm.org>
--
-- RAPID is free software; you can redistribute it and/or
-- modify it without restriction.  However, we ask that you
-- please retain the original author information, and clearly
-- indicate if it has been modified.
--
-- RAPID is distributed in the hope that it will be useful,
-- but WITHOUT ANY WARRANTY; without even the implied warranty
-- of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
--
-- As a special exception, if other files instantiate generics from
-- this unit, or you link this unit with other files to produce an
-- executable, this unit does not by itself cause the resulting
-- executable to be covered by the GNU General Public License.
-- This exception does not however invalidate any other reasons
-- why the executable file might be covered by the GNU Public
-- License.
---------------------------------------------------------------
with Ada.Float_Text_IO;
with Ada.Strings.Fixed;
package body mcc.text_entry_types is

   -----------
   -- Image --
   -----------

   function Image (data : in Interfaces.Unsigned_32) return String is
      x : String := Interfaces.Unsigned_32'Image (data);
   begin
      if x (x'First) = ' ' then
         return x (x'First + 1 .. x'Last);
      else
         return x;
      end if;
   end Image;

   -----------
   -- Image --
   -----------

   function Image (data : in Float; base : in Float_Types) return String is
   begin
      case base is
         -- return just the image removing a leading space.
         when Float_E =>
            declare
               x : String := Float'Image (data);
            begin
               if x (x'First) = ' ' then
                  return x (x'First + 1 .. x'Last);
               else
                  return x;
               end if;
            end;
         when others =>
            -- print to a string, then return the relevant (non-blank)
            -- portion
            declare
               x     : String (1 .. 80);
               first : Natural;
            begin
               Ada.Float_Text_IO.Put
                 (To   => x,
                  Item => data,
                  Aft  => Base_Type'Pos (base) -
                          Base_Type'Pos (Float_1) +
                          1,
                  Exp  => 0);
               first := Ada.Strings.Fixed.Index_Non_Blank (x);
               return x (first .. x'Last);
            end;
      end case;
   end Image;

end mcc.text_entry_types;
