-------------------------------------------------------------------
--           RAPID - RAPID ADA PORTABLE INTERFACE DESIGNER
--           MCC GUI PACKAGE LIBRARY
--           Copyright (C) 1999 Martin C. Carlisle.
--
-- RAPID is free software; you can redistribute it and/or modify
-- it under terms of the GNU General Public License as published
-- by the Free Software Foundation; either version 2, or (at your
-- option) any later version.  RAPID is distributed in the hope that
-- it will be useful, but WITHOUT ANY WARRANTY; without even the
-- implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
-- PURPOSE.  See the GNU General Public License for more details.
-- You should have received a copy of the GNU General Public License
-- distributed with RAPID; see file COPYING.  If not, write to the
-- Free Software Foundation,  59 Temple Place - Suite 330,  Boston,
-- MA 02111-1307, USA.
--
-- As a special exception, if other files instantiate generics from
-- this unit, or you link this unit with other files to produce an
-- executable, this unit does not by itself cause the resulting
-- executable to be covered by the GNU General Public License.
-- This exception does not however invalidate any other reasons
-- why the executable file might be covered by the GNU Public
-- License.  This exception does not apply to executables which
-- are GUI design tools, or that could act as a replacement
-- for RAPID.
------------------------------------------------------------------------------
with Gdk;
with Gdk.Types;
with Gdk.Types.Keysyms;
with Gdk.Drawable;
with Gdk.Window;
with Gdk.Event;
with Glib;
with Gtk.Accel_Group;
with Gtk.Box;
with Gtk.Fixed;
with Gtk.Drawing_Area;
with Gtk.Menu;
with Gtk.Menu_Item;
with Gtk.Menu_Bar;
with Gtk.Label;
with Gtk.Object;
with Gtk.Widget;
with Gtk.Window;
with mcc.Gtk_Signals;
with mcc.Gui.Container.Window;
with mcc.Gui.Window_Peer;
with peer.Frame;               use peer.Frame;
with System;
with Ada.Text_IO;
with Ada.Characters.Handling;  use Ada.Characters.Handling;
package body mcc.Gui.Menu is

   type mcc_menu_bar_record is new Gtk.Menu_Bar.Gtk_Menu_Bar_Record with
      record
         Accel_Group : Gtk.Accel_Group.Gtk_Accel_Group;
         Is_Frame    : Boolean := True;
         First_One   : Boolean := True;
         Vbox        : Gtk.Box.Gtk_Vbox;
      end record;
   type mcc_menu_bar is access all mcc_menu_bar_record'Class;

   type mcc_menu_record is new Gtk.Menu.Gtk_Menu_Record with record
      Accel_Group  : Gtk.Accel_Group.Gtk_Accel_Group;
      submenu_item : Gtk.Menu_Item.Gtk_Menu_Item;
   end record;
   type mcc_menu is access all mcc_menu_record'Class;

   type mcc_menu_item_record is new Gtk.Menu_Item.Gtk_Menu_Item_Record with
      record
         Accel_Group : Gtk.Accel_Group.Gtk_Accel_Group;
      end record;
   type mcc_menu_item is access all mcc_menu_item_record'Class;

   procedure Set_Menu_Item_Pattern
     (Submenu_Item : in Gtk.Menu_Item.Gtk_Menu_Item;
      Text         : in String;
      Underline    : in Natural)
   is
      Label    : Gtk.Label.Gtk_Label;
      Children : Gtk.Widget.Widget_List.Glist;
      use Gtk.Widget;
      Underlines: String (1 .. Text'Length) := (others => ' ');
   begin
      if Underline > 0 and Underline <= Text'Length then
         Underlines (Underline) := '_';
      else
         return;
      end if;

      Children := Gtk.Menu_Item.Children (Submenu_Item);
      -- all good C programmers have a 0th child
      Label    :=
        Gtk.Label.Gtk_Label (Gtk.Widget.Widget_List.Nth_Data (Children, 0));
      Gtk.Label.Set_Pattern (Label, Underlines);
   end Set_Menu_Item_Pattern;

   procedure Get_Keystroke
     (Accelerator : in String;
      Keycode     : out Gdk.Types.Gdk_Key_Type;
      Modifier    : out Gdk.Types.Gdk_Modifier_Type)
   is
      use type Gdk.Types.Gdk_Modifier_Type;
      function Get_Keycode (Key : in String) return Gdk.Types.Gdk_Key_Type is
         use type Gdk.Types.Gdk_Key_Type;
      begin
         if Ada.Characters.Handling.To_Upper (Key (Key'First)) = 'F' and
            Key'Length > 1
         then
            return Gdk.Types.Gdk_Key_Type'Value
                      (Key (Key'First + 1 .. Key'Last)) +
                   Gdk.Types.Keysyms.GDK_F1 -
                   1;
         else
            return Gdk.Types.Gdk_Key_Type (Character'Pos (Key (Key'First)));
         end if;
      end Get_Keycode;

   begin
      if Accelerator'Length > 5
        and then Ada.Characters.Handling.To_Lower
                    (Accelerator (Accelerator'First .. Accelerator'First + 4))
                 =
                 "ctrl+"
      then
         Modifier := Gdk.Types.Control_Mask;
         Keycode  :=
            Get_Keycode
              (Accelerator (Accelerator'First + 5 .. Accelerator'Last));
      elsif Accelerator'Length > 4
        and then Ada.Characters.Handling.To_Lower
                    (Accelerator (Accelerator'First .. Accelerator'First + 3))
                 =
                 "alt+"
      then
         Modifier := Gdk.Types.Mod1_Mask;
         Keycode  :=
            Get_Keycode
              (Accelerator (Accelerator'First + 4 .. Accelerator'Last));
      elsif Accelerator'Length > 2
        and then Ada.Characters.Handling.To_Lower
                    (Accelerator (Accelerator'First .. Accelerator'First + 2))
                 =
                 "del"
      then
         Modifier := 0;
         Keycode  := Gdk.Types.Keysyms.GDK_Delete;
      elsif Accelerator'Length > 2
        and then Ada.Characters.Handling.To_Lower
                    (Accelerator (Accelerator'First .. Accelerator'First + 2))
                 =
                 "ins"
      then
         Modifier := 0;
         Keycode  := Gdk.Types.Keysyms.GDK_Insert;
      else
         Modifier := 0;
         Keycode  := Get_Keycode (Accelerator);
      end if;

   end Get_Keystroke;

   procedure Add_Choice_Common
     (Obj         : in out Choice;
      To_Menu     : in Menu'Class;
      Text        : in String;
      Action      : in Menu_Callback;
      Underline   : in Natural;
      Accelerator : in String;
      Item        : in Gtk.Menu_Item.Gtk_Menu_Item)
   is
      Keycode  : Gdk.Types.Gdk_Key_Type;
      Modifier : Gdk.Types.Gdk_Modifier_Type;
   begin
      Set_Menu_Item_Pattern
        (Submenu_Item => Item,
         Text         => Text,
         Underline    => Underline);

      -- @todo port to new gtk
      --if Accelerator /= "" then
      --   Get_Keystroke(
      --      Accelerator => Accelerator,
      --      Keycode     => Keycode,
      --      Modifier    => Modifier);
      --
      --   gtk.accel_group.unlock(
      --      Mcc_Menu(To_Menu.My_Peer).accel_group);
      --   gtk.menu_item.Add_Accelerator(
      --      Widget       => item,
      --      Accel_Signal => "activate",
      --      Accel_Group  => Mcc_Menu(To_Menu.My_Peer).accel_group,
      --      Accel_Key    => keycode,
      --      Accel_Mods   => modifier,
      --      Accel_Flags  => Gtk.Accel_Group.Accel_Visible);
      --   gtk.accel_group.lock(
      --      Mcc_Menu(To_Menu.My_Peer).accel_group);
      --end if;
      --
      --if Underline > 0 then
      --   gtk.menu_item.Add_Accelerator(
      --      Widget       => item,
      --      Accel_Signal => "activate",
      --      Accel_Group  => Ensure_Uline_Accel_Group(
      --         Mcc_Menu(To_Menu.My_Peer)),
      --      Accel_Key    => Gdk.Types.Gdk_Key_Type(
      --         Character'Pos(To_Lower(Text(Underline)))),
      --      Accel_Mods   => 0,
      --      Accel_Flags  => Gtk.Accel_Group.Accel_Locked);
      --end if;

      if Action /= null then
         mcc.Gtk_Signals.Gtk_Signal_Void_Connect
           (Item,
            "activate",
            mcc.Gtk_Signals.Void_Callback (Action));
      else
         Ada.Text_IO.Put_Line
           ("Mcc.Gui.Menu.Add_Choice_Common: Action is null !");
      end if;
      Obj.My_Peer := Gtk.Object.Gtk_Object (Item);
   end Add_Choice_Common;
   ----------------
   -- Add_Choice --
   ----------------

   procedure Add_Choice
     (Obj         : in out Choice;
      To_Menu     : in Menu'Class;
      Text        : in String;
      Action      : in Menu_Callback;
      Underline   : in Natural;
      Accelerator : in String := "")
   is
      Item : Gtk.Menu_Item.Gtk_Menu_Item;
   begin
      Gtk.Menu_Item.Gtk_New (Item, Text);
      Gtk.Menu.Append (Gtk.Menu.Gtk_Menu (To_Menu.My_Peer), Item);
      Gtk.Menu_Item.Show (Item);

      Add_Choice_Common
        (Obj         => Obj,
         To_Menu     => To_Menu,
         Text        => Text,
         Action      => Action,
         Underline   => Underline,
         Accelerator => Accelerator,
         Item        => Item);
   end Add_Choice;

   ----------------
   -- Add_Choice --
   ----------------

   procedure Add_Choice
     (Obj         : in out Choice;
      To_Menu     : in Menu'Class;
      Text        : in String;
      Action      : in Menu_Callback;
      Underline   : in Natural;
      Location    : in Natural;
      Accelerator : in String := "")
   is
      Item : Gtk.Menu_Item.Gtk_Menu_Item;
   begin
      Gtk.Menu_Item.Gtk_New (Item, Text);
      Gtk.Menu.Insert
        (Menu_Shell => Gtk.Menu.Gtk_Menu (To_Menu.My_Peer),
         Child      => Item,
         Position   => Glib.Gint (Location));
      Gtk.Menu_Item.Show (Item);

      Add_Choice_Common
        (Obj         => Obj,
         To_Menu     => To_Menu,
         Text        => Text,
         Action      => Action,
         Underline   => Underline,
         Accelerator => Accelerator,
         Item        => Item);
   end Add_Choice;

   procedure Add_Submenu_Common
     (Obj          : in out Submenu;
      Text         : in String;
      Underline    : in Natural;
      Parent_Menu  : in Menu'Class;
      On_Post      : in Menu_Callback;
      submenu_item : in Gtk.Menu_Item.Gtk_Menu_Item)
   is
      new_submenu : Gtk.Menu.Gtk_Menu;
   begin
      Gtk.Menu_Item.Show (submenu_item);
      --Add the submenu to the label
      new_submenu                         := new mcc_menu_record;
      mcc_menu (new_submenu).submenu_item := submenu_item;
      mcc_menu (new_submenu).Accel_Group  :=
        mcc_menu_bar (Parent_Menu.My_Peer).Accel_Group;
      Gtk.Menu.Initialize (Widget => new_submenu);
      Gtk.Menu_Item.Set_Submenu
        (Menu_Item => submenu_item,
         Submenu   => new_submenu);

      --Add the accel key to the submenu

      if Parent_Menu in Window_Menu'Class then
         if mcc_menu_bar (Parent_Menu.My_Peer).First_One and
            (mcc_menu_bar (Parent_Menu.My_Peer).Is_Frame = False)
         then
            declare
               Width, Height  : Glib.Gint;
               Menubar_Height : Glib.Gint :=
                  Glib.Gint (mcc.Gui.Window_Peer.Menubar_Height);
               use type Glib.Gint;
            begin
               -- I couldn't figure out how to find the height of the
               -- menubar (kept getting 1), so I just set it
               mcc_menu_bar (Parent_Menu.My_Peer).First_One := False;
               Gdk.Drawable.Get_Size
                 (Drawable =>
                     Gtk.Window.Get_Window
                       (Gtk.Window.Gtk_Window (Gtk.Widget.Get_Parent
                                                  (Gtk.Widget.Gtk_Widget (
                 mcc_menu_bar (Parent_Menu.My_Peer).Vbox)))),
                  Width    => Width,
                  Height   => Height);
               Gdk.Window.Resize
                 (Window =>
                     Gtk.Window.Get_Window
                       (Gtk.Window.Gtk_Window (Gtk.Widget.Get_Parent
                                                  (Gtk.Widget.Gtk_Widget (
                 mcc_menu_bar (Parent_Menu.My_Peer).Vbox)))),
                  Width  => Width,
                  Height => Height + Glib.Gint (Menubar_Height));
            end;
         end if;

         if (mcc_menu_bar (Parent_Menu.My_Peer).Is_Frame = False and
             Underline > 0)
         then
            Gtk.Accel_Group.Unlock
              (mcc_menu_bar (Parent_Menu.My_Peer).Accel_Group);
            Gtk.Menu_Item.Add_Accelerator
              (Widget       => submenu_item,
               Accel_Signal => "activate",
               Accel_Group  => mcc_menu_bar (Parent_Menu.My_Peer).Accel_Group,
               Accel_Key    =>
                 Gdk.Types.Gdk_Key_Type (Character'Pos
                                            (To_Lower (Text (Underline)))),
               Accel_Mods   => Gdk.Types.Mod1_Mask,
               Accel_Flags  => Gtk.Accel_Group.Accel_Locked);
            Gtk.Accel_Group.Lock
              (mcc_menu_bar (Parent_Menu.My_Peer).Accel_Group);
         end if;
      end if;

      if On_Post /= null then
         mcc.Gtk_Signals.Gtk_Signal_Void_Connect
           (submenu_item,
            "activate",
            mcc.Gtk_Signals.Void_Callback (On_Post));
      end if;

      Obj.My_Peer := Gtk.Object.Gtk_Object (new_submenu);
   end Add_Submenu_Common;
   -----------------
   -- Add_Submenu --
   -----------------

   procedure Add_Submenu
     (Obj         : in out Submenu;
      Text        : in String;
      Underline   : in Natural;
      Parent_Menu : in Menu'Class;
      On_Post     : in Menu_Callback := null)
   is

      submenu_item : Gtk.Menu_Item.Gtk_Menu_Item;
   begin
      Gtk.Menu_Item.Gtk_New (Menu_Item => submenu_item, Label => Text);
      Set_Menu_Item_Pattern
        (Submenu_Item => submenu_item,
         Text         => Text,
         Underline    => Underline);

      if Parent_Menu in Window_Menu'Class then
         Gtk.Menu_Bar.Append
           (Menu_Shell => Gtk.Menu_Bar.Gtk_Menu_Bar (Parent_Menu.My_Peer),
            Child      => submenu_item);
      else
         Gtk.Menu.Append
           (Menu_Shell => Gtk.Menu.Gtk_Menu (Parent_Menu.My_Peer),
            Child      => submenu_item);
      end if;

      Add_Submenu_Common
        (Obj          => Obj,
         Text         => Text,
         Underline    => Underline,
         Parent_Menu  => Parent_Menu,
         On_Post      => On_Post,
         submenu_item => submenu_item);
   end Add_Submenu;

   -----------------
   -- Add_Submenu --
   -----------------

   procedure Add_Submenu
     (Obj         : in out Submenu;
      Text        : in String;
      Underline   : in Natural;
      Parent_Menu : in Menu'Class;
      Location    : in Natural;
      On_Post     : in Menu_Callback := null)
   is
      submenu_item : Gtk.Menu_Item.Gtk_Menu_Item;
   begin
      Gtk.Menu_Item.Gtk_New (Menu_Item => submenu_item, Label => Text);
      Set_Menu_Item_Pattern
        (Submenu_Item => submenu_item,
         Text         => Text,
         Underline    => Underline);

      if Parent_Menu in Window_Menu'Class then
         Gtk.Menu_Bar.Insert
           (Menu_Shell => Gtk.Menu_Bar.Gtk_Menu_Bar (Parent_Menu.My_Peer),
            Child      => submenu_item,
            Position   => Glib.Gint (Location));
      else
         Gtk.Menu.Insert
           (Menu_Shell => Gtk.Menu.Gtk_Menu (Parent_Menu.My_Peer),
            Child      => submenu_item,
            Position   => Glib.Gint (Location));
      end if;

      Add_Submenu_Common
        (Obj          => Obj,
         Text         => Text,
         Underline    => Underline,
         Parent_Menu  => Parent_Menu,
         On_Post      => On_Post,
         submenu_item => submenu_item);
   end Add_Submenu;

   ------------
   -- Create --
   ------------

   procedure Create
     (Obj    : in out Window_Menu;
      Window : in mcc.Gui.Container.Container'Class)
   is

      Menu_Bar : mcc_menu_bar;
   begin
      Menu_Bar := new mcc_menu_bar_record;
      Gtk.Accel_Group.Gtk_New (Accel_Group => Menu_Bar.Accel_Group);
      Gtk.Menu_Bar.Initialize (Gtk.Menu_Bar.Gtk_Menu_Bar (Menu_Bar));

      if Window in mcc.Gui.Container.Window.Window'Class then
         Menu_Bar.Is_Frame := False;
         Gtk.Box.Pack_Start
           (In_Box =>
              Gtk.Box.Gtk_Vbox (Gtk.Widget.Get_Parent
                                   (Gtk.Widget.Gtk_Widget (
           mcc.Gui.Container.Get_Peer (Window)))),
            Child  => Menu_Bar,
            Expand => False,
            Fill   => False);
         Menu_Bar.Vbox :=
           Gtk.Box.Gtk_Vbox (Gtk.Widget.Get_Parent
                                (Gtk.Widget.Gtk_Widget (
           mcc.Gui.Container.Get_Peer (Window))));
      else
         Menu_Bar.Is_Frame := True;
         declare
            Mcc_Frame : constant peer.Frame.Mcc_Frame :=
               peer.Frame.Mcc_Frame (mcc.Gui.Container.Get_Peer (Window));
         begin
            Gtk.Box.Pack_Start
              (In_Box =>
                 Gtk.Box.Gtk_Vbox (Gtk.Drawing_Area.Get_Parent
                                      (Mcc_Frame.Drawing_Area)),
            -- Gtk.Fixed.Get_Parent(Gtk.Fixed.Gtk_Fixed(Mcc.Gui.Container.Get_P
            --eer(window)))),
               Child  => Menu_Bar,
               Expand => False,
               Fill   => False);
         end;
      end if;

      if Window in mcc.Gui.Container.Window.Window'Class then
         -- @todo port to new gtk
         --gtk.accel_group.Attach(
         --   Accel_Group => Menu_Bar.accel_group,
         --   Object      => mcc.gui.window_peer.get_window(
         --      mcc.gui.container.window.window'class(window)));
         Gtk.Accel_Group.Lock (Menu_Bar.Accel_Group);
      end if;

      Gtk.Menu_Bar.Show (Gtk.Menu_Bar.Gtk_Menu_Bar (Menu_Bar));
      --Have Object point to menu bar Widget
      Obj.My_Peer := Gtk.Object.Gtk_Object (Menu_Bar);

   end Create;

   ------------
   -- Delete --
   ------------

   procedure Delete (Obj : in out Menu_Item) is
   begin
      -- if Menu_Item'Class(Obj) in Submenu'Class then
      --    Gtk.Widget.Destroy(Gtk.Widget.Gtk_Widget(
      --       Mcc_Menu(Obj.My_Peer).Submenu_Item));
      -- end if;
      Gtk.Widget.Destroy (Gtk.Widget.Gtk_Widget (Obj.My_Peer));
   end Delete;

   -------------
   -- Disable --
   -------------

   procedure Disable (Obj : in out Choice) is
   begin
      Gtk.Widget.Set_Sensitive (Gtk.Widget.Gtk_Widget (Obj.My_Peer), False);
   end Disable;

   ------------
   -- Enable --
   ------------

   procedure Enable (Obj : in out Choice) is
   begin
      Gtk.Widget.Set_Sensitive (Gtk.Widget.Gtk_Widget (Obj.My_Peer), True);
   end Enable;

   procedure Add_Separator
     (Obj     : in out Separator;
      To_Menu : in Menu'Class)
   is
      Item : Gtk.Menu_Item.Gtk_Menu_Item;
   begin
      Gtk.Menu_Item.Gtk_New (Item, "");

      Gtk.Menu.Append (Gtk.Menu.Gtk_Menu (To_Menu.My_Peer), Item);
      Gtk.Menu_Item.Show (Item);
      Obj.My_Peer := Gtk.Object.Gtk_Object (Item);
   end Add_Separator;

   procedure Add_Separator
     (Obj      : in out Separator;
      To_Menu  : in Menu'Class;
      Location : in Natural)
   is
      Item : Gtk.Menu_Item.Gtk_Menu_Item;
   begin
      Gtk.Menu_Item.Gtk_New (Item, "");

      Gtk.Menu.Insert
        (Menu_Shell => Gtk.Menu.Gtk_Menu (To_Menu.My_Peer),
         Child      => Item,
         Position   => Glib.Gint (Location));
      Gtk.Menu_Item.Show (Item);
      Obj.My_Peer := Gtk.Object.Gtk_Object (Item);
   end Add_Separator;

end Mcc.Gui.Menu;
