/*
 * Decompiled with CFR 0.152.
 */
package org.nongnu.pulsefire.wire;

import org.nongnu.pulsefire.wire.Command;
import org.nongnu.pulsefire.wire.CommandName;
import org.nongnu.pulsefire.wire.CommandWireException;
import org.nongnu.pulsefire.wire.CommandWireType;

public class CommandWire {
    public static Command decodeCommand(String lineRaw) throws CommandWireException {
        String[] ss;
        String line = lineRaw;
        String commandName = null;
        CommandWireType commandType = CommandWireType.request_set;
        if (line.contains("==")) {
            commandType = CommandWireType.response_get;
            ss = line.split("==");
            commandName = ss[0];
            line = ss[1];
        } else if (line.contains("=")) {
            commandType = CommandWireType.response_set;
            ss = line.split("=");
            commandName = ss[0];
            line = ss[1];
        } else if (line.contains(" ")) {
            commandName = line.substring(0, line.indexOf(" "));
            line = line.substring(line.indexOf(" "), line.length());
        } else {
            commandName = line;
            line = "";
        }
        char last = commandName.charAt(commandName.length() - 1);
        String idx = null;
        if (Character.isDigit(last)) {
            char lastOne;
            int index = commandName.length() - 1;
            if (commandName.length() > 1 && Character.isDigit(lastOne = commandName.charAt(commandName.length() - 2))) {
                --index;
            }
            idx = commandName.substring(index);
            commandName = commandName.substring(0, index);
        }
        Command result = null;
        for (CommandName cmd : CommandName.values()) {
            if (cmd.isAliased()) {
                if (!cmd.getAliasName().equals(commandName)) continue;
                result = new Command(cmd);
                break;
            }
            if (!cmd.name().equals(commandName)) continue;
            result = new Command(cmd);
        }
        if (result == null) {
            throw new CommandWireException("Could not find command for: '" + commandName + "' in line: '" + lineRaw + "'");
        }
        if (result.getCommandName().isIndexedB() && idx != null) {
            line = idx + " " + line;
        } else if (result.getCommandName().isIndexedA() && idx != null) {
            line = line + " " + idx;
        }
        result.setType(commandType);
        String[] columns = line.split(" ");
        if (result.getCommandName() == CommandName.chip_flags | result.getCommandName() == CommandName.chip_build) {
            columns[0] = line;
        }
        if (columns.length > 7) {
            result.setArgu7(columns[7]);
        }
        if (columns.length > 6) {
            result.setArgu6(columns[6]);
        }
        if (columns.length > 5) {
            result.setArgu5(columns[5]);
        }
        if (columns.length > 4) {
            result.setArgu4(columns[4]);
        }
        if (columns.length > 3) {
            result.setArgu3(columns[3]);
        }
        if (columns.length > 2) {
            result.setArgu2(columns[2]);
        }
        if (columns.length > 1) {
            result.setArgu1(columns[1]);
        }
        if (columns.length > 0) {
            result.setArgu0(columns[0]);
        }
        result.setLineRaw(line);
        return result;
    }

    public static String encodeCommand(Command command) {
        return CommandWire.encodeCommand(command, false);
    }

    public static String encodeCommand(Command command, boolean mapName) {
        StringBuilder buff = new StringBuilder();
        if (command.getCommandName().isAliased()) {
            buff.append(command.getCommandName().getAliasName());
        } else {
            buff.append(command.getCommandName().toString());
        }
        if (command.getArgu0() != null) {
            buff.append(" ");
            buff.append(command.getArgu0());
        }
        if (command.getArgu1() != null) {
            buff.append(" ");
            if (mapName && command.getCommandName().isIndexedB() && !"65535".equals(command.getArgu1())) {
                CommandName cmdName = CommandName.valueOfMapIndex(new Integer(command.getArgu1()));
                buff.append(cmdName.name());
            } else {
                buff.append(command.getArgu1());
            }
        }
        if (command.getArgu2() != null) {
            buff.append(" ");
            buff.append(command.getArgu2());
        }
        if (command.getArgu3() != null) {
            buff.append(" ");
            buff.append(command.getArgu3());
        }
        if (command.getArgu4() != null) {
            buff.append(" ");
            buff.append(command.getArgu4());
        }
        if (command.getArgu5() != null) {
            buff.append(" ");
            buff.append(command.getArgu5());
        }
        if (command.getArgu6() != null) {
            buff.append(" ");
            buff.append(command.getArgu6());
        }
        if (command.getArgu7() != null) {
            buff.append(" ");
            buff.append(command.getArgu7());
        }
        String lineRaw = buff.toString();
        command.setLineRaw(lineRaw);
        return lineRaw;
    }
}

