<?php
##############################################################
# FILENAME  : acp.php
# COPYRIGHT : (c) 2006, Tyler N. King <aibotca@yahoo.ca>
# GPL v2.0 or later. See docs/COPYING.
##############################################################
# This program is free software; you can redistribute it 
# and/or modify it under the terms of the GNU General Public 
# License as published by the Free Software Foundation; 
# either version 2 of the License, or (at your option) 
# any later version.
#
# This program is distributed in the hope that it will be 
# useful, but WITHOUT ANY WARRANTY; without even the implied 
# warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
# PURPOSE. See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public 
# License along with this program; if not, write to the 
# Free Software Foundation, Inc., 51 Franklin St, Fifth Floor, 
# Boston, MA  02110-1301  USA
##############################################################
define ( IN_PHPBB, true );
$phpbb_root_path	= './';

include ( $phpbb_root_path . 'includes/page_header.'.$phpEx );

if ( !$userdata[ 'session_logged_in' ] )
{
	message_die ( GENERAL_MESSAGE, $lang[ 'rivals_ltfin' ] );
}

if ( $userdata[ 'user_level' ] == USER )
{
	message_die ( GENERAL_MESSAGE, 'Sorry, this is a administrator and moderator section only.' );
}

if ( $http_vars[ 'mode' ] == 'tickets' )
{
	if ( !empty ( $http_vars[ 'submit' ] ) )
	{
		$sql	= 'UPDATE ' . RIVALS_CONFIG . ' SET ticket_recivers = "' . $http_vars[ 'ticket_r' ] . '", ticket_one = "' . $http_vars[ 'ticket_1' ] . '"';
		$db->sql_query ( $sql );

		message_die ( GENERAL_MESSAGE, $lang[ 'rivals_trchb' ] );
	}
	else
	{
		$sql		= 'SELECT * FROM ' . RIVALS_CONFIG;
		$result		= $db->sql_query ( $sql );
		$row		= $db->sql_fetchrow ( $result );

		$template->assign_vars ( array (
			'U_ACTION' => append_sid ( 'rivals.php?action=acp&mode=tickets' ),
			'L_CONFIG' => $lang[ 'rivals_edconf' ],
			'L_ONLYONE' => $lang[ 'rivals_edcon2'],
			'L_RIVALS_1MPA6' => $lang[ 'rivals_1mpa6' ],
			'S_CONFIG' => $row[ 'ticket_recivers' ],
			'L_EXPCONFTICK' => $lang[ 'EXPCONFTICK' ],
			'L_EXPCONFTICKONE' => $lang[ 'EXPCONFTICKONE' ],
			'L_EXPCONF' => $lang[ 'EXPCONF' ],
			'L_SUBMIT' => $lang[ 'rivals_1x1s' ],
			'S_SELECTED' => ( !empty ( $row[ 'ticket_one' ] ) ) ? 'checked="checked"' : '',
			'L_CONFIGONE' => $lang[ 'rivals_edcon1' ] )
		);

		$template->set_filenames ( array (
			'body' => 'rivals/acp_tickets.tpl' )
		);

		$template->pparse ( 'body' );
	}
}
else if ( $http_vars[ 'mode' ] == 'sponsors' )
{
	if ( !empty ( $http_vars[ 'submit' ] ) )
	{
		$sql	= 'INSERT INTO ' . SPONSORS_TABLE . ' (`sponsor_id`,`sponsor_image`,`sponsor_desc`,`sponsor_tournament`,`sponsor_url`) VALUES ("NULL","' . $http_vars[ 'sponsor_image' ] . '","' . $http_vars[ 'sponsor_desc' ] . '","' . $http_vars[ 'sponsor_tournament' ] . '","' . $http_vars[ 'sponsor_url' ] . '")';
		$db->sql_query ( $sql );

		message_die ( GENERAL_MESSAGE, $lang[ 'rivals_6v1k0' ] );
	}
	else
	{
		$sql	= 'SELECT * FROM ' . TOURNAMENTS_TABLE;
		$result	= $db->sql_query ( $sql );

		for ( $i = 0; $i < $db->sql_numrows ( $result ); $i++ )
		{
			$row	= $db->sql_fetchrow ( $result );

			$template->assign_block_vars ( 'block_tournaments', array (
				'S_TOURNAMENTID' => $row[ 'tournament_id' ],
				'S_TOURNAMENTNAME' => $tournament->data ( 'tournament_name', $row[ 'tournament_id' ] ) )
			);
		}

		$template->assign_vars ( array (
			'U_ACTION' => append_sid ( 'rivals.php?action=acp&mode=sponsors' ),
			'L_ADDSPONSOR' => $lang[ 'rivals_4hkdn' ],
			'L_SPONSORIMG' => $lang[ 'rivals_4hkdt' ],
			'L_SPONSORURL' => $lang[ 'rivals_4hkdq' ],
			'L_SPONSORDESC' => $lang[ 'rivals_4hkdu' ],
			'L_EXPSPON' => $lang[ 'EXPSPON' ],
			'L_EXPSPONIMG' => $lang[ 'EXPSPONIMG' ],
			'L_EXPSPONURL' => $lang[ 'EXPSPONURL' ],
			'L_EXPSPONDESC' => $lang[ 'EXPSPONDESC' ],
			'L_SUBMIT' => $lang[ 'rivals_1x1s' ],
			'L_EXPSPONTOUR' => $lang[ 'EXPSPONTOUR' ],
			'L_SPONSORTOURN' => $lang[ 'rivals_4hkda' ] )
		);

		$template->set_filenames ( array (
			'body' => 'rivals/acp_sponsors.tpl' )
		);

		$template->pparse ( 'body' );
	}
}
else if ( $http_vars[ 'mode' ] == 'add_ladder' )
{
	if ( !empty ( $http_vars[ 'submit' ] ) )
	{
		$sql	= 'INSERT INTO ' . LADDERS_TABLE . ' (ladder_id, ladder_name, platform, ladder_rules) VALUES ("NULL", "' . $http_vars[ 'ladder_name' ] . '", "' . $http_vars[ 'platform' ] . '", "' . $http_vars[ 'ladder_rules' ] . '")';
		$db->sql_query ( $sql );

		message_die ( GENERAL_MESSAGE, $lang[ 'rivals_tlia' ] );
	}
	else
	{
		$sql	= 'SELECT * FROM ' . PLATFORMS_TABLE;
		$result	= $db->sql_query ( $sql );

		for ( $i = 0; $i < $db->sql_numrows ( $result ); $i++ )
		{
			$row	= $db->sql_fetchrow ( $result );

			$template->assign_block_vars ( 'block_platforms', array (
				'S_PLATFORMID' => $row[ 'platform_id' ],
				'S_PLATFORMNAME' => $row[ 'platform_name' ] )
			);
		}

		$template->assign_vars ( array (
			'U_ACTION' => append_sid ( 'rivals.php?action=acp&mode=add_ladder' ),
			'L_ADDLADDER' => $lang[ 'rivals_addla' ],
			'L_LADDERNAME2' => $lang[ 'rivals_lnop' ],
			'L_LADDERPLATFORM' => $lang[ 'rivals_1989w' ],
			'L_LADDERRULES' => $lang[ 'rivals_1' ],
			'L_EXPLADDLADDNAME' => $lang[ 'EXPLADDLADDNAME' ],
			'L_EXPLADDPLAT' => $lang[ 'EXPLADDPLAT' ],
			'L_EXPLADDLADDRULE' => $lang[ 'EXPLADDLADDRULE' ],
			'L_SUBMIT' => $lang[ 'rivals_1x1s' ],
			'L_EXPLADDADD' => $lang[ 'EXPLADDADD' ] )
		);

		$template->set_filenames ( array (
			'body' => 'rivals/acp_addladder.tpl' )
		);

		$template->pparse ( 'body' );
	}
}
else if ( $http_vars[ 'mode' ] == 'add_subladder' )
{
	if ( !empty ( $http_vars[ 'submit' ] ) )
	{
		$sql	= 'INSERT INTO ' . LADDERS_TABLE . ' (ladder_id, ladder_name, ladder_desc, ladder_parent, ladder_scoring, ladder_issues, ladder_rank, ladder_f1,  ladder_f2, ladder_rating) VALUES ("NULL", "' . $http_vars[ 'ladder_name' ] . '", "' . $http_vars[ 'ladder_desc' ] . '", "' . $http_vars[ 'ladder_parent' ] . '", "' . $http_vars[ 'scoring' ] . '", "' . $http_vars[ 'issues' ] . '", "' . $http_vars[ 'ladder_rank' ] . '", "' . $http_vars[ 'ladder_f1' ] . '", "' . $http_vars[ 'ladder_f2' ] . '", "' . $http_vars[ 'ladder_rating' ] . '")';
		$db->sql_query ( $sql );

		message_die ( GENERAL_MESSAGE, $lang[ 'rivals_tlia' ] );
	}
	else
	{
		$sql	= 'SELECT * FROM ' . LADDERS_TABLE . ' WHERE (ladder_parent = "" OR ladder_parent = "0")';
		$result	= $db->sql_query ( $sql );

		for ( $i = 0; $i < $db->sql_numrows ( $result ); $i++ )
		{
			$row	= $db->sql_fetchrow ( $result );

			$template->assign_block_vars ( 'block_ladders', array (
				'S_LADDERNAME' => $ladder->data ( 'ladder_name', $row[ 'ladder_id' ] ),
				'S_LADDERID' => $ladder->data ( 'ladder_id', $row[ 'ladder_id' ] ) )
			);
		}

		$template->assign_vars ( array (
			'U_ACTION' => append_sid ( 'rivals.php?action=acp&mode=add_subladder' ),
			'L_RIVALS_1MPAS' => $lang[ 'rivals_1mpas' ],
			'L_ADDLADDER' => $lang[ 'rivals_addla' ],
			'L_EXPSUBL' => $lang[ 'EXPSUBL' ],
			'L_EXPSUBLPARE' => $lang[ 'EXPSUBLPARE' ],
			'L_EXPSUBLNAME' => $lang[ 'EXPSUBLNAME' ],
			'L_EXPSUBLSCOR' => $lang[ 'EXPSUBLSCOR' ],
			'L_LADDERNAME2' => $lang[ 'rivals_lnop' ],
			'L_LADDERRULES' => $lang[ 'rivals_1' ],
			'L_EXPSUBLISSU' => $lang[ 'EXPSUBLISSU' ],
			'L_EXPSUBLRAT' => $lang[ 'EXPSUBLRAT' ],
			'L_EXPSUBLRANK' => $lang[ 'EXPSUBLRANK' ],
			'L_EXPSUBLDESC' => $lang[ 'EXPSUBLDESC' ],
			'L_LADDERPARENT' => $lang[ 'rivals_78881' ],
			'L_SUBMIT' => $lang[ 'rivals_1x1s' ],
			'L_LADDERRANK' => $lang[ 'rivals_4' ],
			'L_LADDERPLATFORM' => $lang[ 'rivals_1989w' ],
			'L_LADDERSCORING' => $lang[ 'rivals_19896' ],
			'L_RAT' => $lang[ 'rivals_widhs' ],
			'L_LADDERF1F2' => $lang[ 'rivals_1z' ],
			'L_ISSUES' => $lang[ 'rivals_dasmo' ],
			'L_DEFAULT' => $lang[ 'rivals_trigu' ],
			'L_ALTERNATE' => $lang[ 'rivals_trign' ] )
		);

		$template->set_filenames ( array (
			'body' => 'rivals/acp_addsubladder.tpl' )
		);

		$template->pparse ( 'body' );
	}
}
else if ( $http_vars[ 'mode' ] == 'edit_ladder' )
{
	if ( !empty ( $http_vars[ 'move' ] ) )
	{
		re_order ( $http_vars[ 'move' ], $http_vars[ 'ladder_id' ] );
		message_die ( GENERAL_MESSAGE, $lang[ 'rivals_tliu' ] );
	}

	if ( !empty ( $http_vars[ 'submit' ] ) )
	{
		if ( !empty ( $http_vars[ 'delete' ] ) )
		{
			$sql	= 'DELETE FROM ' . LADDERS_TABLE . ' WHERE ladder_id = ' . $http_vars[ 'ladder_id' ];
			$db->sql_query ( $sql );
		}
		else
		{
			$sql	= 'UPDATE ' . LADDERS_TABLE . ' SET ladder_name = "' . $http_vars[ 'ladder_name' ] . '", ladder_rules = "' . $http_vars[ 'ladder_rules' ] . '" WHERE ladder_id = ' . $http_vars[ 'ladder_id' ];
			$db->sql_query ( $sql );
		}

		message_die ( GENERAL_MESSAGE, $lang[ 'rivals_tliu' ] );
	}
	else
	{
		$sql	= 'SELECT * FROM ' . LADDERS_TABLE . ' WHERE (ladder_parent = "" OR ladder_parent = "0") ORDER BY ladder_order ASC';
		$result	= $db->sql_query ( $sql );

		for ( $i = 0; $i < $db->sql_numrows ( $result ); $i++ )
		{
			$row	= $db->sql_fetchrow ( $result );

			$template->assign_block_vars ( 'block_ladders', array (
				'L_RIVALS_LNOP' => $lang[ 'rivals_lnop' ],
				'S_LADDERNAME' => $ladder->data ( 'ladder_name', $row[ 'ladder_id' ] ),
				'S_LADDERID' => $ladder->data ( 'ladder_id', $row[ 'ladder_id' ] ),
				'S_LADDERRULES' => $ladder->data ( 'ladder_rules', $row[ 'ladder_id' ] ),
				'U_MOVEUP' => append_sid ( 'rivals.php?action=acp&mode=edit_ladder&move=up&ladder_id=' . $ladder->data ( 'ladder_id', $row[ 'ladder_id' ] ) ),
				'U_MOVEDOWN' => append_sid ( 'rivals.php?action=acp&mode=edit_ladder&move=down&ladder_id=' . $ladder->data ( 'ladder_id', $row[ 'ladder_id' ] ) ),
				'L_RIVALS_1' => $lang[ 'rivals_1' ],
				'L_SUBMIT' => $lang[ 'rivals_1x1s' ],
				'L_MOVEUP' => $lang[ 'rivals_whocares' ],
				'L_RIVALS_1MWXS' => $lang[ 'rivals_1mwxs' ],
				'L_SUBMIT' => $lang[ 'rivals_1x1s' ],
				'L_MOVEDOWN' => $lang[ 'rivals_mehpp' ],
				'L_DELETE' => $lang[ 'rivals_wyuc' ] )
			);
		}

		$template->assign_vars ( array (
			'L_RIVALS_1MWXS' => $lang[ 'rivals_1mwxs' ],
			'L_RIVALS_1MPXS' => $lang[ 'rivals_1mpxs' ],
			'L_EXPLADDEDIT' => $lang[ 'EXPLADDEDIT' ],
			'L_SUBMIT' => $lang[ 'rivals_1x1s' ],
			'U_ACTION' => append_sid ( 'rivals.php?action=acp&mode=edit_ladder' ) )
		);

		$template->set_filenames ( array (
			'body' => 'rivals/acp_editladder.tpl' )
		);

		$template->pparse ( 'body' );
	}
}
else if ( $http_vars[ 'mode' ] == 'edit_subladder' )
{
	if ( !empty ( $http_vars[ 'move' ] ) )
	{
		re_order ( $http_vars[ 'move' ], $http_vars[ 'ladder_id' ] );
		message_die ( GENERAL_MESSAGE, $lang[ 'rivals_tliu' ] );
	}

	if ( !empty ( $http_vars[ 'submit' ] ) )
	{
		if ( !empty ( $http_vars[ 'delete' ] ) )
		{
			$sql	= 'DELETE FROM ' . LADDERS_TABLE . ' WHERE ladder_id = ' . $http_vars[ 'ladder_id' ];
			$db->sql_query ( $sql );
		}
		else
		{
			$sql	= 'UPDATE ' . LADDERS_TABLE . ' SET ladder_name = "' . $http_vars[ 'ladder_name' ] . '", ladder_desc = "' . $http_vars[ 'ladder_desc' ] . '", ladder_scoring = "' . $http_vars[ 'scoring' ] . '", ladder_issues = "' . $http_vars[ 'issues' ] . '", ladder_rank = "' . $http_vars[ 'ladder_rank' ] . '", ladder_f1 = "' . $http_vars[ 'ladder_f1' ] . '", ladder_f2 = "' . $http_vars[ 'ladder_f2' ] . '", ladder_rating = "' . $http_vars[ 'ladder_rating' ] . '" WHERE ladder_id = ' . $http_vars[ 'ladder_id' ];
			$db->sql_query ( $sql );
		}

		message_die ( GENERAL_MESSAGE, $lang[ 'rivals_tliu' ] );
	}
	else
	{
		$sql	= 'SELECT * FROM ' . LADDERS_TABLE . ' WHERE (ladder_parent != "" OR ladder_parent != "0") ORDER BY subladder_order ASC';
		$result	= $db->sql_query ( $sql );

		for ( $i = 0; $i < $db->sql_numrows ( $result ); $i++ )
		{
			$row	= $db->sql_fetchrow ( $result );

			$template->assign_block_vars ( 'block_ladders', array (
				'S_LADDERNAME' => $ladder->data ( 'ladder_name', $row[ 'ladder_id' ] ),
				'S_LADDERDESC' => $ladder->data ( 'ladder_desc', $row[ 'ladder_id' ] ),
				'L_SCORING' => $lang[ 'rivals_19896' ],
				'S_SCORING' => ( $ladder->data ( 'ladder_scoring', $row[ 'ladder_id' ] ) == 1 ) ? 'selected' : '',
				'S_LADDERID' => $row[ 'ladder_id' ],
				'L_ISSUESS' => $lang[ 'rivals_dasmo' ],
				'S_LADDERRANK' => $ladder->data ( 'ladder_rank', $row[ 'ladder_id' ] ),
				'L_LADDERRANK' => $lang[ 'rivals_4' ],
				'S_ISSUES' => $ladder->data ( 'ladder_issues', $row[ 'ladder_id' ] ),
				'S_PARENT' => $ladder->data ( 'ladder_id', $row[ 'ladder_id' ] ),
				'S_LADDERF1' => $ladder->data ( 'ladder_f1', $row[ 'ladder_id' ] ),
				'S_LADDERF2' => $ladder->data ( 'ladder_f2', $row[ 'ladder_id' ] ),
				'L_RAT' => $lang[ 'rivals_widhs' ],
				'S_RAT' => $ladder->data ( 'ladder_rating', $row[ 'ladder_id' ] ),
				'L_DEFAULT' => $lang[ 'rivals_trigu' ],
				'L_ALTERNATE' => $lang[ 'rivals_trign' ],
				'U_MOVEUP' => append_sid ( 'rivals.php?action=acp&mode=edit_ladder&move=up&ladder_id=' . $ladder->data ( 'ladder_id', $row[ 'ladder_id' ] ) ),
				'U_MOVEDOWN' => append_sid ( 'rivals.php?action=acp&mode=edit_ladder&move=down&ladder_id=' . $ladder->data ( 'ladder_id', $row[ 'ladder_id' ] ) ),
				'L_MOVEUP' => $lang[ 'rivals_whocares' ],
				'L_MOVEDOWN' => $lang[ 'rivals_mehpp' ],
				'L_DELETE' => $lang[ 'rivals_wyuc' ] )
			);
		}

		$template->assign_vars ( array (
			'L_EXPSUBL' => $lang[ 'EXPSUBL' ],
			'L_RIVALS_1MWXS' => $lang[ 'rivals_1mwxs' ],
			'L_SUBMIT' => $lang[ 'rivals_1x1s' ],
			'U_ACTION' => append_sid ( 'rivals.php?action=acp&mode=edit_subladder' ) )
		);

		$template->set_filenames ( array (
			'body' => 'rivals/acp_editsubladder.tpl' )
		);

		$template->pparse ( 'body' );
	}
}
else if ( $http_vars[ 'mode' ] == 'edit_platforms' )
{
	if ( !empty ( $http_vars[ 'submit' ] ) )
	{
		if ( !empty ( $http_vars[ 'delete' ] ) )
		{
			$sql	= 'DELETE FROM ' . PLATFORMS_TABLE . ' WHERE platform_id = ' . $http_vars[ 'platform_id' ];
			$db->sql_query ( $sql );

			message_die ( GENERAL_MESSAGE, $lang[ 'rivals_tpido' ] );
		}
		else
		{
			$sql	= 'UPDATE ' . PLATFORMS_TABLE . ' SET platform_name = "' . $http_vars[ 'platform_name' ] . '" WHERE platform_id = ' . $http_vars[ 'platform_id' ];
			$db->sql_query ( $sql );

			message_die ( GENERAL_MESSAGE, $lang[ 'rivals_thgp' ] );
		}
	}
	else
	{
		$sql	= 'SELECT * FROM ' . PLATFORMS_TABLE;
		$result	= $db->sql_query ( $sql );

		for ( $i = 0; $i < $db->sql_numrows ( $result ); $i++ )
		{
			$row	= $db->sql_fetchrow ( $result );

			$template->assign_block_vars ( 'block_platforms', array (
				'L_RIVALS_1990e' => $lang[ 'rivals_1990e' ],
				'S_PLATFORMID' => $row[ 'platform_id' ],
				'L_SUBMIT' => $lang[ 'rivals_1x1s' ],
				'S_PLATFORMNAME' => $row[ 'platform_name' ],
				'L_DELETE' => $lang[ 'rivals_wyuc' ] )
			);
		}

		$template->assign_vars ( array (
			'L_RIVALS_1QWXS' => $lang[ 'rivals_1qwxs' ],
			'L_EXPPLAT' => $lang[ 'EXPPLAT' ],
			'U_EDITPLATFORMS' => append_sid ( 'rivals.php?action=acp&mode=edit_platforms' ) )
		);

		$template->set_filenames ( array (
			'body' => 'rivals/acp_editplatforms.tpl' )
		);

		$template->pparse ( 'body' );
	}
}
else if ( $http_vars[ 'mode' ] == 'add_platform' )
{
	if ( !empty ( $http_vars[ 'submit' ] ) )
	{
		$sql	= 'INSERT INTO ' . PLATFORMS_TABLE . ' (platform_id, platform_name) VALUES ("NULL", "' . $http_vars[ 'plat_name' ] . '")';
		$db->sql_query ( $sql );

		message_die ( GENERAL_MESSAGE, $lang[ 'rivals_thgg' ] );
	}
	else
	{
		$template->assign_vars ( array (
			'L_ADDPLATFORM' => $lang[ 'ADDPLATFORM' ],
			'L_EXPPLAT' => $lang[ 'EXPPLAT' ],
			'L_RIVALS_1990E' => $lang[ 'rivals_1990e' ],
			'L_EXPPLATNAME' => $lang[ 'EXPPLATNAME' ],
			'L_SUBMIT' => $lang[ 'rivals_1x1s' ],
			'U_ACTION' => append_sid ( 'rivals.php?action=acp&mode=add_platform' ) )
		);

		$template->set_filenames ( array (
			'body' => 'rivals/acp_addplatform.tpl' )
		);

		$template->pparse ( 'body' );
	}
}
else if ( $http_vars[ 'mode' ] == 'add_tournament' )
{
	if ( !empty ( $http_vars[ 'submit' ] ) )
	{
		$sql	= 'INSERT INTO ' . TOURNAMENTS_TABLE . '(`tournament_id`,`tournament_status`,`tournament_name`,`tournament_brackets`,`tournament_state`,`tournament_password`,`tournament_info`,`tournament_type`,`tournament_rm`) VALUES ("NULL","1","' . $http_vars[ 'tourn_name' ] . '","' . $http_vars[ 'brackets' ] . '","' . $http_vars[ 'tourn_state' ] . '","' . $http_vars[ 'password' ] . '","' . $http_vars[ 'tourn_info' ] . '","' . $http_vars[ 'tourn_type' ] . '","' . $http_vars[ 'tourn_rm' ] . '")';
		$db->sql_query ( $sql );

		message_die ( GENERAL_MESSAGE, $lang[ 'rivals_81982' ] );
	}
	else
	{
		$template->assign_vars ( array (
			'U_ACTION' => append_sid ( 'rivals.php?action=acp&mode=add_tournament' ),
			'L_TOURNBRACKETS' => $lang[ 'rivals_8980' ],
			'L_EXPTOUR' => $lang[ 'EXPTOUR' ],
			'L_EXPTOURNAME' => $lang[ 'EXPTOURNAME' ],
			'L_EXPTOURSTAT' => $lang[ 'EXPTOURSTAT' ],
			'L_EXPTOURPASS' => $lang[ 'EXPTOURPASS' ],
			'L_EXPTOURBRAC' => $lang[ 'EXPTOURBRAC' ],
			'L_EXPTOURREQU' => $lang[ 'EXPTOURREQU' ],
			'L_EXPTOURINFO' => $lang[ 'EXPTOURINFO' ],
			'L_EXPTOURTYPE' => $lang[ 'EXPTOURTYPE' ],
			'L_TOURNTYPE' => $lang[ 'rivals_tmo3' ],
			'L_TOURNSTATE' => $lang[ 'rivals_9999' ],
			'L_TOURNINFO' => $lang[ 'rivals_555' ],
			'L_SUBMIT' => $lang[ 'rivals_1x1s' ],
			'L_TOURNPASS' => $lang[ 'rivals_1111' ],
			'L_TOURNNAME' => $lang[ 'rivals_3877' ],
			'L_TOURNRM' => $lang[ 'rivals_38xx' ],
			'L_TOURNAMENTS' => $lang[ 'rivals_swiz' ] )
		);

		$template->set_filenames ( array (
			'body' => 'rivals/acp_addtournament.tpl' )
		);

		$template->pparse ( 'body' );
	}
}
else if ( $http_vars[ 'mode' ] == 'edit_tournament' )
{
	if ( !empty ( $http_vars[ 'submit' ] ) )
	{
		if ( !empty ( $http_vars[ 'delete' ] ) )
		{
			$sql	= 'DELETE FROM ' . TOURNAMENTS_TABLE . ' WHERE tournament_id = ' . $http_vars[ 'tournament_id' ];
			$db->sql_query ( $sql );

			message_die ( GENERAL_MESSAGE, $lang[ 'rivals_tpido' ] );
		}
		else
		{
			$clans	= explode ( '|', $tournament->data[ 'tournament_clans' ] );
			shuffle ( $clans );
			$new_clans	= '';
			$i			= 0;

			foreach ( $clans AS $clan )
			{
				$i++;
				if ( $i == 1 )
				{
					$new_clans	.= $clan . ':1_' . $i;
				}
				else
				{
					$new_clans	.= '|' . $clan . ':1_' . $i;
				}
			}

			$sql	= 'UPDATE ' . TOURNAMENTS_TABLE . ' SET tournament_status = "2", tournament_clans = "' . $new_clans . '" WHERE tournament_id = ' . $tournament->data[ 'tournament_id' ];
			$db->sql_query ( $sql );

			message_die ( GENERAL_MESSAGE, $lang[ 'rivals_ymnyt' ] );
		}
	}
	else
	{
		$sql	= 'SELECT * FROM ' . TOURNAMENTS_TABLE;
		$result	= $db->sql_query ( $sql );

		for ( $i = 0; $i < $db->sql_numrows ( $result ); $i++ )
		{
			$row	= $db->sql_fetchrow ( $result );

			$template->assign_block_vars ( 'block_tournaments', array (
				'L_STATE' => ( $tournament->data ( 'tournament_state', $row[ 'tournament_id' ] ) == '1' ) ? $lang[ 'rivals_publ' ] : $lang[ 'rivals_privs' ],
				'L_READY' => ( count ( explode ( '|', $tournament->data ( 'tournament_clans', $row[ 'tournament_id' ] ) ) ) >= $tournament->data ( 'tournament_brackets', $row[ 'tournament_id' ] ) ) ? $lang[ 'rivals_dan39' ] : $lang[ 'rivals_dan40' ],
				'L_READY2' => $lang[ 'rivals_itfr?' ],
				'L_STARTED' => ( $tournament->data ( 'tournament_status', $row[ 'tournament_id' ] ) == '2' ) ? $lang[ 'rivals_dan39' ] : $lang[ 'rivals_dan40' ],
				'L_STARTED2' => $lang[ 'rivals_clone' ],
				'S_TOURNAMENTID' => $row[ 'tournament_id' ],
				'S_TOURNAMENTNAME' => $tournament->data ( 'tournament_name', $row[ 'tournament_id' ] ) )
			);
		}

		$template->assign_vars ( array (
			'L_RIVALS_1QQXE' => $lang[ 'rivals_1qqxe' ],
			'U_ACTION' => append_sid ( 'rivals.php?action=acp&mode=edit_tournament' ),
			'L_EXPTOUREDIT' => $lang[ 'EXPTOUREDIT' ],
			'L_START' => $lang[ 'rivals_stfto' ],
			'L_TOURNAMENTS' => $lang[ 'rivals_swiz' ],
			'L_DELETE' => $lang[ 'rivals_wyuc' ] )
		);

		$template->set_filenames ( array (
			'body' => 'rivals/acp_edittournament.tpl' )
		);

		$template->pparse ( 'body' );
	}
}
else
{
	$template->assign_vars ( array (
		'L_CONFIGURE' => $lang[ 'rivals_1mpa6' ],
		'U_CONFIGURE' => append_sid ( 'rivals.php?action=acp&mode=tickets' ),
		'L_ADDSPONSOR' => $lang[ 'rivals_1mpa1' ],
		'U_ADDSPONSOR' => append_sid ( 'rivals.php?action=acp&mode=sponsors' ),
		'L_ADDLADDER' => $lang[ 'rivals_1mpa3' ],
		'U_ADDLADDER' => append_sid ( 'rivals.php?action=acp&mode=add_ladder' ),
		'L_ADDSUBLADDER' => $lang[ 'rivals_1mpas' ],
		'U_ADDSUBLADDER' => append_sid ( 'rivals.php?action=acp&mode=add_subladder' ),
		'L_EDITLADDER' => $lang[ 'rivals_1mpxs' ],
		'U_EDITLADDER' => append_sid ( 'rivals.php?action=acp&mode=edit_ladder' ),
		'L_EDITSUBLADDER' => $lang[ 'rivals_1mwxs' ],
		'U_EDITSUBLADDER' => append_sid ( 'rivals.php?action=acp&mode=edit_subladder' ),
		'L_EXPCONF' => $lang[ 'EXPCONF' ],
		'L_EXPTOUR' => $lang[ 'EXPTOUR' ],
		'L_EXPLADDGEN' => $lang[ 'EXPLADDGEN' ],
		'L_EDITPLATFORMS' => $lang[ 'rivals_1qwxs' ],
		'U_EDITPLATFORMS' => append_sid ( 'rivals.php?action=acp&mode=edit_platforms' ),
		'L_ADDPLATFORM' => $lang[ 'rivals_1quxs' ],
		'U_ADDPLATFORM' => append_sid ( 'rivals.php?action=acp&mode=add_platform' ),
		'L_ADDTOURNAMENT' => $lang[ 'rivals_1qqxs' ],
		'U_ADDTOURNAMENT' => append_sid ( 'rivals.php?action=acp&mode=add_tournament' ),
		'L_EDITTOURNAMENTS' => $lang[ 'rivals_1qqxe' ],
		'U_EDITTOURNAMENTS' => append_sid ( 'rivals.php?action=acp&mode=edit_tournament' ) )
	);

	$template->set_filenames ( array (
		'body' => 'rivals/acp.tpl' )
	);

	$template->pparse ( 'body' );
}

include ( $phpbb_root_path . 'includes/page_tail.'.$phpEx );

?>
