<?php
##############################################################
# FILENAME  : install_rivals.php
# COPYRIGHT : (c) 2006, Tyler N. King <aibotca@yahoo.ca>
# GPL v2.0 or later. See docs/COPYING.
##############################################################
# This program is free software; you can redistribute it 
# and/or modify it under the terms of the GNU General Public 
# License as published by the Free Software Foundation; 
# either version 2 of the License, or (at your option) 
# any later version.
#
# This program is distributed in the hope that it will be 
# useful, but WITHOUT ANY WARRANTY; without even the implied 
# warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
# PURPOSE. See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public 
# License along with this program; if not, write to the 
# Free Software Foundation, Inc., 51 Franklin St, Fifth Floor, 
# Boston, MA  02110-1301  USA
##############################################################
define('IN_PHPBB', true);
$phpbb_root_path	= './';
include($phpbb_root_path . 'extension.inc');
include($phpbb_root_path . 'common.'.$phpEx);

$userdata	= session_pagestart ( $user_ip, PAGE_INDEX );
init_userprefs ( $userdata );

$page_title	= 'phpBB Rivals Installation';
include ( $phpbb_root_path . 'includes/page_header.'.$phpEx );

if ( $userdata[ 'user_level' ] != ADMIN )
{
	message_die ( GENERAL_MESSAGE, 'Only administrators may install this modification.' );
}

$sql		= array ( );
$sql[ 0 ]	= "CREATE TABLE `" . $table_prefix . "clans` (
  `clan_id` int(1) NOT NULL auto_increment,
  `clan_name` text NOT NULL,
  `clan_tag` text NOT NULL,
  `clan_tournaments` text NOT NULL,
  `clan_contact` text NOT NULL,
  `clan_issues` int(1) NOT NULL,
  `clan_members` text NOT NULL,
  `clan_logo` text NOT NULL,
  `clan_wrounds` text NOT NULL,
  `clan_lrounds` text NOT NULL,
  `clan_win` int(1) NOT NULL default '0',
  `clan_loss` int(1) NOT NULL default '0',
  `clan_ratio` text NOT NULL,
  `clan_owner` int(1) NOT NULL default '0',
  `clan_ownerb` int(1) NOT NULL default '0',
  `ladder_joined` int(1) NOT NULL default '0',
  `clan_score` int(1) NOT NULL default '0',
  `clan_streak` int(1) NOT NULL default '0',
  PRIMARY KEY  (`clan_id`)
);";
$sql[ 1 ]	= "CREATE TABLE `" . $table_prefix . "challenges` (
  `challenge_id` int(1) NOT NULL auto_increment,
  `challenger` int(1) NOT NULL,
  `challengee` int(1) NOT NULL,
  `challenge_status` int(1) NOT NULL,
  `challenge_time` text NOT NULL,
  `challenge_extra` text NOT NULL,
  `challenge_rounds` int(1) NOT NULL,
  `c_rounds` text NOT NULL,
  `c_wrounds` text NOT NULL,
  `c_lrounds` text NOT NULL,
  `ce_wrounds` text NOT NULL,
  `ce_lrounds` text NOT NULL,
  `ce_rounds` text NOT NULL,
  `challenge_winner` int(1) NOT NULL,
  `challenge_looser` int(1) NOT NULL,
  PRIMARY KEY  (`challenge_id`)
);";
$sql[ 2 ]	= "CREATE TABLE `" . $table_prefix . "ladders` (
  `ladder_id` int(1) NOT NULL auto_increment,
  `ladder_name` text NOT NULL,
  `ladder_scoring` int(1) NOT NULL default '0',
  `ladder_issueslt` text NOT NULL,
  `ladder_desc` text NOT NULL,
  `ladder_rank` int(1) NOT NULL default '0',
  `ladder_rules` text NOT NULL,
  `ladder_issues` text NOT NULL,
  `ladder_f1` text NOT NULL,
  `ladder_f2` text NOT NULL,
  `ladder_rating` text NOT NULL,
  `ladder_order` text NOT NULL,
  `subladder_order` text NOT NULL,
  `ladder_parent` int(1) NOT NULL default '0',
  `platform` int(1) NOT NULL default '0',
  PRIMARY KEY  (`ladder_id`)
);";
$sql[ 3 ]	= "CREATE TABLE `" . $table_prefix . "platforms` (
  `platform_id` int(1) NOT NULL auto_increment,
  `platform_name` text NOT NULL,
  PRIMARY KEY  (`platform_id`)
);";
$sql[ 4 ]	= "CREATE TABLE `" . $table_prefix . "rivalsconfig` (
  `ticket_recivers` text NOT NULL,
  `ticket_one` int(1) NOT NULL default '0'
);";
$sql[ 5 ]	= "ALTER TABLE `" . $table_prefix . "users` ADD `clan_session` INT( 1 ) NOT NULL ;";
$sql[ 6 ]	= "CREATE TABLE `" . $table_prefix . "tournaments` (
  `tournament_id` int(1) NOT NULL auto_increment,
  `tournament_name` text NOT NULL,
  `tournament_brackets` text NOT NULL,
  `tournament_status` int(1) NOT NULL,
  `tournament_type` int(1) NOT NULL,
  `tournament_rm` int(1) NOT NULL,
  `tournament_dbllw` int(1) NOT NULL,
  `tournament_dblww` int(1) NOT NULL,
  `tournament_clans2` text NOT NULL,
  `tournament_exemptions` text NOT NULL,
  `tournament_state` int(1) NOT NULL,
  `tournament_password` text NOT NULL,
  `tournament_clans` text NOT NULL,
  `tournament_winner` text NOT NULL,
  `tournament_info` text NOT NULL,
  PRIMARY KEY  (`tournament_id`)
);";
$sql[ 7 ]	= "CREATE TABLE `" . $table_prefix . "sponsors` (
  `sponsor_id` int(1) NOT NULL auto_increment,
  `sponsor_image` text NOT NULL,
  `sponsor_desc` text NOT NULL,
  `sponsor_url` text NOT NULL,
  `sponsor_tournament` int(1) NOT NULL,
  PRIMARY KEY  (`sponsor_id`)
);";
$sql[ 8 ]	= "ALTER TABLE `" . $table_prefix . "users` ADD `user_stats` INT( 1 ) NOT NULL ;";
$sql[ 9 ]	= "CREATE TABLE `" . $table_prefix . "invites` (
`invite_id` INT( 1 ) NOT NULL AUTO_INCREMENT PRIMARY KEY ,
`invite_clan` TEXT NOT NULL ,
`invite_to` TEXT NOT NULL
) ;";
$sql[ 9 ]	= "CREATE TABLE `" . $table_prefix . "clanmessages` (
`msg_id` INT( 1 ) NOT NULL AUTO_INCREMENT PRIMARY KEY ,
`msg_subject` TEXT NOT NULL ,
`msg` LONGTEXT NOT NULL ,
`msg_to` TEXT NOT NULL ,
`msg_from` TEXT NOT NULL ,
`msg_time` TEXT NOT NULL
);";
$sql[ 10 ]	= "INSERT INTO `" . $table_prefix . "rivalsconfig` (
`ticket_recivers`,
`ticket_one`) VALUES (
'2',
'0');";
$sql[ 11 ]	= "INSERT INTO `" . $table_prefix . "groups` (
`group_id`,
`group_type`,
`group_name`,
`group_moderator` ) VALUES (
'NULL',
'0',
'ByPass Words',
'2' );";

$i		= 0;
$code		= '<table class="forumline" width="100%" cellpadding="2" cellspacing="1">';
foreach ( $sql AS $query )
{
	$i++;
	$color	= ( $i % 2 ) ? 'row1' : 'row2';

	if ( ! ( $result = $db->sql_query ( $query ) ) )
	{
		$error	= $db->sql_error();
		$code	.= '<tr class="gensmall"><td width="100" class="' . $color . '" align="center" valign="middle"><b>#' . $i . '</b></td><td class="' . $color . '"><b>>></b> ' . $query . '<br /><b>>>>></b> <font color="#FF0000">' . $error[ 'message' ] . '</font></td></tr>';
	}
	else
	{
		$code	.= '<tr class="gensmall"><td width="100" class="' . $color . '" align="center" valign="middle"><b>#' . $i . '</b></td><td class="' . $color . '"><b>>></b> ' . $query . '<br /><b>>>>></b> <font color="#00AA00">Successful</font></td></tr>';
	}
}

$code	.= '<tr><td class="catBottom" height="28" colspan="2">&nbsp;</td></tr><tr><th colspan="2">Installation Complete</th></tr><tr class="genmed"><td class="row2" colspan="2">Please be sure to delete this file now.<br />If you require any further assistance, please visit <a href="http://www.phpbb.com/">phpBB.com Support Forums</a> or <a href="http://www.gotbase.org/">GotBase?</a>.</span></td></tr><tr><td class="catBottom" height="28" align="center" colspan="2"><span class="genmed"><a href="' . append_sid ( 'index.php' ) . '" class="forumlink">Go back to your index page</a>.</td></table>';

print $code;

include ( $phpbb_root_path . 'includes/page_tail.'.$phpEx );

?>
