#!/usr/bin/python
import unittest
import os
from testsPath import *
from config import VERSION
from SoundDevice import *
from OBBSongDocument import *
from OBBSongCreator import *


class obbSoundDeviceInitTest(unittest.TestCase):
    """obbSoundDeviceInitTest : tests if device inits."""
    def runTest(self):
        soundDevice = SoundDevice()
        self.failUnless( soundDevice != None )

class obbSoundDeviceLoadBadFileNameTest(unittest.TestCase):
    """obbSoundDeviceLoadBadFileNameTest : must specify correct file name."""
    def runTest(self):
        soundDevice = SoundDevice()
        soundDevice.setVolume(1)
        self.failUnlessRaises(Exception, soundDevice.load, "troum")

class obbSoundDevicePlayLoadedFileTest(unittest.TestCase):
    """obbSoundDevicePlayLoadedFileTest : device only plays loaded file """
    def runTest(self):
        soundDevice = SoundDevice()
        soundDevice.setVolume(1)
        self.failIf(soundDevice.playLoadedSample == 1)

class obbSoundDevicePlayTest(unittest.TestCase):
    """obbSoundDevicePlayTest : tests if device plays on the fly."""
    def runTest(self):
        soundDevice = SoundDevice()
        soundDevice.setVolume(1)
        soundDevice.play("../../sounds/hat03.wav")

class obbSoundDeviceDontPlayTest(unittest.TestCase):
    """obbSoundDeviceDontPlayTest : tests if device plays nothing."""
    def runTest(self):
        soundDevice = SoundDevice()
        soundDevice.setVolume(1)
        self.failUnlessRaises(Exception, soundDevice.play, "wav")

class obbSoundDevicePlayInBackGroundTest(unittest.TestCase):
    """obbSoundDevicePlayInBackGroundTest : device must play in background."""
    def runTest(self):
        songDocument = OBBSongDocument()
        songDocument.setSample("../../sounds/hat03.wav")
        soundDevice = SoundDevice()
        soundDevice.setVolume(1)
        soundDevice.load(songDocument)
        soundDevice.playLoadedSample()

class createWavFileTest(unittest.TestCase):
    """createWavFileTest : tests csound and the torturer."""
    def runTest(self):
        songCreator = OBBSongCreator()
        songCreator.newSongDocument()
        songCreator.setInstrument(0, "../../sounds/hat03.wav" )
        songCreator.addHit(0, 0)
        self.failIf(songCreator.makeSample() == None)
        songCreator.cleanUpTemporaryFiles()

class obbFilesLeftTest(unittest.TestCase):
    def runTest(self):
        for testFile in listdir("/tmp"):
            self.failIf(testFile[len(testFile)-4:len(testFile)] == ".wav")
            self.failIf(testFile[len(testFile)-4:len(testFile)] == ".orc")
            self.failIf(testFile[len(testFile)-4:len(testFile)] == ".sco")

def suite():
    testSuite = unittest.TestSuite()
    testSuite.addTest(obbSoundDeviceInitTest())
    testSuite.addTest(obbSoundDeviceLoadBadFileNameTest())
    testSuite.addTest(obbSoundDeviceDontPlayTest())
    testSuite.addTest(obbSoundDevicePlayLoadedFileTest())
    testSuite.addTest(obbSoundDevicePlayTest())
    testSuite.addTest(obbSoundDevicePlayInBackGroundTest())
    testSuite.addTest(createWavFileTest())
    testSuite.addTest(obbFilesLeftTest())
    return testSuite
