#   Copyright (C) 2002 Yannick Gingras <ygingras@ygingras.net>
#   Copyright (C) 2002 Vincent Barbin <vbarbin@openbeatbox.org>

#   This file is part of Open Beat Box.

#   Open Beat Box is free software; you can redistribute it and/or modify
#   it under the terms of the GNU General Public License as published by
#   the Free Software Foundation; either version 2 of the License, or
#   (at your option) any later version.

#   Open Beat Box is distributed in the hope that it will be useful,
#   but WITHOUT ANY WARRANTY; without even the implied warranty of
#   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#   GNU General Public License for more details.

#   You should have received a copy of the GNU General Public License
#   along with Open Beat Box; if not, write to the Free Software
#   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA


from os import *
from qt import *
from soundPath import *
from OBBCSoundTorturer import *


class OBBSongCreator(QObject):
    def __init__(self, parent=None):
        QObject.__init__(self, parent)
        self.hitPerCycle = 8

    def setHitPerCycle(self, hitPerCycle):
        self.hitPerCycle = hitPerCycle

    def AddInstrument(self, songDocument, samplePattern, sampleName):
        songDocument.songOrchestra.Add(samplePattern, sampleName)


    def RemoveInstrument(self, songDocument):
        songDocument.songOrchestra.Delete(samplePattern)


    def AddHit(self, songDocument, hitPattern, hitPosition):
        songDocument.songScore.Add( hitPattern,
                                    hitPosition )


    def RemoveHit(self, songDocument, hitPattern, hitPosition):
        songDocument.songScore.Delete( hitPattern,
                                       hitPosition )


    def ToggleHit(self, songDocument, hitPattern, hitPosition):
        if songDocument.songScore.isIn( hitPattern,
                                        hitPosition ):
            self.RemoveHit(songDocument, hitPattern, hitPosition)
        else:
            self.AddHit(songDocument, hitPattern, hitPosition)
        songDocument.songScore.printScore()


    def MakeSample(self, songDocument):
        #Sould always validate used synthetisor
        #before proceeding with advanced sample
        #creation
        #                             --VBarbin

        self.recorder = OBBCSoundTorturer()

        self.recorder.CreateOrchestraFile(songDocument.songOrchestra)
        self.recorder.CreateScoreFile(songDocument.songScore, songDocument.songOrchestra, songDocument.GetTempo())

        self.returnValue = self.recorder.createWaveFile()
        self.emit(PYSIGNAL("createSample()"), (self.returnValue,))
        return self.returnValue


    def HandleSongChange(self, songDocument, patternId, hitId):
        self.ToggleHit(songDocument, patternId, hitId)


    def HandleHit(self, songDocument, hitId):
        if hitId == self.hitPerCycle-1:
            self.MakeSample(songDocument)
