#! /usr/bin/python

#   Copyright (C) 2002 Yannick Gingras <ygingras@ygingras.net>
#   Copyright (C) 2002 Vincent Barbin <vbarbin@openbeatbox.org>

#   This file is part of Open Beat Box.

#   Open Beat Box is free software; you can redistribute it and/or modify
#   it under the terms of the GNU General Public License as published by
#   the Free Software Foundation; either version 2 of the License, or
#   (at your option) any later version.

#   Open Beat Box is distributed in the hope that it will be useful,
#   but WITHOUT ANY WARRANTY; without even the implied warranty of
#   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#   GNU General Public License for more details.

#   You should have received a copy of the GNU General Public License
#   along with Open Beat Box; if not, write to the Free Software
#   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA


from qt import *
from soundPath import *
from OBBConstants import *
from OBBFuncts import *
from wave import *
from os import *

class BackgroundPlayer(QThread):
    def __init__(self, parent):
        QThread.__init__(self)
        self.parent = parent

    def run(self):
        self.parent.playThenTrash()

class PosixSoundDevice:
    def __init__(self):
        self.sampleFile = "troum"
        self.threads = []


    def Play(self, state = 1):
        self.cmd = "play " + self.sampleFile
        if state:
            self.cmd = self.cmd + " &"
        system(self.cmd)


    def Load(self, sample):
        if access(sample, R_OK):
            self.sampleFile = sample
        else:
            raise Exception("wav file not found.")

    def playThenTrash(self):
        # save the file path to be able to load another one in the
        # mean time
        sampleFile = self.sampleFile
        self.Play(0)
        remove(sampleFile)

    def HandleHit(self, hitId):
        if hitId == 0:
            thread = BackgroundPlayer(self)
            self.threads.append(thread)
            # delete the finised threads
            thread.start()
            for thread in self.threads:
                if thread.finished():
                    self.threads.remove(thread)

    def HandleLoadSample(self, samplePath):
        print "Load"
        self.Load(samplePath)

