/*
 * Decompiled with CFR 0.152.
 */
package org.nongnu.multigraph;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.nongnu.multigraph.Edge;

public class Node<N, L> {
    private Map<Node<N, L>, Map<L, Edge<N, L>>> edgelist = Collections.synchronizedMap(new HashMap());
    private Set<Edge<N, L>> all_edges = new HashSet<Edge<N, L>>();
    final N unode;

    Node(N n) {
        this.unode = n;
    }

    void set(Node<N, L> node, int n, L l) {
        Edge<N, L> edge;
        Map<L, Edge<N, L>> map = this.edgelist.get(node);
        assert (node != null);
        assert (l != null);
        if (map != null && (edge = map.get(l)) != null) {
            edge.set_weight(n);
            return;
        }
        if (map == null) {
            map = new HashMap<L, Edge<N, L>>();
            this.edgelist.put(node, map);
        }
        edge = new Edge<N, L>(this.unode, node.unode, n, l);
        this.all_edges.add(edge);
        map.put(l, edge);
    }

    private boolean _remove(Node<N, L> node, L l, boolean bl, Iterator<Node<N, L>> iterator) {
        Map<L, Edge<N, L>> map = this.edgelist.get(node);
        assert (node != null);
        if (map == null) {
            return false;
        }
        Edge<N, L> edge = map.get(l);
        if (l != null && map.remove(l) != null) {
            assert (this.all_edges.size() > 0);
            boolean bl2 = this.all_edges.remove(edge);
            if (map.size() == 0) {
                if (iterator == null) {
                    return this.edgelist.remove(node) != null;
                }
                iterator.remove();
            }
            return true;
        }
        if (!bl) {
            return false;
        }
        this.all_edges.removeAll(map.values());
        map.clear();
        if (iterator == null) {
            return this.edgelist.remove(node) != null;
        }
        iterator.remove();
        return true;
    }

    boolean remove(Node<N, L> node, L l) {
        assert (node != null);
        assert (l != null);
        return this._remove(node, l, false, null);
    }

    boolean remove(Node<N, L> node) {
        assert (node != null);
        boolean bl = true;
        for (Edge<N, L> edge : this.edges(node)) {
            if (this._remove(node, edge.label(), false, null)) continue;
            bl = false;
        }
        return bl;
    }

    boolean clear() {
        boolean bl = true;
        Iterator<Node<N, L>> iterator = this.edgelist.keySet().iterator();
        while (iterator.hasNext()) {
            if (this._remove(iterator.next(), null, true, iterator)) continue;
            bl = false;
        }
        return bl;
    }

    int nodal_outdegree() {
        return this.edgelist.size();
    }

    int edge_outdegree() {
        return this.all_edges.size();
    }

    Collection<Map<L, Edge<N, L>>> edgelist() {
        return this.edgelist.values();
    }

    Set<Edge<N, L>> edges() {
        return this.all_edges;
    }

    Collection<Edge<N, L>> edges(Node<N, L> node) {
        if (node == null) {
            throw new NullPointerException("Node get requires non-null argument");
        }
        Map<L, Edge<N, L>> map = this.edgelist.get(node);
        if (map == null) {
            return Collections.EMPTY_SET;
        }
        return map.values();
    }

    boolean isLinked(Node<N, L> node) {
        if (node == null) {
            throw new NullPointerException("Node get requires non-null argument");
        }
        return this.edgelist.containsKey(node);
    }

    public String toString() {
        return this.unode.toString();
    }
}

