/*
 * Decompiled with CFR 0.152.
 */
package org.nongnu.multigraph.rewire;

import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Random;
import org.nongnu.multigraph.EdgeLabeler;
import org.nongnu.multigraph.Graph;
import org.nongnu.multigraph.debug;
import org.nongnu.multigraph.rewire.Rewire;

public class ScaleFreeRewire<N, E>
extends Rewire<N, E> {
    protected Random r = new Random();
    protected N[] nodes;
    protected int m = 1;
    protected int a = 0;
    m_modes m_mode = m_modes.STRICT;

    public int m() {
        return this.m;
    }

    public ScaleFreeRewire<N, E> m(int m) {
        if (m >= this.graph.size()) {
            throw new IllegalArgumentException("m must be less than the graph size");
        }
        if (m <= 0) {
            throw new IllegalArgumentException("m must be >= 1");
        }
        this.m = m;
        return this;
    }

    public int a() {
        return this.a;
    }

    public ScaleFreeRewire<N, E> a(int a) {
        if (a < 0) {
            throw new IllegalArgumentException("a must be >= 0");
        }
        this.a = a;
        return this;
    }

    public m_modes m_mode() {
        return this.m_mode;
    }

    public ScaleFreeRewire<N, E> m_mode(m_modes m_mode) {
        this.m_mode = m_mode;
        return this;
    }

    public ScaleFreeRewire<N, E> m_mode(String m_mode) {
        this.m_mode(m_modes.valueOf(m_mode.toUpperCase()));
        return this;
    }

    protected void _init_nodes() {
        this.nodes = new Object[this.graph.size()];
        int i = 0;
        for (Object n : this.graph.random_node_iterable()) {
            this.nodes[i++] = n;
        }
    }

    public ScaleFreeRewire(Graph<N, E> graph, EdgeLabeler<N, E> el) {
        super(graph, el);
    }

    protected static boolean m_mode_stop(m_modes m_mode, int m, int added, int pass) {
        if (pass > Math.max(10, m * 10)) {
            debug.printf("hit hard-limit on passes! mode/m/added/pass: %s/%d/%d/%d\n", m_mode.name(), m, added, pass);
            return true;
        }
        switch (m_mode) {
            case STRICT: {
                return added >= m;
            }
            case MIN: {
                return pass > 0 && added >= m;
            }
            case MAX: {
                return pass > 0 && added >= 1 || added >= m;
            }
        }
        return true;
    }

    protected boolean consider_link(N to_add, N vi, long numlinks) {
        int ki = this.graph.nodal_outdegree(vi);
        debug.printf("\tvi: %s, ki: %d\n", vi, ki);
        float fr = this.r.nextFloat();
        float pi = (float)(this.a + ki) / (float)(2L * numlinks);
        return fr <= pi;
    }

    protected void link_added(N added, N vi) {
        debug.printf("link added: %s -> %s\n", added, vi);
    }

    protected void m0() {
        for (int i = 1; i < this.m + 1; ++i) {
            this.graph.set(this.nodes[i - 1], this.nodes[i], this.el.getLabel(this.nodes[i - 1], this.nodes[i]));
            this.link_added(this.nodes[i - 1], this.nodes[i]);
        }
    }

    protected Iterator<N> nodes_iterator(final int split) {
        return new Iterator<N>(){
            int i = 0;

            @Override
            public boolean hasNext() {
                return this.i < split;
            }

            @Override
            public N next() {
                if (this.i >= split) {
                    throw new NoSuchElementException();
                }
                return ScaleFreeRewire.this.nodes[this.i++];
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    protected int rewire_callback(int split, int numlinks) {
        return 0;
    }

    @Override
    public void rewire() {
        int links = this.m;
        this.graph.clear_all_edges();
        this._init_nodes();
        this.m0();
        for (int split = this.m + 1; split < this.nodes.length; ++split) {
            N to_add = this.nodes[split];
            final int tmpsplit = split;
            debug.println("to_add: " + to_add);
            links += this.add(to_add, links, new Iterable<N>(){

                @Override
                public Iterator<N> iterator() {
                    return ScaleFreeRewire.this.nodes_iterator(tmpsplit);
                }
            });
            links += this.rewire_callback(split, links);
        }
    }

    protected boolean add_link(N to_add, N to) {
        debug.printf("%s to %s\n", to_add, to);
        if (this.graph.is_linked(to_add, to)) {
            return false;
        }
        this.graph.set(to_add, to, this.el.getLabel(to_add, to));
        this.link_added(to_add, to);
        return true;
    }

    protected int add(N to_add, long numlinks, Iterable<N> iter) {
        int added = 0;
        int pass = 0;
        debug.printf("toadd %s\n", to_add);
        block0: do {
            for (N node : iter) {
                if (ScaleFreeRewire.m_mode_stop(this.m_mode, this.m, added, pass)) continue block0;
                if (to_add == node || this.graph.is_linked(to_add, node) || !this.consider_link(to_add, node, numlinks) || !this.add_link(to_add, node)) continue;
                ++added;
            }
        } while (!ScaleFreeRewire.m_mode_stop(this.m_mode, this.m, added, ++pass));
        return added;
    }

    @Override
    public void add(N to_add) {
        this.add(to_add, this.graph.link_count(), this.graph.random_node_iterable());
    }

    public static enum m_modes {
        STRICT,
        MIN,
        MAX;

    }
}

