/*
 * Decompiled with CFR 0.152.
 */
package org.nongnu.multigraph.rewire;

import org.nongnu.multigraph.EdgeLabeler;
import org.nongnu.multigraph.Graph;
import org.nongnu.multigraph.rewire.Rewire;

public class LatticeRewire<N, E>
extends Rewire<N, E> {
    int cols;

    public LatticeRewire(Graph<N, E> graph, EdgeLabeler<N, E> el, int cols) {
        super(graph, el);
        this.cols = cols > 0 ? cols : (int)Math.sqrt(graph.size());
    }

    public LatticeRewire(Graph<N, E> graph, EdgeLabeler<N, E> el) {
        super(graph, el);
        this.cols = (int)Math.sqrt(graph.size());
    }

    @Override
    public void rewire() {
        Object[] prevrow = new Object[this.cols];
        Object pn = null;
        int i = 0;
        this.graph.clear_all_edges();
        for (Object n : this.graph) {
            Object label;
            if (pn != null && (label = this.el.getLabel(pn, n)) != null) {
                this.graph.set(pn, n, label);
            }
            if (prevrow[i] != null && (label = this.el.getLabel(prevrow[i], n)) != null) {
                this.graph.set(prevrow[i], n, label);
            }
            prevrow[i] = n;
            pn = n;
            ++i;
            if ((i %= this.cols) != 0) continue;
            pn = null;
        }
    }
}

