/*
 * Decompiled with CFR 0.152.
 */
package org.nongnu.multigraph.layout;

import java.awt.Dimension;
import java.lang.reflect.Constructor;
import org.nongnu.multigraph.Graph;
import org.nongnu.multigraph.layout.PositionableNode;

public abstract class Layout<N extends PositionableNode, L> {
    Graph<N, L> graph;
    int maxiterations;
    Dimension bound;
    int border;

    public Layout(Graph<N, L> graph, Dimension dimension, int n) {
        this.graph = graph;
        this.maxiterations = n;
        this.bound = dimension;
    }

    public abstract boolean layout(float var1);

    protected static boolean isaLayout(String string) {
        try {
            Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            return false;
        }
        return true;
    }

    private static <N extends PositionableNode, L> Constructor<? extends Layout<N, L>> factory_con(String string) {
        Class<?> clazz = null;
        Constructor<?> constructor = null;
        try {
            clazz = Class.forName(string);
        }
        catch (Exception exception) {
            System.out.println("Client class doesn't exist: ");
            System.out.println(exception);
            System.exit(1);
        }
        if (clazz == null) {
            return null;
        }
        try {
            constructor = clazz.getConstructor(Graph.class, Dimension.class, Integer.TYPE);
        }
        catch (Exception exception) {
            System.out.println("Error settting up client class: ");
            System.out.println(exception.toString());
            System.exit(1);
        }
        if (constructor == null) {
            return null;
        }
        return constructor;
    }

    public static final <N extends PositionableNode, L> Layout<N, L> factory(String string, Graph<N, L> graph, Dimension dimension, int n) {
        Layout<N, L> layout = null;
        Constructor<Layout<N, L>> constructor = Layout.factory_con(Layout.class.getPackage().getName() + "." + string + "Layout");
        try {
            layout = constructor.newInstance(graph, dimension, n);
        }
        catch (Exception exception) {
            System.out.println("Error creating instance of client class: ");
            System.out.println(exception.toString());
            System.exit(1);
        }
        return layout;
    }
}

