// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
// Mobius Forensic Toolkit
// Copyright (C) 2008,2009,2010,2011,2012,2013,2014,2015,2016,2017,2018,2019,2020,2021,2022 Eduardo Aguiar
//
// This program is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the
// Free Software Foundation; either version 2, or (at your option) any later
// version.
//
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General
// Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program. If not, see <http://www.gnu.org/licenses/>.
// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
#include "evidence.h"

namespace mobius
{
namespace model
{
// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
//! \brief Create new evidence
//! \param type Evidence type
//! \return Evidence
// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
evidence
item::_new_evidence (const std::string& type)
{
  auto db = get_database ();

  auto stmt = db.new_statement (
                "INSERT INTO evidence "
                     "VALUES (NULL, ?, ?)");

  stmt.bind (1, get_uid ());
  stmt.bind (2, type);
  stmt.execute ();

  auto uid = db.get_last_insert_row_id ();
  return evidence (*this, uid, type);
}

// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
//! \brief Remove evidences
//! \param type Evidence type
// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
void
item::_remove_evidences (const std::string& type)
{
  auto db = get_database ();

  auto stmt = db.new_statement (
                "DELETE FROM evidence "
                      "WHERE item_uid = ? "
                        "AND type = ?");

  stmt.bind (1, get_uid ());
  stmt.bind (2, type);
  stmt.execute ();
}

// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
//! \brief Count evidences
//! \param type Evidence type
// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
std::int64_t
item::_count_evidences (const std::string& type) const
{
  auto db = get_database ();

  auto stmt = db.new_statement (
                "SELECT count (*) "
                  "FROM evidence "
                 "WHERE item_uid = ? "
                   "AND type = ?");

  stmt.bind (1, get_uid ());
  stmt.bind (2, type);
  
  std::int64_t count = 0;

  if (stmt.fetch_row ())
    count = stmt.get_column_int64 (0);

  return count;
}

} // namespace model
} // namespace mobius
