# =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
# Mobius Forensic Toolkit
# Copyright (C) 2008,2009,2010,2011,2012,2013,2014,2015,2016,2017,2018,2019 Eduardo Aguiar
#
# This program is free software; you can redistribute it and/or modify it
# under the terms of the GNU General Public License as published by the
# Free Software Foundation; either version 2, or (at your option) any later
# version.
#
# This program is distributed in the hope that it will be useful, but
# WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General
# Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program. If not, see <http://www.gnu.org/licenses/>.
# =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
import mobius
import pymobius
import pymobius.util
import pymobius.app.chromium
import sqlite3
import binascii
import os

# =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
# @brief Load data from Cookies file
# =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
def decode (f):

  # create data object
  data = pymobius.Data ()
  data.cookies = []

  # create local file  
  path = pymobius.app.chromium.retrieve_db_file (f)

  if path:

    # get meta version
    db = sqlite3.connect (path)
    db.text_factory = str
    data.version = pymobius.app.chromium.get_meta_version (db)

    if data.version:
      mobius.core.log ('app.chromium: Cookies.version = %s' % data.version)

    decode_cookies (db, data, f)
    db.close ()
    os.remove (path)

  # return data object
  return data

# =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
# @brief Retrieve data from cookies table
# =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
def decode_cookies (db, data, f):
  if data.version <= 5:
    decode_cookies_5 (db, data, f)

  else:
    decode_cookies_7 (db, data, f)

# =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
# @brief Retrieve data from cookies table
# Tested versions: 5
# =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
def decode_cookies_5 (db, data, f):
  cursor = db.cursor ()

  stmt = '''
       SELECT _rowid_,
              host_key,
              name,
              value,
              last_access_utc,
              creation_utc
         FROM cookies'''

  for row in cursor.execute (stmt):
    entry = pymobius.Data ()
    entry.id = row[0]
    entry.domain = row[1]
    entry.name = row[2]
    entry.value = row[3]
    entry.is_encrypted = False
    entry.last_access_time = mobius.datetime.new_datetime_from_nt_timestamp (row[4] * 10)
    entry.creation_time = mobius.datetime.new_datetime_from_nt_timestamp (row[5] * 10)
    entry.evidence_path = f.path
    entry.is_deleted = f.is_deleted

    data.cookies.append (entry)

# =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
# @brief Retrieve data from cookies table
# Tested versions: 7-10
# @todo Decrypt encrypted_value using DPAPI
# =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
def decode_cookies_7 (db, data, f):
  cursor = db.cursor ()

  stmt = '''
       SELECT _rowid_,
              host_key,
              name,
              encrypted_value,
              last_access_utc,
              creation_utc
         FROM cookies'''

  for row in cursor.execute (stmt):
    entry = pymobius.Data ()
    entry.id = row[0]
    entry.domain = row[1]
    entry.name = row[2]
    entry.value = binascii.hexlify (row[3])
    entry.is_encrypted = True
    entry.last_access_time = mobius.datetime.new_datetime_from_nt_timestamp (row[4] * 10)
    entry.creation_time = mobius.datetime.new_datetime_from_nt_timestamp (row[5] * 10)
    entry.evidence_path = f.path
    entry.is_deleted = f.is_deleted

    data.cookies.append (entry)
