// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
// Mobius Forensic Toolkit
// Copyright (C) 2008,2009,2010,2011,2012,2013,2014,2015,2016,2017 Eduardo Aguiar
//
// This program is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the
// Free Software Foundation; either version 2, or (at your option) any later
// version.
//
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General
// Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program. If not, see <http://www.gnu.org/licenses/>.
// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=

// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
//! \brief C++ API module wrapper
//! \author Eduardo Aguiar
// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
#include "filesystem_ntfs.h"
#include "filesystem.h"
#include "api_datetime.h"
#include "api_metadata.h"

// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
//!\brief filesystem_ntfs: tp_dealloc
// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
static void
tp_dealloc (filesystem_filesystem_ntfs_o *self)
{
  delete self->obj;
  self->ob_type->tp_free ((PyObject*) self);
}

// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
//!\brief filesystem_ntfs: oem_name getter
// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
static PyObject *
tp_getter_oem_name (filesystem_filesystem_ntfs_o *self)
{
  return PyString_FromString (self->obj->get_oem_name ().c_str ());
}

// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
//!\brief filesystem_ntfs: sectors getter
// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
static PyObject *
tp_getter_sectors (filesystem_filesystem_ntfs_o *self)
{
  return PyLong_FromUnsignedLongLong (self->obj->get_sectors ());
}

// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
//!\brief filesystem_ntfs: sector_size getter
// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
static PyObject *
tp_getter_sector_size (filesystem_filesystem_ntfs_o *self)
{
  return PyLong_FromUnsignedLong (self->obj->get_sector_size ());
}

// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
//!\brief filesystem_ntfs: sectors_per_cluster getter
// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
static PyObject *
tp_getter_sectors_per_cluster (filesystem_filesystem_ntfs_o *self)
{
  return PyLong_FromUnsignedLong (self->obj->get_sectors_per_cluster ());
}

// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
//!\brief filesystem_ntfs: cluster_size getter
// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
static PyObject *
tp_getter_cluster_size (filesystem_filesystem_ntfs_o *self)
{
  return PyLong_FromUnsignedLong (self->obj->get_cluster_size ());
}

// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
//!\brief filesystem_ntfs: reserved_sectors getter
// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
static PyObject *
tp_getter_reserved_sectors (filesystem_filesystem_ntfs_o *self)
{
  return PyLong_FromUnsignedLong (self->obj->get_reserved_sectors ());
}

// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
//!\brief filesystem_ntfs: media_descriptor getter
// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
static PyObject *
tp_getter_media_descriptor (filesystem_filesystem_ntfs_o *self)
{
  return PyLong_FromUnsignedLong (self->obj->get_media_descriptor ());
}

// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
//!\brief filesystem_ntfs: sectors_per_track getter
// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
static PyObject *
tp_getter_sectors_per_track (filesystem_filesystem_ntfs_o *self)
{
  return PyLong_FromUnsignedLong (self->obj->get_sectors_per_track ());
}

// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
//!\brief filesystem_ntfs: heads getter
// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
static PyObject *
tp_getter_heads (filesystem_filesystem_ntfs_o *self)
{
  return PyLong_FromUnsignedLong (self->obj->get_heads ());
}

// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
//!\brief filesystem_ntfs: hidden_sectors getter
// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
static PyObject *
tp_getter_hidden_sectors (filesystem_filesystem_ntfs_o *self)
{
  return PyLong_FromUnsignedLongLong (self->obj->get_hidden_sectors ());
}

// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
//!\brief filesystem_ntfs: mft_cluster getter
// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
static PyObject *
tp_getter_mft_cluster (filesystem_filesystem_ntfs_o *self)
{
  return PyLong_FromUnsignedLongLong (self->obj->get_mft_cluster ());
}

// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
//!\brief filesystem_ntfs: mft_mirror_cluster getter
// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
static PyObject *
tp_getter_mft_mirror_cluster (filesystem_filesystem_ntfs_o *self)
{
  return PyLong_FromUnsignedLongLong (self->obj->get_mft_mirror_cluster ());
}

// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
//!\brief filesystem_ntfs: mft_offset getter
// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
static PyObject *
tp_getter_mft_offset (filesystem_filesystem_ntfs_o *self)
{
  return PyLong_FromUnsignedLongLong (self->obj->get_mft_offset ());
}

// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
//!\brief filesystem_ntfs: mft_mirror_offset getter
// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
static PyObject *
tp_getter_mft_mirror_offset (filesystem_filesystem_ntfs_o *self)
{
  return PyLong_FromUnsignedLongLong (self->obj->get_mft_mirror_offset ());
}

// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
//!\brief filesystem_ntfs: clusters_per_frs getter
// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
static PyObject *
tp_getter_clusters_per_frs (filesystem_filesystem_ntfs_o *self)
{
  return PyLong_FromUnsignedLong (self->obj->get_clusters_per_frs ());
}

// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
//!\brief filesystem_ntfs: frs_size getter
// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
static PyObject *
tp_getter_frs_size (filesystem_filesystem_ntfs_o *self)
{
  return PyLong_FromUnsignedLong (self->obj->get_frs_size ());
}

// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
//!\brief filesystem_ntfs: clusters_per_index_block getter
// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
static PyObject *
tp_getter_clusters_per_index_block (filesystem_filesystem_ntfs_o *self)
{
  return PyLong_FromUnsignedLong (self->obj->get_clusters_per_index_block ());
}

// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
//!\brief filesystem_ntfs: volume_serial_number getter
// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
static PyObject *
tp_getter_volume_serial_number (filesystem_filesystem_ntfs_o *self)
{
  return PyLong_FromUnsignedLongLong (self->obj->get_volume_serial_number ());
}

// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
//!\brief filesystem_ntfs: checksum getter
// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
static PyObject *
tp_getter_checksum (filesystem_filesystem_ntfs_o *self)
{
  return PyLong_FromUnsignedLong (self->obj->get_checksum ());
}

// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
//!\brief filesystem_ntfs: getters and setters structure
// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
static PyGetSetDef tp_getset[] =
{
  {
    (char *) "oem_name",
    (getter) tp_getter_oem_name,
    (setter) 0,
    (char *) "OEM name", NULL
  },
  {
    (char *) "sectors",
    (getter) tp_getter_sectors,
    (setter) 0,
    (char *) "number of sectors", NULL
  },
  {
    (char *) "sector_size",
    (getter) tp_getter_sector_size,
    (setter) 0,
    (char *) "sector size in bytes", NULL
  },
  {
    (char *) "sectors_per_cluster",
    (getter) tp_getter_sectors_per_cluster,
    (setter) 0,
    (char *) "sectors per cluster", NULL
  },
  {
    (char *) "cluster_size",
    (getter) tp_getter_cluster_size,
    (setter) 0,
    (char *) "cluster size in bytes", NULL
  },
  {
    (char *) "reserved_sectors",
    (getter) tp_getter_reserved_sectors,
    (setter) 0,
    (char *) "number of reserved sectors", NULL
  },
  {
    (char *) "media_descriptor",
    (getter) tp_getter_media_descriptor,
    (setter) 0,
    (char *) "media descriptor", NULL
  },
  {
    (char *) "sectors_per_track",
    (getter) tp_getter_sectors_per_track,
    (setter) 0,
    (char *) "sectors per track", NULL
  },
  {
    (char *) "heads",
    (getter) tp_getter_heads,
    (setter) 0,
    (char *) "number of heads", NULL
  },
  {
    (char *) "hidden_sectors",
    (getter) tp_getter_hidden_sectors,
    (setter) 0,
    (char *) "number of hidden sectors", NULL
  },
  {
    (char *) "mft_cluster",
    (getter) tp_getter_mft_cluster,
    (setter) 0,
    (char *) "$MFT cluster", NULL
  },
  {
    (char *) "mft_mirror_cluster",
    (getter) tp_getter_mft_mirror_cluster,
    (setter) 0,
    (char *) "$MFTMirr cluster", NULL
  },
  {
    (char *) "mft_offset",
    (getter) tp_getter_mft_offset,
    (setter) 0,
    (char *) "$MFT offset", NULL
  },
  {
    (char *) "mft_mirror_offset",
    (getter) tp_getter_mft_mirror_offset,
    (setter) 0,
    (char *) "$MFTMirr offset", NULL
  },
  {
    (char *) "clusters_per_frs",
    (getter) tp_getter_clusters_per_frs,
    (setter) 0,
    (char *) "clusters per file record segment", NULL
  },
  {
    (char *) "frs_size",
    (getter) tp_getter_frs_size,
    (setter) 0,
    (char *) "file record segment size in bytes", NULL
  },
  {
    (char *) "clusters_per_index_block",
    (getter) tp_getter_clusters_per_index_block,
    (setter) 0,
    (char *) "clusters per index block", NULL
  },
  {
    (char *) "volume_serial_number",
    (getter) tp_getter_volume_serial_number,
    (setter) 0,
    (char *) "volume serial number", NULL
  },
  {
    (char *) "checksum",
    (getter) tp_getter_checksum,
    (setter) 0,
    (char *) "checksum", NULL
  },
  {NULL, NULL, 0, NULL, NULL} // sentinel
};

// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
//!\brief filesystem_ntfs: type structure
// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
PyTypeObject filesystem_filesystem_ntfs_t =
{
  PyVarObject_HEAD_INIT (NULL, 0)
  "mobius.filesystem.filesystem_ntfs",        		// tp_name
  sizeof (filesystem_filesystem_ntfs_o),       		// tp_basicsize
  0,                                          		// tp_itemsize
  (destructor) tp_dealloc,	                     	// tp_dealloc
  0,                                          		// tp_print
  0,                                          		// tp_getattr
  0,                                          		// tp_setattr
  0,                                          		// tp_compare
  0,                                          		// tp_repr
  0,                                          		// tp_as_number
  0,                                          		// tp_as_sequence
  0,                                          		// tp_as_mapping
  0,                                          		// tp_hash
  0,                                          		// tp_call
  0,                                          		// tp_str
  0,                                          		// tp_getattro
  0,                                          		// tp_setattro
  0,                                          		// tp_as_buffer
  Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,   		// tp_flags
  "filesystem_ntfs class",                    		// tp_doc
  0,                                          		// tp_traverse
  0,                                          		// tp_clear
  0,                                          		// tp_richcompare
  0,                                          		// tp_weaklistoffset
  0,                                          		// tp_iter
  0,                                          		// tp_iternext
  0,                                 	          	// tp_methods
  0,                                          		// tp_members
  tp_getset,             	                      	// tp_getset
  &filesystem_filesystem_t,                    		// tp_base
  0,                                          		// tp_dict
  0,                                          		// tp_descr_get
  0,                                          		// tp_descr_set
  0,                                          		// tp_dictoffset
  0,                                          		// tp_init
  0,                                          		// tp_alloc
  0,                                          		// tp_new
  0,                                       		// tp_free
  0,                                       		// tp_is_gc
  0,                                       		// tp_bases
  0,                                       		// tp_mro
  0,                                       		// tp_cache
  0,                                       		// tp_subclasses
  0,                                       		// tp_weaklist
  0,                                       		// tp_del
  0,                                       		// tp_version_tag
};
