#ifndef __MOBIUS_TSK_FILESYSTEM_H__
#define __MOBIUS_TSK_FILESYSTEM_H__

// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
// Mobius Forensic Toolkit
// Copyright (C) 2008,2009,2010,2011,2012,2013,2014,2015,2016,2017 Eduardo Aguiar
//
// This program is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the
// Free Software Foundation; either version 2, or (at your option) any later
// version.
//
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General
// Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program. If not, see <http://www.gnu.org/licenses/>.
// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
#include <mobius/tsk/tsk.h>
#include <string>

struct TSK_FS_INFO;	// forward declaration

namespace mobius
{
namespace tsk
{

class diskimage;
class entry;

// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
//!\brief filesystem inside an imagefile
//!\author Eduardo Aguiar
// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
class filesystem
{
  TSK_FS_INFO *fs_info_p_;

public:
  filesystem (const diskimage&, offset_t);
  ~filesystem ();

  offset_t get_offset () const;
  inode_t get_inode_count () const;
  inode_t get_root_inode () const;
  inode_t get_first_inode () const;
  inode_t get_last_inode () const;
  const entry get_root_entry () const;
  const std::string get_id () const;
};

} // namespace tsk
} // namespace mobius

#endif
