// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
// Mobius Forensic Toolkit
// Copyright (C) 2008,2009,2010,2011,2012,2013,2014,2015,2016 Eduardo Aguiar
//
// This program is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the
// Free Software Foundation; either version 2, or (at your option) any later
// version.
//
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General
// Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program. If not, see <http://www.gnu.org/licenses/>.
// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
#include <mobius/datetime/timedelta.h>
#include <mobius/datetime/conv_julian.h>

namespace mobius
{
namespace datetime
{
static constexpr resolution_t SECONDS_OF_DAY = 86400;

// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
//! \brief add a timedelta to a datetime
//! \param dt datetime object
//! \param delta timedelta object
//! \return new datetime object
// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
const datetime
operator+ (const datetime& dt, const timedelta& delta)
{
  // add seconds
  time dt_time = dt.get_time ();

  resolution_t seconds = dt_time.to_day_seconds () + delta.get_seconds ();
  resolution_t days = (seconds / SECONDS_OF_DAY) + delta.get_days ();

  // create new datetime components
  date dt_date = dt.get_date ();

  date rdate (dt_date.get_year () + delta.get_years (),
              dt_date.get_month (),
              dt_date.get_day ());


  time rtime (seconds % SECONDS_OF_DAY);

  // return datetime
  return datetime (date_from_julian (date_to_julian (rdate) + days), rtime);
}

} // namespace mobius
} // namespace datetime
