# =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
# Mobius Forensic Toolkit
# Copyright (C) 2008 Eduardo Aguiar
#
# This program is free software; you can redistribute it and/or modify it
# under the terms of the GNU General Public License as published by the
# Free Software Foundation; either version 2, or (at your option) any later
# version.
#
# This program is distributed in the hope that it will be useful, but
# WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General
# Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program. If not, see <http://www.gnu.org/licenses/>.
# =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
import datetime

# =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
# @brief SVG icon
# =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
ICON_DATA = '''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'''

# =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
# @brief Extension class
# =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
class Extension (object):

  # =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
  # @brief Initialize extension
  # =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
  def __init__ (self, mediator):
    self.id = 'date-code'
    self.name = 'Date Code'
    self.author = 'Eduardo Aguiar'
    self.version = '0.1.0'
    self.description = 'Date code decoder'
    self.mediator = mediator
    self.icon_data = ICON_DATA

  # =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
  # @brief Start extension
  # =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
  def start (self):
    self.event_id = self.mediator.connect ('item.attribute-modified', self.on_item_attribute_modified)

  # =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
  # @brief Stop extension
  # =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
  def stop (self):
    self.mediator.disconnect (self.event_id)

  # =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
  # @brief Event handler: on_item_attribute_modified
  # =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
  def on_item_attribute_modified (self, item, attr, text, new_text):
    if attr == 'manufacturing_date' and 4 <= len (new_text) <= 5:
      Y = int (new_text[0:2])
      W = int (new_text[2:-1])
      D = int (new_text[-1:])

      # fiscal year begins at first saturday of July
      d = datetime.date (Y + 1999, 7, 1)
      if d.weekday () < 6:
        days_to_saturday = 5 - d.weekday ()
      else:
        days_to_saturday = 6
      d += datetime.timedelta (days=days_to_saturday)

      # Add date code's weeks and days
      d += datetime.timedelta (weeks=W - 1, days=D - 1)
      self.mediator.call ('item.set-attribute', item, attr, d.isoformat ())
