import mobius.file
import tarfile

# =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
# @brief Handle .tar (.tar.gz, .tar, .tar.bz2)
# =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
class TarFile (mobius.file.File):

  # =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
  # @brief TarFile stream
  # =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
  class Stream (object):
    def __init__ (self, member, parent):
      self.parent = parent
      self.member = member

    def export (self, path):
      fp = open (path, 'w')
      fp.write (self.parent.extractfile (self.member).read ())
      fp.close ()
      #self.parent.extract (self.member, path)

    def read (self):
      return self.parent.extractfile (self.member).read ()

  # =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
  # @brief Initialize tarfile
  # =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
  def __init__ (self, path=None):
    mobius.file.File.__init__ (self, path)
    try:
      self.fp = tarfile.open (path, 'r')

    except tarfile.TarError:
      raise Exception, 'invalid .tar file [%s]' % path

  # =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
  # @brief Get members of tarfile
  # =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
  def __iter__ (self):
    for i in self.fp.getmembers ():
      f = mobius.file.File ('%s/%s' % (self.path, i.name))
      f.parent = self
      f.stream = TarFile.Stream (i, self.fp)
      f.size = i.size
      f.mtime = i.mtime
      f.mode = i.mode
      f.uid = i.uid
      f.gid = i.gid
      f.uname = i.uname
      f.gname = i.gname
      f.origin = 'archive/tar'

      yield f
